/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.model.FxmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.NbDocument;

public class ErrorHintProvider
extends ParserResultTask<FxmlParserResult> {
    private FxmlParserResult result;
    private Document document;

    public void run(FxmlParserResult result, SchedulerEvent event) {
        Collection<ErrorMark> marks = result.getProblems();
        this.document = result.getSnapshot().getSource().getDocument(false);
        if (this.document == null) {
            return;
        }
        ArrayList<ErrorDescription> descs = new ArrayList<ErrorDescription>();
        for (ErrorMark m : marks) {
            try {
                descs.add(ErrorDescriptionFactory.createErrorDescription((Severity)(m.isError() ? Severity.ERROR : Severity.WARNING), (String)m.getMessage(), (Document)this.document, (Position)NbDocument.createPosition((Document)this.document, (int)m.getOffset(), (Position.Bias)Position.Bias.Forward), (Position)NbDocument.createPosition((Document)this.document, (int)(m.getOffset() + m.getLen()), (Position.Bias)Position.Bias.Forward)));
            }
            catch (BadLocationException ex) {}
        }
        HintsController.setErrors((Document)this.document, (String)"fxml-parsing", descs);
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new ErrorHintProvider());
        }
    }
}

