/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.status;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.status.VersioningPanelController;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(persistenceType=0, preferredID="GitVersioning")
public class GitVersioningTopComponent
extends TopComponent
implements Externalizable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private VersioningPanelController controller;
    private VCSContext context;
    private String contentTitle;
    private String branchTitle;
    public static final String PREFERRED_ID = "GitVersioning";
    private RepositoryInfo repositoryInfo;
    private static GitVersioningTopComponent instance;
    private File[] files = new File[0];

    public GitVersioningTopComponent() {
        this.putClientProperty("SlidingName", NbBundle.getMessage(GitVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        this.setName(NbBundle.getMessage(GitVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/git/resources/icons/versioning-view.png"));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GitVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.controller = new VersioningPanelController();
        this.controller.setActions((JComponent)((Object)this));
        this.add(this.controller.getPanel());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected void componentActivated() {
        this.updateTitle();
        this.controller.focus();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshContent();
    }

    protected void componentClosed() {
        this.controller.cancelRefresh();
        super.componentClosed();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.contentTitle);
        File[] files = this.context == null ? this.files : this.context.getRootFiles().toArray(new File[this.context.getRootFiles().size()]);
        out.writeObject(files);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.contentTitle = (String)in.readObject();
        this.files = (File[])in.readObject();
        final ArrayList<1> nodes = new ArrayList<1>(this.files.length);
        for (File file : this.files) {
            nodes.add(new AbstractNode(Children.LEAF, Lookups.singleton((Object)file)){

                public String getDisplayName() {
                    return ((File)this.getLookup().lookup(File.class)).getName();
                }
            });
        }
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    OpenProjects.getDefault().openProjects().get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    // empty catch block
                }
                final VCSContext ctx = VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()]));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (GitVersioningTopComponent.this.context == null) {
                            GitVersioningTopComponent.this.setContext(ctx);
                        }
                    }
                });
            }
        });
    }

    public boolean hasContext() {
        return this.context != null;
    }

    private void refreshContent() {
        if (this.controller == null) {
            return;
        }
        this.updateTitle();
        this.controller.setContext(this.context == null ? VCSContext.EMPTY : this.context);
    }

    private void updateTitle() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GitVersioningTopComponent.this.contentTitle == null) {
                    GitVersioningTopComponent.this.setName(NbBundle.getMessage(GitVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
                } else {
                    File baseFile = GitUtils.getRootFile(GitVersioningTopComponent.this.context);
                    String name = "";
                    if (baseFile != null) {
                        name = baseFile.getName();
                    }
                    if (GitVersioningTopComponent.this.branchTitle == null) {
                        GitVersioningTopComponent.this.setName(NbBundle.getMessage(GitVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_MultiTitle", (Object)GitVersioningTopComponent.this.contentTitle, (Object)(name.equals(GitVersioningTopComponent.this.contentTitle) ? "" : "[" + name + "]")));
                    } else {
                        GitVersioningTopComponent.this.setName(NbBundle.getMessage(GitVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title_ContentBranch", (Object)GitVersioningTopComponent.this.contentTitle, (Object)(name.equals(GitVersioningTopComponent.this.contentTitle) ? "" : "[" + name + "] "), (Object)GitVersioningTopComponent.this.branchTitle));
                    }
                }
                GitVersioningTopComponent.this.setToolTipText(GitVersioningTopComponent.this.getName());
            }
        });
    }

    public static synchronized GitVersioningTopComponent getDefault() {
        if (instance == null) {
            instance = new GitVersioningTopComponent();
        }
        return instance;
    }

    public static synchronized GitVersioningTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Git.LOG.log(Level.FINE, "Cannot find GitVersioning component. It will not be located properly in the window system.");
            return GitVersioningTopComponent.getDefault();
        }
        if (win instanceof GitVersioningTopComponent) {
            return (GitVersioningTopComponent)win;
        }
        Git.LOG.log(Level.FINE, "There seem to be multiple components with the 'GitVersioning' ID. That is a potential source of errors and unexpected behavior.");
        return GitVersioningTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void setContext(VCSContext ctx) {
        assert (EventQueue.isDispatchThread());
        assert (ctx != null);
        this.controller.cancelRefresh();
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
        this.context = ctx;
        this.refreshBranchName();
        this.refreshContent();
        this.setToolTipText(this.getName());
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
        this.updateTitle();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("prop.activeBranch".equals(evt.getPropertyName())) {
            this.setBranchTitle((GitBranch)evt.getNewValue());
            this.updateTitle();
        }
    }

    void refreshBranchName() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (GitVersioningTopComponent.this.repositoryInfo != null) {
                    GitVersioningTopComponent.this.repositoryInfo.removePropertyChangeListener(GitVersioningTopComponent.this);
                    GitVersioningTopComponent.this.repositoryInfo = null;
                }
                Set<File> repositoryRoots = GitUtils.getRepositoryRoots(GitVersioningTopComponent.this.context);
                GitVersioningTopComponent.this.branchTitle = null;
                if (repositoryRoots.size() == 1) {
                    GitVersioningTopComponent.this.repositoryInfo = RepositoryInfo.getInstance(repositoryRoots.iterator().next());
                    GitBranch branch = GitVersioningTopComponent.this.repositoryInfo.getActiveBranch();
                    if (branch != null) {
                        GitVersioningTopComponent.this.setBranchTitle(branch);
                    }
                    GitVersioningTopComponent.this.repositoryInfo.addPropertyChangeListener(GitVersioningTopComponent.this);
                }
                GitVersioningTopComponent.this.updateTitle();
            }
        };
        if (EventQueue.isDispatchThread()) {
            Utils.post((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private void setBranchTitle(GitBranch branch) {
        this.branchTitle = branch.getName();
    }
}

