/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.hostinfo.impl;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.pty.NbStartUtility;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.hostinfo.HostInfoProvider;
import org.netbeans.modules.nativeexecution.support.hostinfo.impl.HostInfoFactory;
import org.openide.util.Utilities;

public class WindowsHostInfoProvider
implements HostInfoProvider {
    private static final java.util.logging.Logger log = Logger.getInstance();

    @Override
    public HostInfo getHostInfo(ExecutionEnvironment execEnv) throws IOException, InterruptedException {
        if (!execEnv.isLocal() || !Utilities.isWindows()) {
            return null;
        }
        HostInfoImpl info = new HostInfoImpl();
        info.initTmpDirs();
        info.initUserDirs();
        Shell activeShell = WindowsSupport.getInstance().getActiveShell();
        if (activeShell != null && Shell.ShellType.CYGWIN.equals((Object)activeShell.type)) {
            String nbstart = NbStartUtility.getInstance().getPath(execEnv, info);
            String envPath = info.getEnvironmentFile();
            if (nbstart != null && envPath != null) {
                ProcessBuilder pb = new ProcessBuilder(nbstart, "--dumpenv", envPath);
                String pathKey = WindowsSupport.getInstance().getPathKey();
                pb.environment().put(pathKey, "/usr/local/bin;" + activeShell.bindir.getAbsolutePath() + ";/bin;" + pb.environment().get(pathKey));
                ProcessUtils.ExitStatus result = ProcessUtils.execute(pb);
                if (!result.isOK()) {
                    Logger.getInstance().log(Level.INFO, "Failed to call nbstart -- {0}.", result.error);
                }
            }
        }
        return info;
    }

    private static class HostInfoImpl
    implements HostInfo {
        private final HostInfo.OS os;
        private final HostInfo.Bitness osBitness;
        private final HostInfo.OSFamily osFamily;
        private final String osVersion;
        private final String osName;
        private final HostInfo.CpuFamily cpuFamily;
        private final int cpuNum;
        private final String hostname;
        private final String shell;
        private File tmpDirFile;
        private String tmpDir;
        private File userDirFile;
        private String userDir;
        private Map<String, String> environment;

        HostInfoImpl() {
            Collator collator = Collator.getInstance(Locale.US);
            collator.setStrength(0);
            TreeMap<Object, String> env = new TreeMap<Object, String>(collator);
            env.putAll(System.getenv());
            this.osBitness = "x86".equals(System.getProperty("os.arch")) ? HostInfo.Bitness._32 : HostInfo.Bitness._64;
            this.osFamily = HostInfo.OSFamily.WINDOWS;
            this.osVersion = System.getProperty("os.version");
            this.osName = System.getProperty("os.name");
            this.cpuFamily = HostInfo.CpuFamily.X86;
            int _cpuNum = 1;
            try {
                _cpuNum = Integer.parseInt((String)env.get("NUMBER_OF_PROCESSORS"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.cpuNum = _cpuNum;
            this.hostname = (String)env.get("COMPUTERNAME");
            this.shell = WindowsSupport.getInstance().getShell();
            if (this.shell != null) {
                String path = new File(this.shell).getParent();
                env.put("PATH", path + ";" + (String)env.get("PATH"));
            }
            this.environment = Collections.unmodifiableMap(env);
            this.os = new HostInfo.OS(){

                @Override
                public HostInfo.OSFamily getFamily() {
                    return HostInfoImpl.this.osFamily;
                }

                @Override
                public String getName() {
                    return HostInfoImpl.this.osName;
                }

                @Override
                public String getVersion() {
                    return HostInfoImpl.this.osVersion;
                }

                @Override
                public HostInfo.Bitness getBitness() {
                    return HostInfoImpl.this.osBitness;
                }
            };
        }

        public void initTmpDirs() throws IOException {
            String username;
            String ioTmpDir = System.getProperty("java.io.tmpdir");
            File ioTmpDirFile = new File(ioTmpDir);
            if (!this.checkForNonLatin(ioTmpDir)) {
                log.log(Level.WARNING, "Default tmp dir [{0}] has spaces/non-latin chars in the path. It is recommended to use a path without spaces/non-latin chars for tmp dir. Either change TEMP environment variable in System Properties or use -J-Djava.io.tmpdir=c:\\tmp to change the temp dir.", ioTmpDir);
            }
            if (!this.checkForNonLatin(username = this.environment.get("USERNAME"))) {
                username = "" + username.hashCode();
            }
            int suffix = 0;
            File tmpDirBase = new File(ioTmpDir, "dlight_" + username);
            tmpDirBase.mkdirs();
            while (!tmpDirBase.canWrite() && suffix < 5) {
                log.log(Level.WARNING, "WindowsHostInfoProvider: {0} is not writable", tmpDirBase.getPath());
                tmpDirBase = new File(ioTmpDir, "dlight_" + username + "_" + ++suffix);
                tmpDirBase.mkdirs();
            }
            if (tmpDirBase.canWrite()) {
                ioTmpDir = tmpDirBase.getPath();
                String nbKey = HostInfoFactory.getNBKey();
                suffix = 0;
                tmpDirBase = new File(ioTmpDir, nbKey);
                tmpDirBase.mkdirs();
                while (!tmpDirBase.canWrite() && suffix < 5) {
                    log.log(Level.WARNING, "WindowsHostInfoProvider: {0} is not writable", tmpDirBase.getPath());
                    tmpDirBase = new File(ioTmpDir, nbKey + "_" + ++suffix);
                    tmpDirBase.mkdirs();
                }
            }
            if (!tmpDirBase.canWrite()) {
                tmpDirBase = ioTmpDirFile;
            }
            if (!tmpDirBase.canWrite()) {
                log.log(Level.WARNING, "WindowsHostInfoProvider: {0} is not writable", tmpDirBase.getPath());
            }
            this.tmpDir = this.shell == null ? tmpDirBase.getPath() : WindowsSupport.getInstance().convertToShellPath(tmpDirBase.getPath());
            this.tmpDirFile = tmpDirBase;
        }

        public void initUserDirs() throws IOException {
            File _userDirFile = null;
            String _userDir = null;
            String ioUserDir = System.getProperty("user.home");
            String username = this.environment.get("USERNAME");
            if (username != null) {
                for (int i = 0; i < username.length(); ++i) {
                    char c = username.charAt(i);
                    if (Character.isDigit(c) || c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
                    username = "" + username.hashCode();
                    break;
                }
            }
            _userDirFile = new File(ioUserDir);
            _userDir = _userDirFile.getAbsolutePath();
            if (this.shell != null) {
                _userDir = WindowsSupport.getInstance().convertToShellPath(_userDir);
            }
            this.userDirFile = _userDirFile;
            this.userDir = _userDir;
        }

        @Override
        public HostInfo.OS getOS() {
            return this.os;
        }

        @Override
        public HostInfo.CpuFamily getCpuFamily() {
            return this.cpuFamily;
        }

        @Override
        public int getCpuNum() {
            return this.cpuNum;
        }

        @Override
        public HostInfo.OSFamily getOSFamily() {
            return this.osFamily;
        }

        @Override
        public String getHostname() {
            return this.hostname;
        }

        @Override
        public String getShell() {
            return this.shell;
        }

        @Override
        public String getLoginShell() {
            return this.shell;
        }

        @Override
        public String getTempDir() {
            return this.tmpDir;
        }

        @Override
        public File getTempDirFile() {
            return this.tmpDirFile;
        }

        @Override
        public String getUserDir() {
            return this.userDir;
        }

        @Override
        public File getUserDirFile() {
            return this.userDirFile;
        }

        @Override
        public long getClockSkew() {
            return 0L;
        }

        @Override
        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        public int getUserId() {
            return 0;
        }

        @Override
        public int getGroupId() {
            return 0;
        }

        @Override
        public int[] getAllGroupIDs() {
            return new int[0];
        }

        @Override
        public String getGroup() {
            return "";
        }

        @Override
        public String[] getAllGroups() {
            return new String[0];
        }

        private boolean checkForNonLatin(String str) {
            if (str == null) {
                return true;
            }
            String okChars = "~-_/\\:.";
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (Character.isDigit(c) || okChars.indexOf(c) >= 0 || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
                return false;
            }
            return true;
        }

        @Override
        public String getEnvironmentFile() {
            return this.getTempDir() + "/env";
        }
    }
}

