/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.windows;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.windows.PathConverter;
import org.openide.util.Exceptions;

public final class SimpleConverter
implements PathConverter {
    private String cygwinPrefix = null;
    private String shellRootWinPath = null;

    @Override
    public String convert(PathConverter.PathType srcType, PathConverter.PathType trgType, String path) {
        String prefix;
        if (this.cygwinPrefix == null && (srcType == PathConverter.PathType.CYGWIN || trgType == PathConverter.PathType.CYGWIN)) {
            this.initCygwinPrefix();
        }
        if (this.shellRootWinPath == null) {
            Shell shell = WindowsSupport.getInstance().getActiveShell();
            this.shellRootWinPath = shell == null ? "" : shell.bindir.getParent();
        }
        String result = path;
        if (trgType == PathConverter.PathType.WINDOWS) {
            String prefix2 = srcType == PathConverter.PathType.CYGWIN ? this.cygwinPrefix : "/";
            int plen = prefix2.length();
            if (path.length() > plen && path.startsWith(prefix2)) {
                result = path.charAt(plen) + ":";
                result = result + path.substring(plen + 1);
            } else if (path.startsWith("/")) {
                result = this.shellRootWinPath + result;
            }
            return result.replace('/', '\\');
        }
        String string = prefix = trgType == PathConverter.PathType.CYGWIN ? this.cygwinPrefix : "/";
        if (path.length() > 2 && path.charAt(1) == ':') {
            result = prefix + result.replaceFirst(":", "");
        }
        return result.replace('\\', '/');
    }

    @Override
    public String convertAll(PathConverter.PathType srcType, PathConverter.PathType trgType, String path) {
        String srcDelim = srcType == PathConverter.PathType.WINDOWS ? ";" : ":";
        String trgDelim = trgType == PathConverter.PathType.WINDOWS ? ";" : ":";
        String[] elems = path.split(srcDelim);
        StringBuilder sb = new StringBuilder(path.length());
        for (String elem : elems) {
            sb.append(this.convert(srcType, trgType, elem)).append(trgDelim);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private synchronized void initCygwinPrefix() {
        if (this.cygwinPrefix != null) {
            return;
        }
        this.cygwinPrefix = "/cygdrive/";
        Shell shell = WindowsSupport.getInstance().getActiveShell();
        if (shell == null || shell.type != Shell.ShellType.CYGWIN) {
            return;
        }
        File cygpath = new File(shell.bindir, "cygpath.exe");
        if (!cygpath.exists()) {
            return;
        }
        try {
            String output;
            ProcessBuilder pb = new ProcessBuilder(cygpath.getAbsolutePath(), "-u", "c:");
            Process p = pb.start();
            if (p.waitFor() == 0 && (output = ProcessUtils.readProcessOutputLine(p)).length() > 1) {
                this.cygwinPrefix = output.substring(0, output.length() - 1);
            }
        }
        catch (IOException | InterruptedException ex) {
            Logger.getInstance().log(Level.FINE, "Exception when initializing Cygwin prefix", ex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

