/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.option;

import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdMap;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.aliases.StringMapConstIteratorChar;
import org.llvm.adt.aliases.StringMapIteratorChar;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.InputArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.Option;
import org.llvm.option.impl.OptStatics;
import org.llvm.option.impl.OptTableStatics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class OptTable
implements Destructors.ClassWithDestructor {
    private type.ptr<Info> OptionInfos;
    private long NumOptionInfos;
    private boolean IgnoreCase;
    private long TheInputOptionID;
    private long TheUnknownOptionID;
    private long FirstSearchableIndex;
    private StringSet PrefixesUnion;
    private std.string PrefixChars;

    private Info getInfo(OptSpecifier Opt) {
        return (Info)this.getInfoPtr(Opt).$star();
    }

    private type.ptr<Info> getInfoPtr(OptSpecifier Opt) {
        long id = Opt.getID();
        assert (id > 0L && id - 1L < this.getNumOptions()) : "Invalid Option ID.";
        return (type.ptr)this.OptionInfos.$add((int)id - 1);
    }

    protected OptTable(type.ptr<Info> _OptionInfos, long _NumOptionInfos) {
        this(_OptionInfos, _NumOptionInfos, false);
    }

    protected OptTable(type.ptr<Info> _OptionInfos, long _NumOptionInfos, boolean _IgnoreCase) {
        long i;
        this.OptionInfos = (type.ptr)Native.$tryClone(_OptionInfos);
        this.NumOptionInfos = _NumOptionInfos;
        this.IgnoreCase = _IgnoreCase;
        this.TheInputOptionID = 0L;
        this.TheUnknownOptionID = 0L;
        this.FirstSearchableIndex = 0L;
        this.PrefixesUnion = new StringSet();
        this.PrefixChars = new std.string();
        long e = this.getNumOptions();
        for (i = 0L; i != e; ++i) {
            long Kind = this.getInfo((OptSpecifier)new OptSpecifier((long)(i + 1L))).Kind;
            if (Kind == (long)Option.OptionClass.InputClass.getValue()) {
                assert (this.TheInputOptionID == 0L) : "Cannot have multiple input options!";
                this.TheInputOptionID = this.getInfo((OptSpecifier)new OptSpecifier((long)(i + 1L))).ID;
                continue;
            }
            if (Kind == (long)Option.OptionClass.UnknownClass.getValue()) {
                assert (this.TheUnknownOptionID == 0L) : "Cannot have multiple unknown options!";
                this.TheUnknownOptionID = this.getInfo((OptSpecifier)new OptSpecifier((long)(i + 1L))).ID;
                continue;
            }
            if (Kind == (long)Option.OptionClass.GroupClass.getValue()) continue;
            this.FirstSearchableIndex = i;
            break;
        }
        assert (this.FirstSearchableIndex != 0L) : "No searchable options?";
        e = this.getNumOptions();
        for (i = this.FirstSearchableIndex; i != e; ++i) {
            Option.OptionClass Kind = Option.OptionClass.valueOf(this.getInfo((OptSpecifier)new OptSpecifier((long)(i + 1L))).Kind);
            assert (Kind != Option.OptionClass.InputClass && Kind != Option.OptionClass.UnknownClass && Kind != Option.OptionClass.GroupClass) : "Special options should be defined first!";
        }
        e = this.getNumOptions();
        for (i = this.FirstSearchableIndex + 1L; i != e; ++i) {
            if (OptStatics.$less_Info(this.getInfo(new OptSpecifier(i)), this.getInfo(new OptSpecifier(i + 1L)))) continue;
            this.getOption(new OptSpecifier(i)).dump();
            this.getOption(new OptSpecifier(i + 1L)).dump();
            throw new llvm_unreachable((CharSequence)"Options are not in order!");
        }
        e = this.getNumOptions() + 1L;
        for (i = this.FirstSearchableIndex + 1L; i != e; ++i) {
            type.ptr P = (type.ptr)Native.$tryClone(this.getInfo((OptSpecifier)new OptSpecifier((long)i)).Prefixes);
            if (P == null) continue;
            while (P.$star() != null) {
                this.PrefixesUnion.insert(new StringRef((char.ptr)P.$star()));
                P.$preInc();
            }
        }
        StringMapIteratorChar I = this.PrefixesUnion.begin();
        StringMapIteratorChar E = this.PrefixesUnion.end();
        while (I.$noteq((StringMapConstIteratorChar)E)) {
            StringRef Prefix = I.$arrow().getKey();
            char.ptr C = Native.$tryClone((char.ptr)Prefix.begin());
            char.ptr CE = Native.$tryClone((char.ptr)Prefix.end());
            while (C.$noteq((Object)CE)) {
                if (Native.$eq((char.ptr)std.find((char.ptr)this.PrefixChars.begin(), (char.ptr)this.PrefixChars.end(), (byte)C.$star()), (char.ptr)this.PrefixChars.end())) {
                    this.PrefixChars.push_back(C.$star());
                }
                C.$preInc();
            }
            I.$preInc();
        }
    }

    public void $destroy() {
        this.PrefixChars.$destroy();
        this.PrefixesUnion.$destroy();
    }

    public long getNumOptions() {
        return this.NumOptionInfos;
    }

    public Option getOption(OptSpecifier Opt) {
        long id = Opt.getID();
        if (id == 0L) {
            return new Option(null, null);
        }
        assert (id - 1L < this.getNumOptions()) : "Invalid ID.";
        return new Option(this.getInfoPtr(new OptSpecifier(id)), this);
    }

    public char.ptr getOptionName(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).Name;
    }

    public long getOptionKind(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).Kind;
    }

    public long getOptionGroupID(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).GroupID;
    }

    public char.ptr getOptionHelpText(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).HelpText;
    }

    public char.ptr getOptionMetaVar(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).MetaVar;
    }

    public Arg ParseOneArg(ArgList Args, uint.ref Index) {
        return this.ParseOneArg(Args, Index, 0L, 0L);
    }

    public Arg ParseOneArg(ArgList Args, uint.ref Index, long FlagsToInclude) {
        return this.ParseOneArg(Args, Index, FlagsToInclude, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Arg ParseOneArg(ArgList Args, uint.ref Index, long FlagsToInclude, long FlagsToExclude) {
        long Prev = Index.$deref();
        char.ptr Str = Native.$tryClone((char.ptr)Args.getArgString(Index.$deref()));
        if (OptTableStatics.isInput(this.PrefixesUnion, new StringRef(Str))) {
            Index.$set(Index.$deref() + 1L);
            return new Arg(this.getOption(new OptSpecifier(this.TheInputOptionID)), new StringRef(Str), Prev, Str);
        }
        type.ptr Start = (type.ptr)this.OptionInfos.$add(this.FirstSearchableIndex);
        type.ptr End = (type.ptr)this.OptionInfos.$add(this.getNumOptions());
        StringRef Name = new StringRef(Str).ltrim(new StringRef(this.PrefixChars));
        Start = (type.ptr)std.lower_bound((type.iterator)Start, (type.iterator)End, (Object)Name.data());
        while (Start.$noteq((Object)End)) {
            Option Opt = null;
            try {
                long ArgSize = 0L;
                while (Start.$noteq((Object)End) && (ArgSize = OptTableStatics.matchOption((type.ptr<Info>)Start, new StringRef(Str), this.IgnoreCase)) == 0L) {
                    Start.$preInc();
                }
                if (Start.$eq((Object)End)) break;
                Opt = new Option((type.ptr<Info>)Start, this);
                if ((FlagsToInclude == 0L || Opt.hasFlag(FlagsToInclude)) && !Opt.hasFlag(FlagsToExclude)) {
                    Arg A = Opt.accept(Args, Index, ArgSize);
                    if (A != null) {
                        Arg arg = A;
                        return arg;
                    }
                    if (Prev != Index.$deref()) {
                        Arg arg = null;
                        return arg;
                    }
                }
            }
            finally {
                if (Opt != null) {
                    Opt.$destroy();
                }
            }
            Start.$preInc();
        }
        if (Str.$at(0) == NativePointer.$((char)'/')) {
            Prev = Index.$deref();
            Index.$set(Prev + 1L);
            return new Arg(this.getOption(new OptSpecifier(this.TheInputOptionID)), new StringRef(Str), Prev, Str);
        }
        Prev = Index.$deref();
        Index.$set(Prev + 1L);
        return new Arg(this.getOption(new OptSpecifier(this.TheUnknownOptionID)), new StringRef(Str), Prev, Str);
    }

    public InputArgList ParseArgs(type.ptr<char.ptr> ArgBegin, type.ptr<char.ptr> ArgEnd, uint.ref MissingArgIndex, uint.ref MissingArgCount) {
        return this.ParseArgs(ArgBegin, ArgEnd, MissingArgIndex, MissingArgCount, 0L, 0L);
    }

    public InputArgList ParseArgs(type.ptr<char.ptr> ArgBegin, type.ptr<char.ptr> ArgEnd, uint.ref MissingArgIndex, uint.ref MissingArgCount, long FlagsToInclude) {
        return this.ParseArgs(ArgBegin, ArgEnd, MissingArgIndex, MissingArgCount, FlagsToInclude, 0L);
    }

    public InputArgList ParseArgs(type.ptr<char.ptr> ArgBegin, type.ptr<char.ptr> ArgEnd, uint.ref MissingArgIndex, uint.ref MissingArgCount, long FlagsToInclude, long FlagsToExclude) {
        InputArgList Args = new InputArgList(ArgBegin, ArgEnd);
        MissingArgIndex.$set(MissingArgCount.$set(0L));
        long Index = 0L;
        long End = ArgEnd.$sub(ArgBegin);
        while (Index < End) {
            if (Args.getArgString(Index) == null) {
                ++Index;
                continue;
            }
            StringRef Str = new StringRef(Args.getArgString(Index));
            if (llvm.$eq_StringRef((StringRef)Str, (StringRef)StringRef.EMPTY)) {
                ++Index;
                continue;
            }
            long Prev = Index;
            uint.ref IndexRef = NativePointer.create_uint$ref((long)Index);
            Arg A = this.ParseOneArg(Args, IndexRef, FlagsToInclude, FlagsToExclude);
            Index = IndexRef.$deref();
            assert (Index > Prev) : "Parser failed to consume argument.";
            if (A == null) {
                assert (Index >= End) : "Unexpected parser error.";
                assert (Index - Prev - 1L != 0L) : "No missing arguments!";
                MissingArgIndex.$set(Prev);
                MissingArgCount.$set(Index - Prev - 1L);
                break;
            }
            Args.append(A);
        }
        return Args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PrintHelp(raw_ostream OS, char.ptr Name, char.ptr Title, long FlagsToInclude, long FlagsToExclude) {
        std.map GroupedOptionHelp = null;
        try {
            OS.$out((CharSequence)"OVERVIEW: ").$out(Title).$out((CharSequence)"\n");
            OS.$out('\n');
            OS.$out((CharSequence)"USAGE: ").$out(Name).$out((CharSequence)" [options] <inputs>\n");
            OS.$out('\n');
            GroupedOptionHelp = new std.map((Object)new std.vector((Object)std.make_pair((Object)new std.string(), null)));
            long e = this.getNumOptions();
            for (long i = 0L; i != e; ++i) {
                char.ptr Text;
                long Id = i + 1L;
                if (this.getOptionKind(new OptSpecifier(Id)) == (long)Option.OptionClass.GroupClass.getValue()) continue;
                long Flags = this.getInfo((OptSpecifier)new OptSpecifier((long)Id)).Flags;
                if (FlagsToInclude != 0L && (Flags & FlagsToInclude) == 0L || (Flags & FlagsToExclude) != 0L || (Text = Native.$tryClone((char.ptr)this.getOptionHelpText(new OptSpecifier(Id)))) == null) continue;
                std.string OptName = null;
                try {
                    char.ptr HelpGroup = Native.$tryClone((char.ptr)OptTableStatics.getOptionHelpGroup(this, new OptSpecifier(Id)));
                    OptName = OptTableStatics.getOptionHelpName(this, new OptSpecifier(Id));
                    ((std.vector)GroupedOptionHelp.$at((Object)new std.string(HelpGroup))).push_back((Object)std.make_pair((Object)OptName, (Object)Text));
                    continue;
                }
                finally {
                    if (OptName != null) {
                        OptName.$destroy();
                    }
                }
            }
            StdMap.iterator it = GroupedOptionHelp.begin();
            StdMap.iterator ie = GroupedOptionHelp.end();
            while (it.$noteq((Object)ie)) {
                if (it.$noteq((Object)GroupedOptionHelp.begin())) {
                    OS.$out((CharSequence)"\n");
                }
                OptTableStatics.PrintHelpOptionList(OS, new StringRef((std.string)it.$arrow().first), (std.vector<std.pair<std.string, char.ptr>>)((std.vector)it.$arrow().second));
                it.$preInc();
            }
            OS.flush();
        }
        finally {
            if (GroupedOptionHelp != null) {
                GroupedOptionHelp.$destroy();
            }
        }
    }

    public void PrintHelp(raw_ostream OS, char.ptr Name, char.ptr Title) {
        this.PrintHelp(OS, Name, Title, false);
    }

    public void PrintHelp(raw_ostream OS, char.ptr Name, char.ptr Title, boolean ShowHidden) {
        this.PrintHelp(OS, Name, Title, 0L, ShowHidden ? 0 : 1);
    }

    public static class Info
    implements Native.OpCapable {
        public final type.ptr<char.ptr> Prefixes;
        public final char.ptr Name;
        public final char.ptr HelpText;
        public final char.ptr MetaVar;
        public final long ID;
        public final short Kind;
        public final short Param;
        public final char Flags;
        public final char GroupID;
        public final char AliasID;
        public final char.ptr AliasArgs;

        public Info(CharSequence[] Prefixes, CharSequence Name, CharSequence HelpText, CharSequence MetaVar, long ID, int Kind, int Param, int Flags, int GroupID, int AliasID, CharSequence AliasArgs) {
            this(Info.convertPrefixes(Prefixes), Native.$tryConstClone((char.ptr)NativePointer.create_char$ptr((CharSequence)Name)), Native.$tryConstClone((char.ptr)NativePointer.create_char$ptr_or_null((CharSequence)HelpText)), Native.$tryConstClone((char.ptr)NativePointer.create_char$ptr_or_null((CharSequence)MetaVar)), ID, Kind, Param, Flags, GroupID, AliasID, Native.$tryConstClone((char.ptr)NativePointer.create_char$ptr_or_null((CharSequence)AliasArgs)));
        }

        public Info(char.ptr[] Prefixes, char.ptr Name, char.ptr HelpText, char.ptr MetaVar, long ID, int Kind, int Param, int Flags, int GroupID, int AliasID, char.ptr AliasArgs) {
            this.Prefixes = Prefixes == null ? null : (type.ptr)Native.$tryConstClone((Object)NativePointer.create_type$ptr((Object[])Prefixes));
            this.Name = Name;
            this.HelpText = HelpText;
            this.MetaVar = MetaVar;
            this.ID = ID;
            this.Kind = (short)Kind;
            this.Param = (short)Param;
            this.Flags = (char)Flags;
            this.GroupID = (char)GroupID;
            this.AliasID = (char)AliasID;
            this.AliasArgs = AliasArgs;
        }

        private static char.ptr[] convertPrefixes(CharSequence[] Prefixes) {
            char.ptr[] PrefixesArray;
            if (Prefixes == null) {
                PrefixesArray = null;
            } else {
                PrefixesArray = new char.ptr[Prefixes.length];
                for (int i = 0; i < Prefixes.length; ++i) {
                    PrefixesArray[i] = Native.$tryConstClone((char.ptr)NativePointer.create_char$ptr_or_null((CharSequence)Prefixes[i]));
                }
            }
            return PrefixesArray;
        }

        public Boolean $op(Native.OpCapable.Op k, Object obj) {
            if (k == Native.OpCapable.Op.LESS) {
                if (obj instanceof Info) {
                    return OptStatics.$less_Info(this, (Info)obj);
                }
                if (obj instanceof char.ptr) {
                    return OptStatics.$less_Info_T(this, (char.ptr)obj);
                }
            } else {
                assert (!(obj instanceof Info)) : "do we need Op.GREATEREQ impl?";
                assert (!(obj instanceof char.ptr)) : "do we need Op.GREATEREQ impl?";
            }
            return null;
        }

        public String toString() {
            return "Info{, Name=" + this.Name + "\nPrefixes=" + this.Prefixes + "\n, HelpText=" + this.HelpText + ", MetaVar=" + this.MetaVar + "\n, ID=" + this.ID + ", Kind=" + this.Kind + ", Param=" + this.Param + "\n, Flags=" + this.Flags + ", GroupID=" + this.GroupID + "\n, AliasID=" + this.AliasID + ", AliasArgs=" + this.AliasArgs + '}';
        }
    }
}

