/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.CustomAttribute;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.knockout.HelpItemImpl;
import org.netbeans.modules.html.knockout.KOAttributeCompletionItem;
import org.netbeans.modules.html.knockout.KOBindingCompletionItem;
import org.netbeans.modules.html.knockout.KOHelpItem;
import org.netbeans.modules.html.knockout.KOParamsCompletionItem;
import org.netbeans.modules.html.knockout.KOTagCompletionItem;
import org.netbeans.modules.html.knockout.KOUtils;
import org.netbeans.modules.html.knockout.api.KODataBindTokenId;
import org.netbeans.modules.html.knockout.model.Binding;
import org.netbeans.modules.html.knockout.model.KOModel;
import org.netbeans.modules.javascript2.knockout.index.KnockoutCustomElement;
import org.netbeans.modules.javascript2.knockout.index.KnockoutIndex;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class KOHtmlExtension
extends HtmlExtension {
    private static final String DOC_URL = "http://knockoutjs.com/documentation/binding-syntax.html";
    static final KOHelpItem KO_DATA_BIND_HELP_ITEM = new KOHelpItem(){

        @Override
        public String getName() {
            return "data-bind";
        }

        @Override
        public String getExternalDocumentationURL() {
            return KOHtmlExtension.DOC_URL;
        }
    };
    private static final CustomAttribute KO_DATA_BIND_CUSTOM_ATTRIBUTE = new CustomAttribute(){

        public String getName() {
            return "data-bind";
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isValueRequired() {
            return true;
        }

        public HelpItem getHelp() {
            return new HelpItemImpl(KO_DATA_BIND_HELP_ITEM);
        }
    };
    private static final CustomAttribute KO_PARAMS_CUSTOM_ATTRIBUTE = new CustomAttribute(){

        public String getName() {
            return "params";
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isValueRequired() {
            return true;
        }

        public HelpItem getHelp() {
            return null;
        }
    };

    public boolean isApplicationPiece(HtmlParserResult result) {
        return KOModel.getModel(result).containsKnockout();
    }

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights(HtmlParserResult result, SchedulerEvent event) {
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        KOModel model = KOModel.getModel(result);
        for (Attribute ngAttr : model.getBindings()) {
            OffsetRange dor = KOUtils.getValidDocumentOffsetRange(ngAttr.from(), ngAttr.from() + ngAttr.name().length(), result.getSnapshot());
            if (dor == null) continue;
            highlights.put(dor, ColoringAttributes.CONSTRUCTOR_SET);
        }
        return highlights;
    }

    public List<CompletionItem> completeAttributes(HtmlExtension.CompletionContext context) {
        KOModel model = KOModel.getModel(context.getResult());
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        Element element = context.getCurrentNode();
        if (element != null) {
            switch (element.type()) {
                case OPEN_TAG: {
                    OpenTag ot = (OpenTag)element;
                    String name = ot.unqualifiedName().toString();
                    Collection<CustomAttribute> customAttributes = this.getCustomAttributes(name);
                    for (CustomAttribute ca : customAttributes) {
                        items.add((CompletionItem)new KOAttributeCompletionItem(ca, context.getCCItemStartOffset(), model.containsKnockout()));
                    }
                    if (!this.isTagCustomKnockoutElement(context.getResult().getSnapshot().getSource().getFileObject(), name)) break;
                    items.add((CompletionItem)new KOAttributeCompletionItem(KO_PARAMS_CUSTOM_ATTRIBUTE, context.getCCItemStartOffset(), model.containsKnockout()));
                }
            }
        }
        if (context.getPrefix().length() > 0) {
            Iterator itr = items.iterator();
            while (itr.hasNext()) {
                CharSequence insertPrefix = ((CompletionItem)itr.next()).getInsertPrefix();
                if (insertPrefix == null || LexerUtils.startsWith((CharSequence)insertPrefix, (CharSequence)context.getPrefix(), (boolean)true, (boolean)false)) continue;
                itr.remove();
            }
        }
        return items;
    }

    public List<CompletionItem> completeAttributeValue(HtmlExtension.CompletionContext context) {
        TokenSequence embedded;
        Token token;
        int diff;
        Document document = context.getResult().getSnapshot().getSource().getDocument(true);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence ts = LexerUtils.getTokenSequence((TokenHierarchy)tokenHierarchy, (int)context.getOriginalOffset(), (Language)HTMLTokenId.language(), (boolean)false);
        if (ts != null && ((diff = ts.move(context.getOriginalOffset())) == 0 && ts.movePrevious() || ts.moveNext()) && (token = ts.token()).id() == HTMLTokenId.VALUE && (embedded = ts.embedded(KODataBindTokenId.language())) != null) {
            if (embedded.isEmpty()) {
                if (context.getAttributeName().equals("params")) {
                    return this.getCustomElementParameters(context.getResult().getSnapshot().getSource().getFileObject(), context.getCurrentNode().id().toString(), "", context.getOriginalOffset());
                }
                return this.getBindingItems("", context.getOriginalOffset());
            }
            int ediff = embedded.move(context.getOriginalOffset());
            if (ediff == 0 && embedded.movePrevious() || embedded.moveNext()) {
                Token etoken = embedded.token();
                if (context.getAttributeName().equals("params")) {
                    FileObject fo = context.getResult().getSnapshot().getSource().getFileObject();
                    String elementName = context.getCurrentNode().id().toString();
                    switch ((KODataBindTokenId)etoken.id()) {
                        case KEY: {
                            CharSequence prefix;
                            CharSequence charSequence = prefix = ediff == 0 ? etoken.text() : etoken.text().subSequence(0, ediff);
                            if (ediff == 0 && etoken.offset(tokenHierarchy) + etoken.length() != context.getOriginalOffset()) {
                                prefix = "";
                            }
                            return this.getCustomElementParameters(fo, elementName, prefix, embedded.offset());
                        }
                        case COMMA: {
                            return this.getCustomElementParameters(fo, elementName, "", context.getOriginalOffset());
                        }
                        case WS: {
                            if (embedded.movePrevious()) {
                                switch ((KODataBindTokenId)embedded.token().id()) {
                                    case COMMA: {
                                        return this.getCustomElementParameters(fo, elementName, "", context.getOriginalOffset());
                                    }
                                }
                                break;
                            }
                            return this.getCustomElementParameters(fo, elementName, "", context.getOriginalOffset());
                        }
                    }
                } else {
                    switch ((KODataBindTokenId)etoken.id()) {
                        case KEY: {
                            CharSequence prefix;
                            CharSequence charSequence = prefix = ediff == 0 ? etoken.text() : etoken.text().subSequence(0, ediff);
                            if (ediff == 0 && etoken.offset(tokenHierarchy) + etoken.length() != context.getOriginalOffset()) {
                                prefix = "";
                            }
                            return this.getBindingItems(prefix, embedded.offset());
                        }
                        case COMMA: {
                            return this.getBindingItems("", context.getOriginalOffset());
                        }
                        case WS: {
                            if (embedded.movePrevious()) {
                                switch ((KODataBindTokenId)embedded.token().id()) {
                                    case COMMA: {
                                        return this.getBindingItems("", context.getOriginalOffset());
                                    }
                                }
                                break;
                            }
                            return this.getBindingItems("", context.getOriginalOffset());
                        }
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    public List<CompletionItem> completeOpenTags(HtmlExtension.CompletionContext context) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        FileObject fo = context.getResult().getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return Collections.emptyList();
        }
        Collection<KnockoutCustomElement> customElements = this.getAllCustomElements(project, context.getPrefix());
        ArrayList<String> alreadyAddedComponents = new ArrayList<String>();
        block0: for (KnockoutCustomElement customElement : customElements) {
            if (!alreadyAddedComponents.contains(customElement.getName())) {
                items.add((CompletionItem)new KOTagCompletionItem(customElement, context.getCCItemStartOffset()));
                alreadyAddedComponents.add(customElement.getName());
                continue;
            }
            for (CompletionItem ci : items) {
                KOTagCompletionItem completionItem = (KOTagCompletionItem)ci;
                if (!completionItem.getCustomElementName().equals(customElement.getName())) continue;
                completionItem.addAlternativeLocation(customElement.getDeclarationFile());
                continue block0;
            }
        }
        return items;
    }

    private List<CompletionItem> getBindingItems(CharSequence prefix, int offset) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        for (Binding b : Binding.values()) {
            String bindingName = b.getName();
            if (!LexerUtils.startsWith((CharSequence)bindingName, (CharSequence)prefix, (boolean)true, (boolean)false)) continue;
            items.add((CompletionItem)new KOBindingCompletionItem(b, offset));
        }
        return items;
    }

    public boolean isCustomAttribute(Attribute attribute, HtmlSource source) {
        return KOModel.isKODataBindingAttribute(attribute) || KOModel.isKOParamsAttribute(attribute);
    }

    public Collection<CustomAttribute> getCustomAttributes(String elementName) {
        return Collections.singleton(KO_DATA_BIND_CUSTOM_ATTRIBUTE);
    }

    public boolean isCustomTag(Named element, HtmlSource source) {
        FileObject fo = source.getSourceFileObject();
        if (fo == null) {
            return false;
        }
        return this.isTagCustomKnockoutElement(fo, element.name().toString());
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        final OffsetRange[] value = new OffsetRange[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                boolean customElement;
                HTMLTokenId id;
                TokenSequence ts = LexerUtils.getTokenSequence((Document)doc, (int)caretOffset, (Language)HTMLTokenId.language(), (boolean)false);
                if (ts == null) {
                    return;
                }
                ts.move(caretOffset);
                if (ts.moveNext() && ((id = (HTMLTokenId)ts.token().id()) == HTMLTokenId.TAG_OPEN || id == HTMLTokenId.TAG_CLOSE) && (customElement = KOHtmlExtension.this.isTagCustomKnockoutElement(Source.create((Document)doc).getFileObject(), ts.token().text().toString()))) {
                    value[0] = new OffsetRange(ts.offset(), ts.offset() + ts.token().length());
                }
            }
        });
        if (value[0] != null) {
            return value[0];
        }
        return OffsetRange.NONE;
    }

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        HTMLTokenId id;
        FileObject fo = info.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return null;
        }
        TokenSequence ts = LexerUtils.getTokenSequence((TokenHierarchy)info.getSnapshot().getTokenHierarchy(), (int)caretOffset, (Language)HTMLTokenId.language(), (boolean)false);
        if (ts == null) {
            return null;
        }
        ts.move(caretOffset);
        if (ts.moveNext() && ((id = (HTMLTokenId)ts.token().id()) == HTMLTokenId.TAG_OPEN || id == HTMLTokenId.TAG_CLOSE)) {
            Project project = FileOwnerQuery.getOwner((FileObject)info.getSnapshot().getSource().getFileObject());
            Collection<KnockoutCustomElement> customElements = this.getAllCustomElements(project, ts.token().text().toString());
            DeclarationFinder.DeclarationLocation dl = null;
            for (KnockoutCustomElement kce : customElements) {
                URI uri = null;
                try {
                    uri = kce.getDeclarationFile().toURI();
                }
                catch (URISyntaxException ex) {
                    // empty catch block
                }
                if (uri == null) continue;
                File file = Utilities.toFile((URI)uri);
                FileObject dfo = FileUtil.toFileObject((File)file);
                DeclarationFinder.DeclarationLocation dloc = new DeclarationFinder.DeclarationLocation(dfo, kce.getOffset());
                if (dl == null) {
                    dl = dloc;
                }
                AlternativeLocationImpl aloc = new AlternativeLocationImpl(kce.getName(), dloc, (ElementHandle)new ElementHandle.UrlHandle(dfo.getPath()));
                dl.addAlternative((DeclarationFinder.AlternativeLocation)aloc);
            }
            if (dl != null && dl.getAlternativeLocations().size() == 1) {
                dl.getAlternativeLocations().clear();
            }
            if (dl != null) {
                return dl;
            }
        }
        return null;
    }

    private boolean isTagCustomKnockoutElement(FileObject fo, String tagName) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return false;
        }
        KnockoutIndex knockoutIndex = null;
        try {
            knockoutIndex = KnockoutIndex.get((Project)project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (knockoutIndex != null) {
            Collection customElements = knockoutIndex.getCustomElements(tagName, false);
            if (customElements == null || customElements.isEmpty()) {
                return false;
            }
            boolean customTagFound = false;
            for (KnockoutCustomElement kce : customElements) {
                if (!kce.getName().equals(tagName)) continue;
                customTagFound = true;
                break;
            }
            return customTagFound;
        }
        return false;
    }

    private Collection<KnockoutCustomElement> getAllCustomElements(Project project, String prefix) {
        KnockoutIndex knockoutIndex = null;
        try {
            knockoutIndex = KnockoutIndex.get((Project)project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (knockoutIndex != null) {
            return knockoutIndex.getCustomElements(prefix, false);
        }
        return Collections.emptyList();
    }

    private List<CompletionItem> getCustomElementParameters(FileObject fo, String elementName, CharSequence prefix, int offset) {
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return Collections.emptyList();
        }
        KnockoutIndex knockoutIndex = null;
        try {
            knockoutIndex = KnockoutIndex.get((Project)project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (knockoutIndex != null) {
            ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
            for (String paramName : knockoutIndex.getCustomElementParameters(elementName)) {
                if (!LexerUtils.startsWith((CharSequence)paramName, (CharSequence)prefix, (boolean)true, (boolean)false)) continue;
                items.add((CompletionItem)new KOParamsCompletionItem(paramName, offset));
            }
            return items;
        }
        return Collections.emptyList();
    }

    private static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private final DeclarationFinder.DeclarationLocation location;
        private final ElementHandle element;

        public AlternativeLocationImpl(String name, DeclarationFinder.DeclarationLocation location, ElementHandle element) {
            this.location = location;
            this.element = element;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder();
            sb.append("<font color='black'>");
            sb.append(this.element.getName());
            sb.append("</font>");
            return sb.toString();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            return AlternativeLocationImpl.getComparableString(this).compareTo(AlternativeLocationImpl.getComparableString(o));
        }

        private static String getComparableString(DeclarationFinder.AlternativeLocation loc) {
            StringBuilder sb = new StringBuilder();
            sb.append(loc.getLocation().getOffset());
            FileObject fo = loc.getLocation().getFileObject();
            if (fo != null) {
                sb.append(fo.getPath());
            }
            return sb.toString();
        }
    }
}

