/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.repository.Bundle;
import org.netbeans.modules.maven.repository.GroupNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class GroupListChildren
extends ChildFactory.Detachable<String>
implements ChangeListener {
    private RepositoryInfo info;
    static final String KEY_PARTIAL = "____PARTIAL_RESULT";

    public GroupListChildren(RepositoryInfo info) {
        this.info = info;
    }

    public void setInfo(RepositoryInfo info) {
        this.info = info;
        this.refresh(false);
    }

    protected Node createNodeForKey(String key) {
        if (KEY_PARTIAL.equals(key)) {
            return GroupListChildren.createPartialNode();
        }
        return new GroupNode(this.info, key);
    }

    static Node createPartialNode() {
        AbstractNode node = new AbstractNode(Children.LEAF);
        node.setIconBaseWithExtension("org/netbeans/modules/maven/resources/wait.gif");
        node.setDisplayName(Bundle.TXT_Partial_result());
        return node;
    }

    protected boolean createKeys(List<String> toPopulate) {
        RepositoryQueries.Result result = RepositoryQueries.getGroupsResult(Collections.singletonList(this.info));
        toPopulate.addAll(result.getResults());
        if (result.isPartial()) {
            toPopulate.add(KEY_PARTIAL);
        }
        return true;
    }

    protected void addNotify() {
        this.info.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.info));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh(false);
    }
}

