/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.debugger;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.SessionBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeSession;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.PsProvider;
import org.netbeans.modules.cnd.mixeddev.java.JNISupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CndSessionChanger
implements SessionBridge.SessionChanger {
    public Set<String> getActions() {
        return Collections.singleton((String)ActionsManager.ACTION_STEP_INTO);
    }

    public Session changeSuggested(Session origin, String action, Map<Object, Object> properties) {
        CndSessionChanger.checkAutostartOption();
        PsProvider.PsData psData = PsProvider.getDefault((Host)Host.getLocal()).getData(false);
        Vector processes = psData.processes(Pattern.compile(".*java.+:" + properties.get("conn_port") + ".*"));
        if (processes.size() != 1) {
            NativeDebuggerManager.warning((String)NbBundle.getMessage(this.getClass(), (String)"MSG_ProcessDetectionError"));
            return null;
        }
        final String funcName = MethodMapper.getNativeName("" + properties.get("javaClass") + "." + properties.get("javaMethod"));
        String stringPid = (String)((Vector)processes.firstElement()).get(psData.pidColumnIdx());
        final long longPid = Long.parseLong(stringPid);
        Session ret = CndSessionChanger.recognizeSessionByPid(longPid);
        if (ret == null) {
            NativeSession nativeSession;
            DebugTarget target = new DebugTarget();
            target.setPid(longPid);
            target.setHostName("localhost");
            final CountDownLatch latch = new CountDownLatch(1);
            NativeDebuggerManager.get().addDebuggerStateListener(new NativeDebuggerManager.DebuggerStateListener(){

                public void notifyAttached(NativeDebugger debugger, long pid) {
                    if (pid == longPid) {
                        NativeDebuggerManager.get().removeDebuggerStateListener((NativeDebuggerManager.DebuggerStateListener)this);
                        debugger.stepTo(funcName);
                        latch.countDown();
                    }
                }
            });
            NativeDebuggerManager.get().attach(target);
            try {
                latch.await(100L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            NativeDebugger currentDebugger = NativeDebuggerManager.get().currentDebugger();
            if (currentDebugger != null && (nativeSession = currentDebugger.session()) != null) {
                ret = nativeSession.coreSession();
            }
        } else {
            NativeSession.map((Session)ret).getDebugger().pause();
            NativeSession.map((Session)ret).getDebugger().stepTo(funcName);
        }
        return ret;
    }

    private static Session recognizeSessionByPid(long pid) {
        for (NativeSession nativeSession : NativeDebuggerManager.get().getSessions()) {
            if (nativeSession.getPid() != pid) continue;
            return nativeSession.coreSession();
        }
        return null;
    }

    private static void checkAutostartOption() {
        boolean isAutostart = DebuggerOption.RUN_AUTOSTART.isEnabled(NativeDebuggerManager.get().globalOptions());
        if (isAutostart) {
            DebuggerOption.RUN_AUTOSTART.setCurrValue(NativeDebuggerManager.get().globalOptions(), "false");
        }
    }

    private static final class MethodMapper {
        private MethodMapper() {
        }

        static String getNativeName(String javaName) {
            return JNISupport.getCppMethodSignature(javaName.replaceAll("[.]", "/"));
        }
    }
}

