/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java;

import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.cnd.mixeddev.java.JavaContextSupport;
import org.netbeans.modules.cnd.mixeddev.java.ResolveJavaContextTask;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaEntityInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaMethodInfo;

public final class JNASupport {
    private static final String JNA_LIBRARY = "com.sun.jna.Library";

    public static JavaEntityInfo getJNAEntity(Document doc, int offset) {
        return JavaContextSupport.resolveContext(doc, new ResolveJNAEntityTask(offset));
    }

    public static String getCppMethodSignature(JavaMethodInfo methodInfo) {
        if (methodInfo == null) {
            return null;
        }
        StringBuilder method = new StringBuilder();
        method.append(methodInfo.getName());
        return method.toString();
    }

    private static boolean findLibraryInterface(CompilationController controller, TreePath ifacePath) {
        TypeElement ifaceElement = (TypeElement)controller.getTrees().getElement(ifacePath);
        HashSet<String> handledEntities = new HashSet<String>();
        return JNASupport.findLibraryInterface(controller, ifaceElement, handledEntities);
    }

    private static boolean findLibraryInterface(CompilationController controller, TypeElement baseIfaceElement, Set<String> handled) {
        for (TypeMirror typeMirror : baseIfaceElement.getInterfaces()) {
            TypeElement ifaceElement;
            String qualifiedName;
            if (typeMirror.getKind() != TypeKind.DECLARED || handled.contains(qualifiedName = (ifaceElement = (TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString())) continue;
            handled.add(qualifiedName);
            if (!JNA_LIBRARY.equals(qualifiedName)) {
                return JNASupport.findLibraryInterface(controller, ifaceElement, handled);
            }
            return true;
        }
        return false;
    }

    private JNASupport() {
        throw new AssertionError((Object)"Not instantiable!");
    }

    private static class ResolveJNAEntityTask
    implements ResolveJavaContextTask<JavaEntityInfo> {
        private final int offset;
        private JavaEntityInfo result;

        public ResolveJNAEntityTask(int offset) {
            this.offset = offset;
        }

        @Override
        public boolean hasResult() {
            return this.result != null;
        }

        @Override
        public JavaEntityInfo getResult() {
            return this.result;
        }

        public void cancel() {
        }

        public void run(CompilationController controller) throws Exception {
            TreePath parentPath;
            if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                return;
            }
            TreePath path = controller.getTreeUtilities().pathFor(this.offset);
            if (JavaContextSupport.isMethod(path) && JavaContextSupport.isInterface(parentPath = path.getParentPath()) && JNASupport.findLibraryInterface(controller, parentPath)) {
                this.result = JavaContextSupport.createMethodInfo(controller, path);
            }
        }
    }
}

