/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.cnd.mixeddev.MixedDevUtils;
import org.netbeans.modules.cnd.mixeddev.java.AbstractResolveJavaContextTask;
import org.netbeans.modules.cnd.mixeddev.java.JavaContextSupport;
import org.netbeans.modules.cnd.mixeddev.java.ResolveJavaContextTask;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaClassInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaFieldInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaMethodInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaParameterInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaTypeInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.jni.JNIClass;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

public final class JNISupport {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.mixeddev.java");
    private static final String JNI_QN_PREFIX = "Java_";
    private static final String JNI_PARAMS_SIGNATURE_PREFIX = "__";
    private static final String JNI_JNIENV = "JNIEnv";
    private static final String JNI_JOBJECT = "jobject";
    private static final String JNI_JCLASS = "jclass";
    private static final List<String> JNI_REGULAR_IMPLICIT_PARAMS = Arrays.asList("JNIEnv*", "jobject");
    private static final List<String> JNI_STATIC_IMPLICIT_PARAMS = Arrays.asList("JNIEnv*", "jclass");
    private static final String JNI_DOT = "_";
    private static final String JNI_SLASH = "_";
    private static final String JNI_UNDERSCORE = "_1";
    private static final String JNI_SEMICOLON = "_2";
    private static final String JNI_LBRACKET = "_3";
    private static final Map<String, String> javaToCppTypes = MixedDevUtils.createMapping(Pair.of((Object)"boolean", (Object)"jboolean"), Pair.of((Object)"byte", (Object)"jbyte"), Pair.of((Object)"char", (Object)"jchar"), Pair.of((Object)"short", (Object)"jshort"), Pair.of((Object)"int", (Object)"jint"), Pair.of((Object)"long", (Object)"jlong"), Pair.of((Object)"float", (Object)"jfloat"), Pair.of((Object)"double", (Object)"jdouble"), Pair.of((Object)"void", (Object)"void"), Pair.of((Object)"String", (Object)"jstring"), Pair.of((Object)"boolean[]", (Object)"jbooleanArray"), Pair.of((Object)"byte[]", (Object)"jbyteArray"), Pair.of((Object)"char[]", (Object)"jcharArray"), Pair.of((Object)"short[]", (Object)"jshortArray"), Pair.of((Object)"int[]", (Object)"jintArray"), Pair.of((Object)"long[]", (Object)"jlongArray"), Pair.of((Object)"float[]", (Object)"jfloatArray"), Pair.of((Object)"double[]", (Object)"jdoubleArray"));
    private static final Map<String, String> javaToSignatures = MixedDevUtils.createMapping(Pair.of((Object)"boolean", (Object)"Z"), Pair.of((Object)"byte", (Object)"B"), Pair.of((Object)"char", (Object)"C"), Pair.of((Object)"short", (Object)"S"), Pair.of((Object)"int", (Object)"I"), Pair.of((Object)"long", (Object)"J"), Pair.of((Object)"float", (Object)"F"), Pair.of((Object)"double", (Object)"D"), Pair.of((Object)"void", (Object)"V"));
    private static final Map<String, String> javaExceptionalMethodSignatures = MixedDevUtils.createMapping(Pair.of((Object)"java/lang/Object/hashCode", (Object)"JVM_IHashCode"), Pair.of((Object)"java/lang/Object/clone", (Object)"JVM_Clone"), Pair.of((Object)"java/lang/Object/notify", (Object)"JVM_MonitorNotify"), Pair.of((Object)"java/lang/Object/notifyAll", (Object)"JVM_MonitorNotifyAll"), Pair.of((Object)"java/lang/Object/wait", (Object)"JVM_MonitorWait"));

    public static boolean isJNIClass(Document doc, int caret) {
        Boolean res = JavaContextSupport.resolveContext(doc, new IsJNIClassTask(caret));
        return res != null ? res : false;
    }

    public static JNIClass getJNIClass(Document doc, int caret) {
        return JavaContextSupport.resolveContext(doc, new GetJNIClassTask(caret));
    }

    public static List<String> getJNIClassNames(FileObject fObj) {
        return JavaContextSupport.resolveContext(fObj, new GetJavaJNIClassesNamesTask());
    }

    public static List<String> getJNIClassNames(Document doc) {
        return JavaContextSupport.resolveContext(doc, new GetJavaJNIClassesNamesTask());
    }

    public static JavaMethodInfo getJNIMethod(FileObject fObj, int offset) {
        return JavaContextSupport.resolveContext(fObj, new ResolveJNIMethodTask(offset));
    }

    public static JavaMethodInfo getJNIMethod(Document doc, int offset) {
        return JavaContextSupport.resolveContext(doc, new ResolveJNIMethodTask(offset));
    }

    public static String[] getCppMethodSignatures(JavaMethodInfo methodInfo) {
        String exception = JNISupport.getExceptionalMethodCppSignature(JavaContextSupport.renderQualifiedName(methodInfo.getQualifiedName()));
        if (exception != null) {
            return new String[]{exception};
        }
        if (methodInfo.isOverloaded()) {
            return new String[]{JNISupport.getCppSignature(methodInfo, true)};
        }
        return new String[]{JNISupport.getCppSignature(methodInfo, false), JNISupport.getCppSignature(methodInfo, true)};
    }

    @Deprecated
    public static String getCppMethodSignature(String qualifiedName) {
        String exception = JNISupport.getExceptionalMethodCppSignature(qualifiedName);
        return exception != null ? exception : JNI_QN_PREFIX.concat(JNISupport.escape(qualifiedName));
    }

    public static String getJNISignature(JavaTypeInfo javaType) {
        if (javaType != null) {
            if (javaType.getArrayDepth() > 0) {
                return "[" + JNISupport.getJNISignature(new JavaTypeInfo(javaType.getName(), javaType.getQualifiedName(), javaType.getArrayDepth() - 1));
            }
            String typeName = javaType.getText().toString();
            if (javaToSignatures.containsKey(typeName)) {
                return javaToSignatures.get(typeName);
            }
            return "L" + JavaContextSupport.renderQualifiedName(javaType.getQualifiedName()) + ";";
        }
        return javaToSignatures.get("void");
    }

    public static String getJNISignature(JavaMethodInfo methodInfo) {
        StringBuilder signature = new StringBuilder();
        signature.append("(");
        for (JavaParameterInfo param : methodInfo.getParameters()) {
            signature.append(JNISupport.getJNISignature(param.getType()));
        }
        signature.append(")");
        signature.append(JNISupport.getJNISignature(methodInfo.getReturnType()));
        return signature.toString();
    }

    public static String getJNISignature(JavaClassInfo javaClass) {
        return javaClass.getQualifiedName().toString();
    }

    public static String getJNISignature(JavaFieldInfo javaField) {
        return JNISupport.getJNISignature(javaField.getType());
    }

    public static FileObject generateJNIHeader(FileObject javahFObj, FileObject sourceRoot, FileObject javaClass, String destination, ClassPath sourceCP, ClassPath compileCP) {
        String compile;
        String source;
        File javah = FileUtil.toFile((FileObject)javahFObj);
        String className = FileUtil.getRelativePath((FileObject)sourceRoot, (FileObject)javaClass);
        if (className.endsWith(".java")) {
            className = className.substring(0, className.length() - 5).replace('/', '.').replace('\\', '.');
        }
        File workingDir = new File(FileUtil.toFile((FileObject)sourceRoot.getParent()), "build/classes");
        ArrayList<String> args = new ArrayList<String>();
        args.add("-o");
        args.add(destination);
        String argCP = "";
        boolean needed = false;
        if (sourceCP != null && !(source = sourceCP.toString()).isEmpty()) {
            needed = true;
            argCP = argCP.concat(source + File.pathSeparator);
        }
        if (compileCP != null && !(compile = compileCP.toString()).isEmpty()) {
            needed = true;
            argCP = argCP.concat(compile);
        }
        if (needed) {
            args.add("-classpath");
            args.add(argCP);
        }
        args.add(className);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        npb.setWorkingDirectory(workingDir.getAbsolutePath());
        npb.setExecutable(javah.getAbsolutePath());
        npb.setArguments(args.toArray(new String[args.size()]));
        ProcessUtils.ExitStatus javahStatus = ProcessUtils.execute((NativeProcessBuilder)npb);
        if (!javahStatus.isOK()) {
            LOG.log(Level.WARNING, "javah failed {0}; args={1}", new Object[]{javahStatus, args});
            return null;
        }
        File destFile = new File(destination);
        return destFile.isAbsolute() ? FileUtil.toFileObject((File)destFile) : FileUtil.toFileObject((File)new File(workingDir, destination));
    }

    private static String getExceptionalMethodCppSignature(CharSequence qualName) {
        return javaExceptionalMethodSignatures.get(qualName.toString());
    }

    private static String getCppSignature(JavaMethodInfo methodInfo, boolean full) {
        if (methodInfo == null) {
            return null;
        }
        StringBuilder signature = new StringBuilder();
        signature.append(JNI_QN_PREFIX).append(JNISupport.escape(JavaContextSupport.renderQualifiedName(methodInfo.getQualifiedName())));
        if (full) {
            signature.append(JNI_PARAMS_SIGNATURE_PREFIX);
            for (JavaParameterInfo param : methodInfo.getParameters()) {
                signature.append(JNISupport.escape(JNISupport.getJNISignature(param.getType())));
            }
        }
        ArrayList<String> cppTypes = new ArrayList<String>();
        cppTypes.addAll(methodInfo.isStatic() ? JNI_STATIC_IMPLICIT_PARAMS : JNI_REGULAR_IMPLICIT_PARAMS);
        cppTypes.addAll(MixedDevUtils.transform(methodInfo.getParameters(), JavaParameterToCppTypeConverter.INSTANCE));
        signature.append("(").append(MixedDevUtils.stringize(cppTypes, ",")).append(")");
        return signature.toString();
    }

    private static String escape(CharSequence text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (JNISupport.needEscape(chr)) {
                sb.append(JNISupport.escape(chr));
                continue;
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    private static boolean needEscape(char codepoint) {
        boolean validCodePoint = codepoint >= '0' && codepoint <= '9' || codepoint >= 'a' && codepoint <= 'z' || codepoint >= 'A' && codepoint <= 'Z';
        return !validCodePoint;
    }

    private static String escape(char chr) {
        assert (JNISupport.needEscape(chr));
        switch (chr) {
            case '/': {
                return "_";
            }
            case '_': {
                return JNI_UNDERSCORE;
            }
            case ';': {
                return JNI_SEMICOLON;
            }
            case '[': {
                return JNI_LBRACKET;
            }
            case '.': {
                return "_";
            }
        }
        String hex = Integer.toHexString(chr);
        return "_0" + MixedDevUtils.repeat("0", 4 - hex.length()) + hex;
    }

    private static String getCppType(JavaTypeInfo javaType) {
        String typeName = javaType.getText().toString();
        if (javaToCppTypes.containsKey(typeName)) {
            return javaToCppTypes.get(typeName);
        }
        return javaType.getArrayDepth() > 0 ? "jobjectArray" : JNI_JOBJECT;
    }

    private static boolean isJNIMethod(MethodTree mtd) {
        return mtd.getModifiers().getFlags().contains((Object)Modifier.NATIVE);
    }

    private static boolean hasJniMethods(ClassTree clsTree) {
        for (Tree tree : clsTree.getMembers()) {
            if (tree.getKind() != Tree.Kind.METHOD || !JNISupport.isJNIMethod((MethodTree)tree)) continue;
            return true;
        }
        return false;
    }

    private static List<MethodTree> getJniMethods(ClassTree clsTree) {
        ArrayList<MethodTree> methods = new ArrayList<MethodTree>();
        for (Tree tree : clsTree.getMembers()) {
            if (tree.getKind() != Tree.Kind.METHOD || !JNISupport.isJNIMethod((MethodTree)tree)) continue;
            methods.add((MethodTree)tree);
        }
        return methods;
    }

    private JNISupport() {
        throw new AssertionError((Object)"Not instantiable!");
    }

    private static final class GetJavaJNIClassesNamesTask
    implements ResolveJavaContextTask<List<String>> {
        private final List<String> result = new ArrayList<String>();

        private GetJavaJNIClassesNamesTask() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public List<String> getResult() {
            return Collections.unmodifiableList(this.result);
        }

        public void cancel() {
        }

        public void run(CompilationController controller) throws Exception {
            if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                return;
            }
            CompilationUnitTree compilationUnit = controller.getCompilationUnit();
            if (compilationUnit == null) {
                return;
            }
            List<? extends Tree> topLevelDecls = compilationUnit.getTypeDecls();
            if (topLevelDecls != null && !topLevelDecls.isEmpty()) {
                for (Tree tree : topLevelDecls) {
                    if (tree.getKind() != Tree.Kind.CLASS || !JNISupport.hasJniMethods((ClassTree)tree)) continue;
                    this.result.add(JavaContextSupport.renderQualifiedName(JavaContextSupport.getQualifiedName(controller, tree)));
                }
            }
        }
    }

    private static final class GetJNIClassTask
    extends AbstractResolveJavaContextTask<JNIClass> {
        public GetJNIClassTask(int offset) {
            super(offset);
        }

        @Override
        protected void resolve(CompilationController controller, TreePath tp) {
            ClassTree clsTree;
            if (tp.getLeaf() != null && tp.getLeaf().getKind() == Tree.Kind.CLASS && JNISupport.hasJniMethods(clsTree = (ClassTree)tp.getLeaf())) {
                List jniMethods = JNISupport.getJniMethods(clsTree);
                this.result = new JNIClass(JavaContextSupport.createClassInfo(controller, tp), MixedDevUtils.transform(jniMethods, new MethodTreeToJavaMethodInfoConverter(controller)));
            }
        }
    }

    private static final class IsJNIClassTask
    extends AbstractResolveJavaContextTask<Boolean> {
        public IsJNIClassTask(int offset) {
            super(offset);
        }

        @Override
        protected void resolve(CompilationController controller, TreePath tp) {
            if (tp.getLeaf() != null && tp.getLeaf().getKind() == Tree.Kind.CLASS) {
                this.result = JNISupport.hasJniMethods((ClassTree)tp.getLeaf());
            }
        }
    }

    private static final class ResolveJNIMethodTask
    extends AbstractResolveJavaContextTask<JavaMethodInfo> {
        public ResolveJNIMethodTask(int offset) {
            super(offset);
        }

        @Override
        protected void resolve(CompilationController controller, TreePath tp) {
            if (tp.getLeaf() != null && tp.getLeaf().getKind() == Tree.Kind.METHOD && ((MethodTree)tp.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
                this.result = this.validateMethodInfo(JavaContextSupport.createMethodInfo(controller, tp));
            }
        }

        private JavaMethodInfo validateMethodInfo(JavaMethodInfo mtdInfo) {
            for (JavaParameterInfo param : mtdInfo.getParameters()) {
                if (param != null && param.getName() != null) continue;
                return null;
            }
            if (mtdInfo.getReturnType() == null || mtdInfo.getReturnType().getName() == null) {
                return null;
            }
            return mtdInfo;
        }
    }

    private static final class MethodTreeToJavaMethodInfoConverter
    implements MixedDevUtils.Converter<MethodTree, JavaMethodInfo> {
        private final CompilationController controller;

        public MethodTreeToJavaMethodInfoConverter(CompilationController controller) {
            this.controller = controller;
        }

        @Override
        public JavaMethodInfo convert(MethodTree from) {
            return JavaContextSupport.createMethodInfo(this.controller, this.controller.getTrees().getPath(this.controller.getCompilationUnit(), from));
        }
    }

    private static final class JavaTypeToCppTypeConverter
    implements MixedDevUtils.Converter<JavaTypeInfo, String> {
        public static final JavaTypeToCppTypeConverter INSTANCE = new JavaTypeToCppTypeConverter();

        private JavaTypeToCppTypeConverter() {
        }

        @Override
        public String convert(JavaTypeInfo from) {
            return JNISupport.getCppType(from);
        }
    }

    private static final class JavaParameterToCppTypeConverter
    implements MixedDevUtils.Converter<JavaParameterInfo, String> {
        public static final JavaParameterToCppTypeConverter INSTANCE = new JavaParameterToCppTypeConverter();

        private JavaParameterToCppTypeConverter() {
        }

        @Override
        public String convert(JavaParameterInfo from) {
            return JavaTypeToCppTypeConverter.INSTANCE.convert(from.getType());
        }
    }
}

