/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.api.ProcessUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class CordovaPlatform {
    private static CordovaPlatform instance;
    private static String CORDOVA_SDK_ROOT_PREF;
    private Version version;
    private boolean isGitReady;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static Pattern versionPattern;

    private CordovaPlatform() {
    }

    public static synchronized CordovaPlatform getDefault() {
        if (instance == null) {
            instance = new CordovaPlatform();
        }
        return instance;
    }

    public Version getVersion() {
        if (this.version == null) {
            try {
                String v = Utilities.isWindows() ? ProcessUtilities.callProcess((String)"cmd", (boolean)true, (int)60000, (String[])new String[]{"/C cordova -v"}) : (Utilities.isMac() ? ProcessUtilities.callProcess((String)"/bin/bash", (boolean)true, (int)60000, (String[])new String[]{"-lc", "cordova -v"}) : ProcessUtilities.callProcess((String)"cordova", (boolean)true, (int)60000, (String[])new String[]{"-v"}));
                if (versionPattern.matcher(v.trim()).matches()) {
                    this.version = new Version(v.trim());
                }
            }
            catch (IOException ex) {
                Version.LOG.log(Level.INFO, "Could not find cordova on PATH.");
            }
        }
        return this.version;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public boolean isReady() {
        return this.isGitReady() && this.getVersion() != null;
    }

    public static boolean isCordovaProject(Project project) {
        FileObject root = project.getProjectDirectory();
        root.refresh();
        return root.getFileObject("hooks") != null || root.getFileObject(".cordova") != null;
    }

    private boolean isGitReady() {
        if (!this.isGitReady) {
            try {
                String v = Utilities.isWindows() ? ProcessUtilities.callProcess((String)"git.exe", (boolean)true, (int)60000, (String[])new String[]{"--version"}) : (Utilities.isMac() ? ProcessUtilities.callProcess((String)"/bin/bash", (boolean)true, (int)60000, (String[])new String[]{"-lc", "git --version"}) : ProcessUtilities.callProcess((String)"git", (boolean)true, (int)60000, (String[])new String[]{"--version"}));
                if (v.contains("version")) {
                    this.isGitReady = true;
                }
            }
            catch (IOException ex) {
                Version.LOG.log(Level.INFO, "Could not find git on PATH.");
            }
        }
        return this.isGitReady;
    }

    static {
        CORDOVA_SDK_ROOT_PREF = "cordova.home";
        versionPattern = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+.*");
    }

    public static class Version {
        private SubVersion api;
        private SubVersion cli;
        private static Logger LOG = Logger.getLogger(Version.class.getName());

        public Version(String version) {
            LOG.fine("Cordova version " + version);
            if (version.contains("-")) {
                this.api = new SubVersion(version.substring(0, version.indexOf("-")));
                this.cli = new SubVersion(version.substring(version.indexOf("-") + 1));
            } else {
                this.api = new SubVersion(version);
                this.cli = new SubVersion("0.0.0");
            }
        }

        public String toString() {
            return this.api.toString() + "-" + this.cli.toString();
        }

        public boolean isSupported() {
            return this.api.compareTo(new SubVersion("3.0")) > 0;
        }

        public final SubVersion getApiVersion() {
            return this.api;
        }

        public final SubVersion getCliVersion() {
            return this.cli;
        }

        public static class SubVersion
        implements Comparable<SubVersion> {
            private final String version;

            public SubVersion(String version) {
                this.version = version;
            }

            @Override
            public int compareTo(SubVersion o) {
                return this.version.compareTo(o.version);
            }

            public String toString() {
                return this.version;
            }
        }
    }
}

