/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.pull.Bundle;
import org.netbeans.modules.mercurial.ui.pull.PullAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PullCurrentBranchAction
extends ContextAction {
    public static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/resources/icons/pull.png";

    public PullCurrentBranchAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_PullBranchLocal";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        return roots.size() == 1 ? NbBundle.getMessage(PullCurrentBranchAction.class, (String)"CTL_MenuItem_PullBranchRoot", (Object)roots.iterator().next().getName()) : NbBundle.getMessage(PullCurrentBranchAction.class, (String)"CTL_MenuItem_PullBranchLocal");
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        final Set<File> repositoryRoots = HgUtils.getRepositoryRoots(context);
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Iterator i$ = repositoryRoots.iterator();
                while (i$.hasNext()) {
                    File repositoryRoot;
                    final File root = repositoryRoot = (File)i$.next();
                    try {
                        final String branch = HgCommand.getBranch(root);
                        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                        HgProgressSupport support = new HgProgressSupport(){

                            @Override
                            public void perform() {
                                PullAction.getDefaultAndPerformPull(root, null, branch, this);
                            }
                        };
                        support.start(rp, root, Bundle.MSG_PULL_BRANCH_PROGRESS(branch)).waitFinished();
                        if (!support.isCanceled()) continue;
                        break;
                    }
                    catch (HgException.HgCommandCanceledException ex) {
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                    }
                }
            }
        });
    }
}

