/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.awt.EventQueue;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.queues.Bundle;
import org.netbeans.modules.mercurial.ui.queues.QUtils;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class QDiffAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_QDiff";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        final File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        new HgProgressSupport(){

            @Override
            protected void perform() {
                if (!QUtils.isMQEnabledExtension(root)) {
                    return;
                }
                try {
                    List<HgLogMessage> parents = HgCommand.getParents(root, null, null);
                    if (parents.size() != 1 || !Arrays.asList(parents.get(0).getTags()).contains("qtip")) {
                        NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)NbBundle.getMessage(QDiffAction.class, (String)"MSG_DiffAction.error.notAtTip"), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((DiffAction)SystemAction.get(DiffAction.class)).diff(roots, HgLogMessage.HgRevision.QDIFF_BASE, HgLogMessage.HgRevision.CURRENT, Bundle.LBL_DiffView_name(roots.length == 1 ? roots[0].getName() : Bundle.LBL_DiffView_name_files(roots.length)), true, false);
                            }
                        });
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
            }
        }.start(Mercurial.getInstance().getRequestProcessor(root), root, NbBundle.getMessage(QDiffAction.class, (String)"LBL_DiffAction.progress"));
    }
}

