/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug;

import java.awt.EventQueue;
import java.util.List;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.modules.javascript.v8debug.ScriptsHandler;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.sources.SourceMapsTranslator;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public final class EditorUtils {
    public static final String CURRENT_LINE_ANNOTATION_TYPE = "CurrentPC";
    public static final String CALL_STACK_FRAME_ANNOTATION_TYPE = "CallSite";

    private EditorUtils() {
    }

    public static Line getLine(FileObject fo, int line) {
        SourceMapsTranslator smtr = SourceMapsTranslator.get(fo);
        if (smtr != null) {
            FileObject tfo = smtr.getTranslatedFile(line);
            if (tfo != null) {
                fo = tfo;
            }
            line = smtr.getTranslatedLine(line);
        }
        LineCookie lineCookie = (LineCookie)fo.getLookup().lookup(LineCookie.class);
        try {
            return lineCookie.getLineSet().getCurrent(line);
        }
        catch (IndexOutOfBoundsException ioob) {
            List lines = lineCookie.getLineSet().getLines();
            if (lines.size() > 0) {
                return (Line)lines.get(lines.size() - 1);
            }
            return null;
        }
    }

    public static void showLine(final Line line, final boolean toFront) {
        if (line == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                line.show(Line.ShowOpenType.REUSE, toFront ? Line.ShowVisibilityType.FRONT : Line.ShowVisibilityType.FOCUS);
            }
        });
    }

    public static void showLine(Line line) {
        EditorUtils.showLine(line, false);
    }

    public static void showFrameLine(V8Debugger dbg, CallFrame frame, boolean toFront) {
        V8Frame f = frame.getFrame();
        V8Script script = frame.getScript();
        if (script == null) {
            return;
        }
        ScriptsHandler scriptsHandler = dbg.getScriptsHandler();
        FileObject fo = scriptsHandler.getFile(script);
        Line line = EditorUtils.getLine(fo, (int)f.getLine());
        if (line != null) {
            EditorUtils.showLine(line, toFront);
        }
    }
}

