/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.frames;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8Function;
import org.netbeans.lib.v8debug.vars.V8Object;
import org.netbeans.lib.v8debug.vars.V8ScriptValue;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.ReferencedValues;
import org.netbeans.modules.javascript.v8debug.frames.Bundle;

public final class CallFrame {
    private final V8Frame frame;
    private final ReferencedValues rvals;
    private final boolean topFrame;

    public CallFrame(V8Frame frame, ReferencedValues rvals, boolean topFrame) {
        this.frame = frame;
        this.rvals = rvals;
        this.topFrame = topFrame;
    }

    public V8Frame getFrame() {
        return this.frame;
    }

    public ReferencedValues getRvals() {
        return this.rvals;
    }

    public boolean isTopFrame() {
        return this.topFrame;
    }

    @CheckForNull
    public V8Script getScript() {
        long ref = this.frame.getScriptRef();
        V8Value val = this.rvals.getReferencedValue(ref);
        if (val instanceof V8ScriptValue) {
            return ((V8ScriptValue)val).getScript();
        }
        return null;
    }

    @CheckForNull
    public String getThisName() {
        ReferencedValue receiver = this.frame.getReceiver();
        V8Value thisValue = receiver.hasValue() ? receiver.getValue() : this.rvals.getReferencedValue(receiver.getReference());
        if (!(thisValue instanceof V8Object)) {
            return null;
        }
        String className = ((V8Object)thisValue).getClassName();
        return className;
    }

    @NonNull
    public String getFunctionName() {
        String name;
        ReferencedValue functionRV = this.frame.getFunction();
        V8Value functionValue = functionRV.hasValue() ? functionRV.getValue() : this.rvals.getReferencedValue(functionRV.getReference());
        if (functionValue instanceof V8Function) {
            V8Function function = (V8Function)functionValue;
            name = function.getName();
            if (name == null || name.isEmpty()) {
                name = function.getInferredName();
            }
        } else {
            name = null;
        }
        if (name == null || name.isEmpty()) {
            name = "[" + Bundle.CTL_anonymousFunction() + "]";
        }
        return name;
    }
}

