/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.vars.eval;

import java.util.List;
import javax.swing.JEditorPane;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.EditorUtils;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.vars.EvaluationError;
import org.netbeans.modules.javascript.v8debug.vars.V8Evaluator;
import org.netbeans.modules.javascript.v8debug.vars.Variable;
import org.netbeans.modules.javascript.v8debug.vars.eval.VarOrError;
import org.netbeans.modules.javascript2.debug.EditorContextSetter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public class V8CodeEvaluator
extends CodeEvaluator.EvaluatorService {
    private final V8Debugger dbg;
    private final V8ContextProvider contextProvider = new V8ContextProvider();
    private final CodeEvaluator.DefaultExpressionsHistoryPersistence historyPersistence;
    private String expression;
    private static RequestProcessor rp = new RequestProcessor("Debugger Evaluator", 1);
    private final RequestProcessor.Task evalTask = rp.create((Runnable)new EvaluateTask());
    private CodeEvaluator.Result<VarOrError, CodeEvaluator.Result.DefaultHistoryItem> result;

    public V8CodeEvaluator(ContextProvider contextProvider) {
        this.dbg = (V8Debugger)contextProvider.lookupFirst(null, V8Debugger.class);
        this.historyPersistence = CodeEvaluator.DefaultExpressionsHistoryPersistence.create((String)"javascript-v8engine");
        this.result = CodeEvaluator.Result.get((DebuggerEngine)((DebuggerEngine)contextProvider.lookupFirst(null, DebuggerEngine.class)));
    }

    public void setupContext(JEditorPane editorPane, Runnable setUpCallback) {
        EditorContextSetter.setContext((JEditorPane)editorPane, (EditorContextSetter.EditorContextProvider)this.contextProvider, (Runnable)setUpCallback);
    }

    public boolean canEvaluate() {
        return this.dbg.isSuspended();
    }

    public void evaluate(String expression) {
        this.expression = expression;
        this.evalTask.schedule(0);
    }

    private String getExpression() {
        return this.expression;
    }

    public List<String> getExpressionsHistory() {
        return this.historyPersistence.getExpressions();
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        @Override
        public void run() {
            VarOrError voe;
            String exp = V8CodeEvaluator.this.getExpression();
            if (exp == null || "".equals(exp)) {
                return;
            }
            CallFrame frame = V8CodeEvaluator.this.dbg.getCurrentFrame();
            if (frame == null) {
                return;
            }
            try {
                V8Value value = V8Evaluator.evaluate(V8CodeEvaluator.this.dbg, V8CodeEvaluator.this.expression);
                Variable var = new Variable(Variable.Kind.LOCAL, V8CodeEvaluator.this.expression, value.getHandle(), value, false);
                voe = new VarOrError(var);
            }
            catch (EvaluationError ex) {
                voe = new VarOrError(ex);
            }
            V8CodeEvaluator.this.result.setAndOpen(exp, (Object)voe, (Object)this.getHistoryItem(exp, voe));
            V8CodeEvaluator.this.historyPersistence.addExpression(exp);
            V8CodeEvaluator.this.firePropertyChange("expressionsHistory", null, null);
        }

        private CodeEvaluator.Result.DefaultHistoryItem getHistoryItem(String expr, VarOrError voe) {
            if (voe != null) {
                String err;
                if (voe.hasVar()) {
                    Variable var = voe.getVar();
                    try {
                        V8Value value = var.getValue();
                        String type = V8Evaluator.getStringType(value);
                        String stringValue = V8Evaluator.getStringValue(value);
                        return new CodeEvaluator.Result.DefaultHistoryItem(expr, type, stringValue, stringValue);
                    }
                    catch (EvaluationError ee) {
                        err = ee.getLocalizedMessage();
                    }
                } else {
                    return null;
                }
                return new CodeEvaluator.Result.DefaultHistoryItem(expr, "", err, err);
            }
            return null;
        }
    }

    private class V8ContextProvider
    implements EditorContextSetter.EditorContextProvider {
        private V8ContextProvider() {
        }

        public Line.Part getContext() {
            V8Script script;
            CallFrame frame = V8CodeEvaluator.this.dbg.getCurrentFrame();
            if (frame != null && (script = frame.getScript()) != null) {
                Line l;
                int column;
                FileObject file = V8CodeEvaluator.this.dbg.getScriptsHandler().getFile(script);
                V8Frame f = frame.getFrame();
                int line = (int)f.getLine();
                if (line < 0) {
                    line = 0;
                }
                if ((column = (int)f.getColumn()) < 0) {
                    column = 0;
                }
                if ((l = EditorUtils.getLine(file, line)) != null) {
                    return l.createPart(column, 0);
                }
            }
            return null;
        }
    }
}

