/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;

public class IriRef
extends AbstractDatatype {
    public static final IriRef THE_INSTANCE = new IriRef();
    private static final boolean WARN = System.getProperty("org.whattf.datatype.warn", "").equals("true");

    protected IriRef() {
    }

    private final CharSequencePair splitScheme(CharSequence iri) {
        StringBuilder sb = new StringBuilder();
        Boolean atSchemeBeginning = true;
        for (int i = 0; i < iri.length(); ++i) {
            char c = IriRef.toAsciiLowerCase(iri.charAt(i));
            if (atSchemeBeginning.booleanValue()) {
                if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
                if ('a' <= c && 'z' >= c) {
                    atSchemeBeginning = false;
                    sb.append(c);
                    continue;
                }
                return null;
            }
            if ('a' <= c && 'z' >= c || '0' <= c && '9' >= c || c == '+' || c == '.') {
                sb.append(c);
                continue;
            }
            if (c == ':') {
                return new CharSequencePair(sb, iri.subSequence(i + 1, iri.length()));
            }
            return null;
        }
        return null;
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
    }

    private final boolean isHttpAlias(CharSequence scheme) {
        return "feed".contentEquals(scheme) || "webcal".contentEquals(scheme);
    }

    private final boolean isWellKnown(CharSequence scheme) {
        return "http".contentEquals(scheme) || "https".contentEquals(scheme) || "ftp".contentEquals(scheme) || "mailto".contentEquals(scheme) || "file".contentEquals(scheme);
    }

    protected boolean isAbsolute() {
        return false;
    }

    protected static final String underbarStringToSentence(String str) {
        if (str == null) {
            return null;
        }
        char[] buf = new char[str.length()];
        buf[0] = str.charAt(0);
        for (int i = 1; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (c >= 65 && c <= 90) {
                c = (char)(c + 32);
            } else if (c == 95) {
                c = 32;
            }
            buf[i] = c;
        }
        return new String(buf);
    }

    protected static final String trimHtmlSpaces(String str) {
        return IriRef.trimHtmlLeadingSpaces(IriRef.trimHtmlTrailingSpaces(str));
    }

    protected static final String trimHtmlLeadingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length(); i > 0; --i) {
            char c = str.charAt(str.length() - i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(str.length() - i, str.length());
        }
        return "";
    }

    protected static final String trimHtmlTrailingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(0, i + 1);
        }
        return "";
    }

    @Override
    public String getName() {
        return "IRI reference";
    }

    private class CharSequencePair {
        private final CharSequence head;
        private final CharSequence tail;

        public CharSequencePair(CharSequence head, CharSequence tail) {
            this.head = head;
            this.tail = tail;
        }

        public CharSequence getHead() {
            return this.head;
        }

        public CharSequence getTail() {
            return this.tail;
        }
    }

    private static enum KnownViolationCode {
        COMPATIBILITY_CHARACTER,
        CONTROL_CHARACTER,
        DNS_LABEL_DASH_START_OR_END,
        DOUBLE_WHITESPACE,
        EMPTY_SCHEME,
        HAS_PASSWORD,
        ILLEGAL_CHARACTER,
        ILLEGAL_PERCENT_ENCODING,
        IP_V4_HAS_FOUR_COMPONENTS,
        IP_V4_OCTET_RANGE,
        IP_V6_OR_FUTURE_ADDRESS_SYNTAX,
        NON_INITIAL_DOT_SEGMENT,
        NOT_DNS_NAME,
        PORT_SHOULD_NOT_BE_WELL_KNOWN,
        REQUIRED_COMPONENT_MISSING,
        SCHEME_MUST_START_WITH_LETTER,
        UNDEFINED_UNICODE_CHARACTER,
        UNICODE_WHITESPACE,
        UNREGISTERED_NONIETF_SCHEME_TREE,
        WHITESPACE,
        ZZZ_DUMMY_DEFAULT;

    }
}

