/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import java.util.Arrays;
import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;

public class MetaName
extends AbstractDatatype {
    private static final String[] VALID_NAMES = new String[]{"alexaverifyid", "apple-mobile-web-app-capable", "apple-mobile-web-app-status-bar-style", "application-name", "author", "baiduspider", "csrf-param", "csrf-token", "dc.date.issued", "dc.language", "dcterms.abstract", "dcterms.accessrights", "dcterms.accrualmethod", "dcterms.accrualperiodicity", "dcterms.accrualpolicy", "dcterms.alternative", "dcterms.audience", "dcterms.available", "dcterms.bibliographiccitation", "dcterms.conformsto", "dcterms.contributor", "dcterms.coverage", "dcterms.created", "dcterms.creator", "dcterms.date", "dcterms.dateaccepted", "dcterms.datecopyrighted", "dcterms.datesubmitted", "dcterms.description", "dcterms.educationlevel", "dcterms.extent", "dcterms.format", "dcterms.hasformat", "dcterms.haspart", "dcterms.hasversion", "dcterms.identifier", "dcterms.instructionalmethod", "dcterms.isformatof", "dcterms.ispartof", "dcterms.isreferencedby", "dcterms.isreplacedby", "dcterms.isrequiredby", "dcterms.issued", "dcterms.isversionof", "dcterms.language", "dcterms.license", "dcterms.mediator", "dcterms.medium", "dcterms.modified", "dcterms.provenance", "dcterms.publisher", "dcterms.references", "dcterms.relation", "dcterms.replaces", "dcterms.requires", "dcterms.rights", "dcterms.rightsholder", "dcterms.source", "dcterms.spatial", "dcterms.subject", "dcterms.tableofcontents", "dcterms.temporal", "dcterms.title", "dcterms.type", "dcterms.valid", "description", "designer", "es.title", "essaydirectory", "format-detection", "generator", "geo.a1", "geo.a2", "geo.a3", "geo.country", "geo.lmk", "geo.placename", "geo.position", "geo.region", "globrix.bathrooms", "globrix.bedrooms", "globrix.condition", "globrix.features", "globrix.instruction", "globrix.latitude", "globrix.longitude ", "globrix.outsidespace", "globrix.parking", "globrix.period", "globrix.poa", "globrix.postcode", "globrix.price", "globrix.priceproximity", "globrix.tenure", "globrix.type", "globrix.underoffer", "google-site-verification", "googlebot", "handheldfriendly", "icbm", "itemsperpage", "keywords", "meta_date", "mobileoptimized", "msapplication-navbutton-color", "msapplication-starturl", "msapplication-task", "msapplication-tooltip", "msapplication-window", "msvalidate.01", "norton-safeweb-site-verification", "publisher", "rating", "referrer", "review_date", "revisit-after", "rights-standard", "robots", "slurp", "startindex", "teoma", "totalresults", "verify-v1", "viewport", "wt.ac", "wt.ad", "wt.cg_n", "wt.cg_s", "wt.mc_id", "wt.sv", "wt.ti", "y_key", "yandex-verification"};
    public static final MetaName THE_INSTANCE = new MetaName();

    private MetaName() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        String token = MetaName.toAsciiLowerCase(literal);
        if (Arrays.binarySearch(VALID_NAMES, token) < 0) {
            throw this.newDatatypeException("Keyword ", token, " is not registered.");
        }
    }

    @Override
    public String getName() {
        return "metadata name";
    }
}

