/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.io;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import org.whattf.io.Base64InputStream;
import org.whattf.io.DataUriException;
import org.whattf.io.PercentDecodingReaderInputStream;

public class DataUri {
    private String contentType;
    private InputStream inputStream;

    public static boolean startsWithData(String uri) {
        return !(uri == null || uri.length() < 5 || uri.charAt(0) != 'd' && uri.charAt(0) != 'D' || uri.charAt(1) != 'a' && uri.charAt(1) != 'A' || uri.charAt(2) != 't' && uri.charAt(2) != 'T' || uri.charAt(3) != 'a' && uri.charAt(3) != 'A' || uri.charAt(4) != ':');
    }

    protected void init(IRI uri) throws IOException, MalformedURLException {
        if (!uri.getScheme().equals("data")) {
            throw new IllegalArgumentException("The input did not start with data:.");
        }
        if (uri.getRawFragment() != null) {
            throw new MalformedURLException("Fragment is not allowed for data: URIs according to RFC 2397. But if strictly comply with RFC 3986, ignore this error.");
        }
        PercentDecodingReaderInputStream is = new PercentDecodingReaderInputStream(new StringReader(uri.getRawPath()));
        StringBuilder sb = new StringBuilder();
        State state = State.AT_START;
        int i = 0;
        while (true) {
            int b;
            if ((b = ((InputStream)is).read()) == -1) {
                throw new MalformedURLException("Premature end of URI.");
            }
            if (b >= 128) {
                throw new MalformedURLException("Non-ASCII character in MIME type part of the data URI.");
            }
            char c = (char)b;
            sb.append(c);
            switch (state) {
                case AT_START: {
                    if (this.isTokenChar(c)) {
                        state = State.IN_SUPERTYPE;
                        break;
                    }
                    if (c == ';') {
                        sb.setLength(0);
                        sb.append("text/plain;");
                        state = State.SEMICOLON_SEEN;
                        break;
                    }
                    if (c == ',') {
                        this.contentType = "text/plain;charset=US-ASCII";
                        this.inputStream = is;
                        return;
                    }
                    throw this.newDatatypeException(i, "Expected a token character or a semicolon but saw ", c, " instead.");
                }
                case IN_SUPERTYPE: {
                    if (this.isTokenChar(c)) break;
                    if (c == '/') {
                        state = State.AT_SUBTYPE_START;
                        break;
                    }
                    throw this.newDatatypeException(i, "Expected a token character or \u201c/\u201d but saw ", c, " instead.");
                }
                case AT_SUBTYPE_START: {
                    if (this.isTokenChar(c)) {
                        state = State.IN_SUBTYPE;
                        break;
                    }
                    throw this.newDatatypeException(i, "Expected a token character but saw ", c, " instead.");
                }
                case IN_SUBTYPE: {
                    if (this.isTokenChar(c)) break;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        break;
                    }
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_SEMICOLON;
                        break;
                    }
                    if (c == ',') {
                        this.contentType = sb.substring(0, sb.length() - 1);
                        this.inputStream = is;
                        return;
                    }
                    throw this.newDatatypeException(i, "Expected a token character, whitespace, a semicolon or a comma but saw ", c, " instead.");
                }
                case WS_BEFORE_SEMICOLON: {
                    if (this.isWhitespace(c)) break;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        break;
                    }
                    throw this.newDatatypeException(i, "Expected whitespace or a semicolon but saw ", c, " instead.");
                }
                case SEMICOLON_SEEN: {
                    if (this.isWhitespace(c)) break;
                    if (this.isTokenChar(c)) {
                        state = State.IN_PARAM_NAME;
                        break;
                    }
                    throw this.newDatatypeException(i, "Expected whitespace or a token character but saw ", c, " instead.");
                }
                case IN_PARAM_NAME: {
                    if (this.isTokenChar(c)) break;
                    if (c == '=') {
                        state = State.EQUALS_SEEN;
                        break;
                    }
                    if (c == ',') {
                        int baseFirst = sb.length() - 8;
                        if (baseFirst >= 0 && ";base64,".equals(sb.substring(baseFirst, sb.length()))) {
                            this.contentType = sb.substring(0, baseFirst);
                            this.inputStream = new Base64InputStream(is);
                            return;
                        }
                    } else {
                        throw this.newDatatypeException(i, "Expected an equals sign, a comma or a token character but saw ", c, " instead.");
                    }
                }
                case EQUALS_SEEN: {
                    if (c == '\"') {
                        state = State.IN_QUOTED_STRING;
                        break;
                    }
                    if (this.isTokenChar(c)) {
                        state = State.IN_UNQUOTED_STRING;
                        break;
                    }
                    throw this.newDatatypeException(i, "Expected a double quote or a token character but saw ", c, " instead.");
                }
                case IN_QUOTED_STRING: {
                    if (c == '\\') {
                        state = State.IN_QUOTED_PAIR;
                        break;
                    }
                    if (c == '\"') {
                        state = State.CLOSE_QUOTE_SEEN;
                        break;
                    }
                    if (this.isQDTextChar(c)) break;
                    throw this.newDatatypeException(i, "Expected a non-control ASCII character but saw ", c, " instead.");
                }
                case IN_QUOTED_PAIR: {
                    if (c <= '\u007f') {
                        state = State.IN_QUOTED_STRING;
                        break;
                    }
                    throw this.newDatatypeException(i, "Expected an ASCII character but saw ", c, " instead.");
                }
                case CLOSE_QUOTE_SEEN: {
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        break;
                    }
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_SEMICOLON;
                        break;
                    }
                    if (c == ',') {
                        this.contentType = sb.substring(0, sb.length() - 1);
                        this.inputStream = is;
                        return;
                    }
                    throw this.newDatatypeException(i, "Expected an ASCII character but saw ", c, " instead.");
                }
                case IN_UNQUOTED_STRING: {
                    if (this.isTokenChar(c)) break;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        break;
                    }
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_SEMICOLON;
                        break;
                    }
                    if (c == ',') {
                        this.contentType = sb.substring(0, sb.length() - 1);
                        this.inputStream = is;
                        return;
                    }
                    throw this.newDatatypeException(i, "Expected a token character, whitespace, a semicolon, or a comma but saw ", c, " instead.");
                }
            }
            ++i;
        }
    }

    public DataUri(String uri) throws IOException, MalformedURLException {
        IRIFactory fac = new IRIFactory();
        fac.shouldViolation(true, false);
        fac.securityViolation(true, false);
        fac.dnsViolation(true, false);
        fac.mintingViolation(false, false);
        fac.useSpecificationIRI(true);
        this.init(fac.construct(uri));
    }

    public DataUri(IRI uri) throws IOException, MalformedURLException {
        this.init(uri);
    }

    private IOException newDatatypeException(int i, String head, char c, String tail) {
        return new DataUriException(i, head, c, tail);
    }

    private boolean isQDTextChar(char c) {
        return c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t';
    }

    private boolean isTokenChar(char c) {
        return c >= '!' && c <= '~' && c != '(' && c != ')' && c != '<' && c != '>' && c != '@' && c != ',' && c != ';' && c != ':' && c != '\\' && c != '\"' && c != '/' && c != '[' && c != ']' && c != '?' && c != '=' && c != '{' && c != '}';
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    private static enum State {
        AT_START,
        IN_SUPERTYPE,
        AT_SUBTYPE_START,
        IN_SUBTYPE,
        SEMICOLON_SEEN,
        WS_BEFORE_SEMICOLON,
        IN_PARAM_NAME,
        EQUALS_SEEN,
        IN_QUOTED_STRING,
        IN_UNQUOTED_STRING,
        IN_QUOTED_PAIR,
        CLOSE_QUOTE_SEEN;

    }
}

