/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.keystore;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class KeyStoreRepository
implements Externalizable,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(KeyStoreRepository.class.getName());
    public static boolean rememberPasswords = true;
    public static final String PROP_KEYSTORE_ADDED = "keystore_added";
    public static final String PROP_KEYSTORE_REMOVED = "keystore_removed";
    public static final String PROP_OPENED = "opened";
    private static final long serialVersionUID = -4428411825913512121L;
    private static transient boolean defaultKeyStoreInitialized = false;
    private static KeyStoreRepository repo;
    private static KeyStoreBean defaultKeyStore;
    private static final String PASSWORD = "password";
    private ArrayList<KeyStoreBean> keyStores = new ArrayList();
    private final transient Map<String, Object> passwords = Collections.synchronizedMap(new HashMap());
    PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public KeyStoreRepository() {
        if (defaultKeyStore != null) {
            this.keyStores.add(defaultKeyStore);
        }
    }

    public static boolean isDefaultKeystore(KeyStoreBean keystore) {
        if (!defaultKeyStoreInitialized) {
            KeyStoreRepository.getDefault();
        }
        return keystore != null && keystore == defaultKeyStore;
    }

    public static synchronized KeyStoreRepository getDefault() {
        if (repo == null) {
            defaultKeyStoreInitialized = true;
            File file = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            if (file != null) {
                file = new File(file, "j2me" + File.separator + "builtin.ks");
            }
            if (file != null) {
                KeyStoreBean bean = KeyStoreBean.create(file.getAbsolutePath(), PASSWORD);
                if (!file.exists() && bean.openKeyStore(true)) {
                    try {
                        bean.addKeyToStore("trusted", "CN=trusted", PASSWORD, -1);
                        bean.addKeyToStore("untrusted", "CN=untrusted", PASSWORD, -1);
                        bean.addKeyToStore("minimal", "CN=minimal", PASSWORD, -1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        bean = null;
                    }
                }
                if ((defaultKeyStore = bean) != null) {
                    defaultKeyStore.openKeyStore();
                    if (defaultKeyStore.isOpened()) {
                        for (KeyStoreBean.KeyAliasBean alias : defaultKeyStore.aliasses()) {
                            alias.setPassword(PASSWORD);
                            alias.open();
                        }
                    }
                }
            }
            repo = (KeyStoreRepository)Lookup.getDefault().lookup(KeyStoreRepository.class);
        }
        return repo;
    }

    public static KeyStoreRepository createRepository() {
        return new KeyStoreRepository();
    }

    public Object getPassword(String keyFile) {
        return this.passwords.get(keyFile);
    }

    public Object putPassword(String keyFile, Object password) {
        return this.passwords.put(keyFile, password);
    }

    public Object removePassword(String keyFile) {
        return this.passwords.remove(keyFile);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException {
        this.keyStores = new ArrayList();
        if (defaultKeyStore != null) {
            this.keyStores.add(defaultKeyStore);
        }
        try {
            while (true) {
                KeyStoreBean keyStoreBean = (KeyStoreBean)in.readObject();
                this.keyStores.add(keyStoreBean);
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        for (KeyStoreBean keyStoreBean : this.keyStores) {
            if (keyStoreBean == defaultKeyStore) continue;
            out.writeObject(keyStoreBean);
        }
    }

    public List<KeyStoreBean> getKeyStores() {
        return this.keyStores;
    }

    public void addKeyStore(KeyStoreBean bean) {
        if (bean == null) {
            return;
        }
        if (this.getKeyStore(bean.getKeyStorePath(), false) != null) {
            return;
        }
        this.keyStores.add(bean);
        bean.addPropertyChangeListener(this);
        this.propertyChangeSupport.firePropertyChange(PROP_KEYSTORE_ADDED, null, null);
    }

    public void removeKeyStore(KeyStoreBean bean) {
        bean.removePropertyChangeListener(this);
        this.keyStores.remove(bean);
        this.propertyChangeSupport.firePropertyChange(PROP_KEYSTORE_REMOVED, null, null);
    }

    public KeyStoreBean getKeyStore(String path, boolean create) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        for (KeyStoreBean bean : this.keyStores) {
            if (!KeyStoreBean.equalFiles(bean.getKeyStoreFile(), file)) continue;
            return bean;
        }
        if (!create) {
            return null;
        }
        KeyStoreBean bean = KeyStoreBean.create(path);
        this.addKeyStore(bean);
        return bean;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public static class KeyStoreBean
    implements Externalizable {
        private static final long serialVersionUID = -38422947758836052L;
        public static final String PROP_PASSWORD = "password";
        public static final String PROP_PATH2KEY_STORE = "pathToKeyStore";
        public static final String PROP_TYPE = "type";
        PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        private File keyStoreFile;
        private String password;
        private String type;
        private static final String JKS = "JKS";
        private transient boolean opened = false;
        private transient KeyStore store;
        private transient TreeSet<KeyAliasBean> aliasses = new TreeSet();

        public static KeyStoreBean create(String pathToKeyStore) {
            if (pathToKeyStore == null) {
                return null;
            }
            KeyStoreBean bean = new KeyStoreBean();
            bean.keyStoreFile = new File(pathToKeyStore);
            bean.type = (pathToKeyStore = pathToKeyStore.toLowerCase()).endsWith(".pkcs12") || pathToKeyStore.endsWith(".p12") ? "PKCS12" : JKS;
            return bean;
        }

        public static KeyStoreBean create(String pathToKeyStore, String password) {
            KeyStoreBean bean = KeyStoreBean.create(pathToKeyStore);
            bean.password = password;
            return bean;
        }

        public boolean isValid() {
            return this.keyStoreFile.exists() && this.keyStoreFile.isFile();
        }

        public String getType() {
            if (this.type == null) {
                return JKS;
            }
            return this.type;
        }

        public void setType(String type) {
            String newType;
            String string = newType = type == null ? JKS : type.toUpperCase();
            if (!"PKCS12".equals(newType)) {
                newType = JKS;
            }
            if (!newType.equals(this.type)) {
                this.type = newType;
                this.propertyChangeSupport.firePropertyChange(PROP_TYPE, null, null);
            }
        }

        public File getKeyStoreFile() {
            return this.keyStoreFile;
        }

        public String getKeyStorePath() {
            return this.keyStoreFile.getAbsolutePath();
        }

        public void setKeyStoreFile(File keyStoreFile) {
            this.keyStoreFile = keyStoreFile;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isOpened() {
            return this.opened;
        }

        public KeyStore getStore() {
            return this.store;
        }

        public Set<KeyAliasBean> aliasses() {
            return Collections.unmodifiableSet(this.aliasses);
        }

        public KeyAliasBean getAlias(String alias) {
            for (KeyAliasBean keyAliasBean : this.aliasses) {
                if (!alias.equals(keyAliasBean.getAlias())) continue;
                return keyAliasBean;
            }
            return null;
        }

        public boolean openKeyStore() {
            return this.openKeyStore(false);
        }

        public synchronized boolean openKeyStore(boolean create) {
            block20: {
                if (this.opened) {
                    return true;
                }
                this.clearAliasses();
                if (this.getPassword() == null) {
                    return false;
                }
                try {
                    this.store = "PKCS12".equals(this.type) ? KeyStore.getInstance("pkcs12", "SunJSSE") : KeyStore.getInstance(JKS, "SUN");
                    if (this.keyStoreFile.exists()) {
                        try (FileInputStream fis = new FileInputStream(this.keyStoreFile);){
                            this.store.load(fis, this.password.toCharArray());
                            break block20;
                        }
                    }
                    this.store.load(null, this.password.toCharArray());
                    if (!create) {
                        return false;
                    }
                    this.storeKeyStore();
                }
                catch (IOException | IndexOutOfBoundsException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                    return false;
                }
            }
            this.opened = true;
            this.loadAliasses(null);
            this.propertyChangeSupport.firePropertyChange(KeyStoreRepository.PROP_OPENED, false, true);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean storeKeyStore() throws IOException {
            if (KeyStoreRepository.isDefaultKeystore(this)) {
                return false;
            }
            if (this.store == null) {
                return false;
            }
            FileOutputStream fos = null;
            try {
                File parent;
                if (!this.keyStoreFile.exists() && (parent = this.keyStoreFile.getParentFile()) != null && !parent.exists()) {
                    parent.mkdirs();
                }
                fos = new FileOutputStream(this.keyStoreFile);
                this.store.store(fos, this.password.toCharArray());
            }
            catch (IOException ioEx) {
                throw ioEx;
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
            return true;
        }

        public boolean closeKeyStore() {
            this.opened = false;
            this.store = null;
            this.propertyChangeSupport.firePropertyChange(KeyStoreRepository.PROP_OPENED, true, false);
            return true;
        }

        public void refresh() throws IOException {
            TreeSet<KeyAliasBean> oldAliasses = this.aliasses;
            this.clearAliasses();
            if (this.getPassword() == null) {
                return;
            }
            try (FileInputStream fis = new FileInputStream(this.keyStoreFile);){
                this.store.load(fis, this.password.toCharArray());
                this.loadAliasses(oldAliasses);
            }
            catch (IOException ioEx) {
                throw ioEx;
            }
            catch (NoSuchAlgorithmException | CertificateException generalSecurityException) {
                // empty catch block
            }
        }

        private void clearAliasses() {
            this.aliasses = new TreeSet();
        }

        private void loadAliasses(TreeSet<KeyAliasBean> oldAliassesWithPasswords) {
            this.aliasses = new TreeSet();
            try {
                Enumeration<String> e = this.store.aliases();
                while (e.hasMoreElements()) {
                    String alias = e.nextElement();
                    if (!this.store.isKeyEntry(alias)) continue;
                    KeyAliasBean newAlias = new KeyAliasBean(this.store, alias);
                    if (oldAliassesWithPasswords != null) {
                        newAlias.getAlias();
                        for (KeyAliasBean oldKeyAliasBean : oldAliassesWithPasswords) {
                            if (!newAlias.equals(oldKeyAliasBean)) continue;
                            newAlias.setPassword(oldKeyAliasBean.getPassword());
                            if (!oldKeyAliasBean.isOpened()) break;
                            newAlias.open();
                            break;
                        }
                    }
                    this.aliasses.add(newAlias);
                }
            }
            catch (KeyStoreException e1) {
                this.aliasses = new TreeSet();
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.getKeyStorePath());
            out.writeUTF(this.getType());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.keyStoreFile = new File(in.readUTF());
            this.type = in.readUTF();
        }

        public KeyAliasBean addKeyToStore(String alias, String dname, String keyPass, int validity) throws IOException {
            if (KeyStoreRepository.isDefaultKeystore(this)) {
                return null;
            }
            if (alias == null) {
                return null;
            }
            if (keyPass == null || "".equals(keyPass)) {
                keyPass = this.getPassword();
            }
            if (validity == -1) {
                validity = 180;
            }
            String[] as = new String[]{"-genkey", "-alias", alias, "-keyalg", "RSA", "-dname", dname, "-keystore", this.getKeyStorePath(), "-storepass", this.getPassword(), "-keypass", keyPass, "-storetype", this.getType(), "-validity", String.valueOf(validity)};
            try {
                Class<?> keyTool;
                try {
                    keyTool = Class.forName("sun.security.tools.KeyTool");
                }
                catch (ClassNotFoundException ex) {
                    try {
                        keyTool = Class.forName("sun.security.tools.keytool.Main");
                    }
                    catch (ClassNotFoundException ex2) {
                        LOG.log(Level.WARNING, "No KeyTool found.");
                        return null;
                    }
                }
                Method main = keyTool.getDeclaredMethod("main", String[].class);
                main.invoke(null, new Object[]{as});
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException se) {
                return null;
            }
            this.refresh();
            return this.getAlias(alias);
        }

        public KeyAliasBean createInvalidKeyAliasBean(String alias) {
            KeyAliasBean bean = new KeyAliasBean(this.store, alias);
            bean.invalidate();
            return bean;
        }

        public boolean removeAliasFromStore(KeyAliasBean alias) throws IOException {
            if (KeyStoreRepository.isDefaultKeystore(this)) {
                return false;
            }
            if (!this.opened || alias == null) {
                return false;
            }
            try {
                this.store.deleteEntry(alias.getAlias());
                this.storeKeyStore();
                this.loadAliasses(this.aliasses);
                return true;
            }
            catch (KeyStoreException e) {
                return false;
            }
        }

        public static boolean equalFiles(File f1, File f2) {
            f1 = FileUtil.normalizeFile((File)f1);
            f2 = FileUtil.normalizeFile((File)f2);
            return f1 != null && f1.equals(f2);
        }

        public boolean equals(Object o) {
            if (o instanceof KeyStoreBean) {
                KeyStoreBean b2 = (KeyStoreBean)o;
                return KeyStoreBean.equalFiles(this.getKeyStoreFile(), b2.getKeyStoreFile());
            }
            if (o instanceof String) {
                return KeyStoreBean.equalFiles(this.getKeyStoreFile(), new File((String)o));
            }
            return false;
        }

        public int hashCode() {
            File f = this.getKeyStoreFile();
            return f != null ? FileUtil.normalizeFile((File)f).hashCode() : super.hashCode();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.propertyChangeSupport.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }

        public static class KeyAliasBean
        implements Comparable {
            private final KeyStore store;
            private final String alias;
            private String password;
            private boolean opened;
            private boolean valid;
            private String issuerName;
            private String subjectName;
            private String serialNumber;
            private Date notBefore;
            private Date notAfter;
            private String md5;
            private String sha;

            public KeyAliasBean(KeyStore store, String alias) {
                this.store = store;
                this.alias = alias;
                this.opened = false;
                this.valid = true;
            }

            public void invalidate() {
                this.valid = false;
            }

            public void setPassword(String password) {
                this.password = password;
            }

            public boolean isOpened() {
                return this.opened;
            }

            public boolean isValid() {
                return this.valid;
            }

            public boolean open() {
                if (this.opened) {
                    return true;
                }
                if (!this.valid || this.alias == null || this.password == null) {
                    return false;
                }
                try {
                    this.store.getKey(this.alias, this.password.toCharArray());
                    Certificate cert = this.store.getCertificate(this.alias);
                    if (cert instanceof X509Certificate) {
                        X509Certificate certx509 = (X509Certificate)cert;
                        this.subjectName = certx509.getSubjectDN().getName();
                        this.issuerName = certx509.getIssuerDN().getName();
                        this.serialNumber = certx509.getSerialNumber().toString(16).toUpperCase();
                        this.notBefore = certx509.getNotBefore();
                        this.notAfter = certx509.getNotAfter();
                        try {
                            byte[] encoded = certx509.getEncoded();
                            this.md5 = KeyAliasBean.createFingerPrint(encoded, "MD5".toUpperCase());
                            this.sha = KeyAliasBean.createFingerPrint(encoded, "SHA".toUpperCase());
                        }
                        catch (CertificateEncodingException certificateEncodingException) {}
                    }
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    return false;
                }
                this.opened = true;
                return true;
            }

            public static String createFingerPrint(byte[] encoded, String algorithm) {
                MessageDigest messagedigest;
                try {
                    messagedigest = MessageDigest.getInstance(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    return null;
                }
                messagedigest.update(encoded);
                byte[] abyte1 = messagedigest.digest();
                StringBuffer stringbuffer = new StringBuffer();
                for (int i = 0; i < abyte1.length; ++i) {
                    int j;
                    String s1;
                    if (i != 0) {
                        stringbuffer.append(':');
                    }
                    if ((s1 = Integer.toHexString(j = abyte1[i] & 0xFF)).length() == 1) {
                        stringbuffer.append('0');
                    }
                    stringbuffer.append(s1);
                }
                return stringbuffer.toString();
            }

            public String getAlias() {
                return this.alias;
            }

            public String getPassword() {
                return this.password;
            }

            public String getIssuerName() {
                return this.issuerName;
            }

            public String getSubjectName() {
                return this.subjectName;
            }

            public String getSerialNumber() {
                return this.serialNumber;
            }

            public Date getNotBefore() {
                return this.notBefore == null ? null : (Date)this.notBefore.clone();
            }

            public Date getNotAfter() {
                return this.notAfter == null ? null : (Date)this.notAfter.clone();
            }

            public String getMd5() {
                return this.md5;
            }

            public String getSha() {
                return this.sha;
            }

            public boolean equals(Object o) {
                if (o instanceof KeyAliasBean) {
                    return this.getAlias().equals(((KeyAliasBean)o).getAlias());
                }
                if (o instanceof String) {
                    return this.getAlias().equals(o);
                }
                return false;
            }

            public int hashCode() {
                return this.getAlias().hashCode();
            }

            public int compareTo(Object o) {
                return this.getAlias().compareTo(o instanceof String ? (String)o : ((KeyAliasBean)o).getAlias());
            }
        }
    }
}

