/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.exec;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.Bundle;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptions;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptionsValidator;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.javascript.nodejs.util.StringUtils;
import org.netbeans.modules.web.common.api.ExternalExecutable;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class ExpressExecutable {
    public static final String EXPRESS_NAME = Utilities.isWindows() ? "express.cmd" : "express";
    private static final String FORCE_PARAM = "--force";
    private static final String CSS_PARAM = "--css";
    private static final String LESS_PARAM = "less";
    protected final Project project;
    protected final String expressPath;

    ExpressExecutable(String expressPath, @NullAllowed Project project) {
        assert (expressPath != null);
        this.expressPath = expressPath;
        this.project = project;
    }

    @CheckForNull
    public static ExpressExecutable getDefault(@NullAllowed Project project, boolean showOptions) {
        ValidationResult result = new NodeJsOptionsValidator().validateExpress().getResult();
        if (ExpressExecutable.validateResult(result) != null) {
            if (showOptions) {
                OptionsDisplayer.getDefault().open("Html5/NodeJs");
            }
            return null;
        }
        return ExpressExecutable.createExecutable(NodeJsOptions.getInstance().getExpress(), project);
    }

    private static ExpressExecutable createExecutable(String express, Project project) {
        if (Utilities.isMac()) {
            return new MacExpressExecutable(express, project);
        }
        return new ExpressExecutable(express, project);
    }

    String getCommand() {
        return this.expressPath;
    }

    public Future<Integer> generate(FileObject target, boolean less) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = NodeJsUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.ExpressExecutable_generate(projectName)).additionalParameters(this.getGenerateParams(target, less)).run(this.getDescriptor());
        assert (task != null) : this.expressPath;
        return task;
    }

    private ExternalExecutable getExecutable(String title) {
        assert (title != null);
        return new ExternalExecutable(this.getCommand()).workDir(this.getWorkDir()).displayName(title).optionsPath("Html5/NodeJs").noOutput(false);
    }

    private ExecutionDescriptor getDescriptor() {
        assert (this.project != null);
        return ExternalExecutable.DEFAULT_EXECUTION_DESCRIPTOR.showSuspended(true).optionsPath("Html5/NodeJs").outLineBased(true).errLineBased(true).postExecution(new Runnable(){

            @Override
            public void run() {
                ExpressExecutable.this.project.getProjectDirectory().refresh();
            }
        });
    }

    private File getWorkDir() {
        if (this.project == null) {
            return FileUtils.TMP_DIR;
        }
        PackageJson packageJson = new PackageJson(this.project.getProjectDirectory());
        if (packageJson.exists()) {
            return new File(packageJson.getPath()).getParentFile();
        }
        File sourceRoot = NodeJsUtils.getSourceRoot(this.project);
        if (sourceRoot != null) {
            return sourceRoot;
        }
        File workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (workDir != null) : this.project.getProjectDirectory();
        return workDir;
    }

    private List<String> getGenerateParams(FileObject target, boolean less) {
        ArrayList<String> params = new ArrayList<String>(3);
        if (less) {
            params.add(CSS_PARAM);
            params.add(LESS_PARAM);
        }
        params.add(FORCE_PARAM);
        params.add(FileUtil.toFile((FileObject)target).getAbsolutePath());
        return this.getParams(params);
    }

    List<String> getParams(List<String> params) {
        assert (params != null);
        return params;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return result.getFirstErrorMessage();
        }
        return result.getFirstWarningMessage();
    }

    private static final class MacExpressExecutable
    extends ExpressExecutable {
        private static final String BASH_COMMAND = "/bin/bash -lc";

        MacExpressExecutable(String expressPath, Project project) {
            super(expressPath, project);
        }

        @Override
        String getCommand() {
            return BASH_COMMAND;
        }

        @Override
        List<String> getParams(List<String> params) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("\"");
            sb.append(this.expressPath);
            sb.append("\" \"");
            sb.append(StringUtils.implode(super.getParams(params), "\" \""));
            sb.append("\"");
            return Collections.singletonList(sb.toString());
        }
    }
}

