/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.javascript.nodejs.exec.NodeExecutable;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptions;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferences;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.modules.web.common.api.Version;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Utilities;

public final class NodeJsUtils {
    public static final String START_FILE_NODE_PREFIX = "node ";
    private static final String NODEJS_DIR_NAME = "nodejs";
    private static final String USAGE_LOGGER_NAME = "org.netbeans.ui.metrics.javascript.nodejs";
    private static final UsageLogger NPM_INSTALL_USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.javascript.nodejs").message(NodeJsUtils.class, "USG_NPM_INSTALL").create();
    private static final UsageLogger NPM_RUN_SCRIPT_USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.javascript.nodejs").message(NodeJsUtils.class, "USG_NPM_RUN_SCRIPT").firstMessageOnly(false).create();
    private static final UsageLogger NPM_LIBRARY_USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.javascript.nodejs").message(NodeJsUtils.class, "USG_NPM_LIBRARY").firstMessageOnly(false).create();

    private NodeJsUtils() {
    }

    public static void logUsageNpmInstall() {
        NPM_INSTALL_USAGE_LOGGER.log(new Object[0]);
    }

    public static void logUsageNpmRunScript(String script) {
        NPM_RUN_SCRIPT_USAGE_LOGGER.log(new Object[]{script});
    }

    public static void logUsageNpmLibrary(String type, String name, String version) {
        NPM_LIBRARY_USAGE_LOGGER.log(new Object[]{type, name, version});
    }

    public static String getProjectDisplayName(Project project) {
        return ProjectUtils.getInformation((Project)project).getDisplayName();
    }

    public static boolean isJsLibrary(Project project) {
        return NodeJsUtils.getSiteRoots(project).isEmpty();
    }

    @CheckForNull
    public static File getSourceRoot(Project project) {
        Iterator<File> i$ = NodeJsUtils.getSourceRoots(project).iterator();
        if (i$.hasNext()) {
            File root = i$.next();
            return root;
        }
        return null;
    }

    @CheckForNull
    public static File getSiteRoot(Project project) {
        Iterator<File> i$ = NodeJsUtils.getSiteRoots(project).iterator();
        if (i$.hasNext()) {
            File root = i$.next();
            return root;
        }
        return null;
    }

    @CheckForNull
    public static File getTestRoot(Project project) {
        Iterator<File> i$ = NodeJsUtils.getTestRoots(project).iterator();
        if (i$.hasNext()) {
            File root = i$.next();
            return root;
        }
        return null;
    }

    public static List<File> getSourceRoots(Project project) {
        return NodeJsUtils.getRoots(project, "HTML5-Sources");
    }

    public static List<File> getSiteRoots(Project project) {
        return NodeJsUtils.getRoots(project, "HTML5-SiteRoot");
    }

    public static List<File> getTestRoots(Project project) {
        return NodeJsUtils.getRoots(project, "HTML5-Tests");
    }

    public static List<File> getRoots(Project project, String type) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups(type);
        ArrayList<File> roots = new ArrayList<File>(sourceGroups.length);
        for (SourceGroup sourceGroup : sourceGroups) {
            FileObject rootFolder = sourceGroup.getRootFolder();
            File root = FileUtil.toFile((FileObject)rootFolder);
            assert (root != null) : rootFolder;
            roots.add(root);
        }
        return roots;
    }

    public static Pair<String, String> parseStartFile(String line) {
        assert (line != null);
        String data = line.trim();
        if (data.startsWith(START_FILE_NODE_PREFIX)) {
            data = data.substring(START_FILE_NODE_PREFIX.length());
        }
        String[] params = Utilities.parseParameters((String)data);
        String startFile = null;
        StringBuilder startArgsBuilder = new StringBuilder();
        for (String param : params) {
            if (startFile == null) {
                if (param.startsWith("-")) continue;
                startFile = param;
                continue;
            }
            if (startArgsBuilder.length() > 0) {
                startArgsBuilder.append(" ");
            }
            startArgsBuilder.append(param);
        }
        return Pair.of(startFile, (Object)startArgsBuilder.toString());
    }

    @CheckForNull
    public static PackageJson getPackageJson(Lookup context) {
        return (PackageJson)NodeJsUtils.getProjectAndPackageJson(context).second();
    }

    @CheckForNull
    public static Project getPackageJsonProject(Lookup context) {
        return (Project)NodeJsUtils.getProjectAndPackageJson(context).first();
    }

    public static Pair<Project, PackageJson> getProjectAndPackageJson(Lookup context) {
        Project project = (Project)context.lookup(Project.class);
        PackageJson packageJson = null;
        if (project != null) {
            packageJson = new PackageJson(project.getProjectDirectory());
        } else {
            DataObject dataObject;
            FileObject file = (FileObject)context.lookup(FileObject.class);
            if (file == null && (dataObject = (DataObject)context.lookup(DataObject.class)) != null) {
                file = dataObject.getPrimaryFile();
            }
            if (file != null) {
                packageJson = new PackageJson(file.getParent());
                project = FileOwnerQuery.getOwner((FileObject)file);
            }
        }
        if (project == null) {
            return Pair.of(null, null);
        }
        if (packageJson == null) {
            return Pair.of(null, null);
        }
        if (!packageJson.exists()) {
            return Pair.of(null, null);
        }
        assert (project != null);
        assert (packageJson != null);
        return Pair.of((Object)project, (Object)packageJson);
    }

    @CheckForNull
    public static File getNodeSources(Project project) {
        NodeJsPreferences preferences = NodeJsSupport.forProject(project).getPreferences();
        if (preferences.isDefaultNode()) {
            String nodeSources = NodeJsOptions.getInstance().getNodeSources();
            if (nodeSources != null) {
                return new File(nodeSources);
            }
            NodeExecutable node = NodeExecutable.getDefault(project, false);
            if (node == null) {
                return null;
            }
            Version version = node.getVersion();
            if (version == null) {
                return null;
            }
            return NodeJsUtils.getNodeSources(version);
        }
        String nodeSources = preferences.getNodeSources();
        if (nodeSources != null) {
            return new File(nodeSources);
        }
        NodeExecutable node = NodeExecutable.forProject(project, false);
        if (node == null) {
            return null;
        }
        Version version = node.getVersion();
        if (version == null) {
            return null;
        }
        return NodeJsUtils.getNodeSources(version);
    }

    public static File getNodeSources() {
        return Places.getCacheSubdirectory((String)NODEJS_DIR_NAME);
    }

    public static boolean hasNodeSources(Version version) {
        assert (version != null);
        return NodeJsUtils.getNodeSources(version).isDirectory();
    }

    public static boolean hasNodeSources(String version) {
        assert (version != null);
        return NodeJsUtils.getNodeSources(version).isDirectory();
    }

    static File getNodeSources(Version version) {
        assert (version != null);
        return NodeJsUtils.getNodeSources(version.toString());
    }

    private static File getNodeSources(String version) {
        assert (version != null);
        return new File(NodeJsUtils.getNodeSources(), version);
    }

    public static boolean isProject(File folder) {
        Project prj = null;
        boolean foundButBroken = false;
        try {
            prj = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)folder)));
        }
        catch (IOException ex) {
            foundButBroken = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (prj != null && !ProjectConvertors.isConvertorProject((Project)prj)) {
            return true;
        }
        return foundButBroken;
    }
}

