/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class ExportDiffCommand
extends GitCommand {
    private final VCSFileProxy[] roots;
    private final ProgressMonitor monitor;
    private final OutputStream out;
    private final FileListener listener;
    private final String firstCommit;
    private final String secondCommit;

    public ExportDiffCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy[] roots, String firstCommit, String secondCommit, OutputStream out, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
        this.firstCommit = firstCommit;
        this.secondCommit = secondCommit;
        this.out = out;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "diff");
        if ("HEAD".equals(this.firstCommit) && "INDEX".equals(this.secondCommit)) {
            this.addArgument(0, "--cached");
        } else if ("HEAD".equals(this.firstCommit) && "WORKING_TREE".equals(this.secondCommit)) {
            this.addArgument(0, "HEAD");
        } else if (!"INDEX".equals(this.firstCommit) || !"WORKING_TREE".equals(this.secondCommit)) {
            this.addArgument(0, this.firstCommit);
            this.addArgument(0, this.secondCommit);
        }
        this.addArgument(0, "--");
        this.addFiles(0, this.roots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        block15: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        try {
                            for (int i = 0; i < output.length(); ++i) {
                                ExportDiffCommand.this.out.write(output.charAt(i));
                            }
                        }
                        catch (Exception e) {
                            throw new GitException(e);
                        }
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) {
                    break block15;
                }
                throw new GitException(t);
            }
            finally {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

