/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitTransportUpdate;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.GitFetchResult;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.TransportCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class FetchCommand
extends TransportCommand {
    private final ProgressMonitor monitor;
    private final List<String> refSpecs;
    private final String remote;
    private Map<String, GitTransportUpdate> updates;
    private GitFetchResult result;

    public FetchCommand(JGitRepository repository, GitClassFactory gitFactory, String remoteName, ProgressMonitor monitor) {
        this(repository, gitFactory, remoteName, Collections.emptyList(), monitor);
    }

    public FetchCommand(JGitRepository repository, GitClassFactory gitFactory, String remote, List<String> fetchRefSpecifications, ProgressMonitor monitor) {
        super(repository, gitFactory, remote, monitor);
        this.monitor = monitor;
        this.remote = remote;
        this.refSpecs = fetchRefSpecifications;
    }

    public Map<String, GitTransportUpdate> getUpdates() {
        return Collections.unmodifiableMap(this.updates);
    }

    public GitFetchResult getResult() {
        return this.result;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "fetch");
        this.addArgument(0, "-v");
        this.addArgument(0, this.remote);
        for (String refSpec : this.refSpecs) {
            this.addArgument(0, refSpec);
        }
    }

    @Override
    protected void runTransportCommand() throws GitException.AuthorizationException, GitException {
        block5: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                this.result = new GitFetchResult();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        FetchCommand.this.parseFetchOutput(output);
                    }
                }.runCLI();
                this.updates = new LinkedHashMap<String, GitTransportUpdate>();
                for (GitTransportUpdate.GitTransportUpdateContainer c : this.result.result.values()) {
                    this.updates.put(c.url, this.getClassFactory().createTransportUpdate(c));
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block5;
                throw new GitException(t);
            }
        }
    }

    private void parseFetchOutput(String output) {
        String url = null;
        for (String line : output.split("\n")) {
            int i;
            if (line.startsWith("From")) {
                String[] s = line.split("\\s");
                url = s[s.length - 1];
                continue;
            }
            if (!line.startsWith("*") && !line.startsWith(" ")) continue;
            GitTransportUpdate.GitTransportUpdateContainer details = new GitTransportUpdate.GitTransportUpdateContainer();
            boolean bl = details.def = '*' == (line = line.trim()).charAt(0);
            if (details.def) {
                line = line.substring(1).trim();
            }
            if ((i = line.indexOf("->")) > 0) {
                details.remoteBranch = line.substring(i + 2).trim();
            }
            if ((line = line.substring(0, i).trim()).startsWith("[new branch]")) {
                details.newBranch = "new branch";
                details.localBranch = line.substring(line.indexOf(93) + 1).trim();
            } else {
                String[] s = line.split("\\s+");
                if (s.length == 2) {
                    details.newBranch = s[0];
                    if (details.newBranch.startsWith("[") && details.newBranch.endsWith("]")) {
                        details.newBranch = details.newBranch.substring(1, details.newBranch.length() - 1);
                    }
                    details.localBranch = s[1];
                }
            }
            details.url = url;
            this.result.result.put(url, details);
        }
    }
}

