/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeWatch;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.VariableModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchVariable;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.MaxObjectAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineCapability;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.actions.SystemAction;

public final class WatchModel
extends VariableModel
implements NodeActionsProvider {
    private final EmptyWatch EMPTY_WATCH = new EmptyWatch();
    private static final String ICON_PATH = "org/netbeans/modules/cnd/debugger/common2/icons/";
    private static final String ICON_WATCH1 = "org/netbeans/modules/cnd/debugger/common2/icons/watch_type1";
    private static final String ICON_WATCH1_PTR = "org/netbeans/modules/cnd/debugger/common2/icons/watch_type1_pointer";
    private static final String ICON_WATCH2 = "org/netbeans/modules/cnd/debugger/common2/icons/watch_type2";
    private static final String ICON_WATCH2_PTR = "org/netbeans/modules/cnd/debugger/common2/icons/watch_type2_pointer";
    public static final Action DELETE_ACTION = Models.createAction((String)Catalog.get("ACT_WATCH_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return !(node instanceof EmptyWatch);
        }

        public void perform(final Object[] nodes) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.perform(nodes);
                    }
                });
                return;
            }
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                if (nodes[i] instanceof WatchVariable) {
                    WatchVariable w = (WatchVariable)nodes[i];
                    w.getNativeWatch().postDelete(false);
                    continue;
                }
                ((Watch)nodes[i]).remove();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    public static final Action NEW_WATCH_ACTION;

    public WatchModel(ContextProvider ctx) {
        super(ctx);
    }

    public WatchModel() {
    }

    private static NativeDebuggerManager manager() {
        return NativeDebuggerManager.get();
    }

    private static WatchBag watchBag() {
        return WatchModel.manager().watchBag();
    }

    @Override
    protected boolean isLocal() {
        return false;
    }

    @Override
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        assert (!(parent instanceof Watch));
        if (parent == "Root") {
            Object[] watches = this.debugger != null ? WatchModel.watchBag().watchesFor(this.debugger) : WatchModel.manager().getWatches();
            Object[] res = new Object[watches.length + 1];
            System.arraycopy(watches, 0, res, 0, watches.length);
            res[watches.length] = this.EMPTY_WATCH;
            return res;
        }
        if (parent instanceof Variable) {
            Variable v = (Variable)parent;
            Object[] children = v.getChildren();
            if (v.hasMore()) {
                Object[] newChildren = new Object[children.length + 1];
                System.arraycopy(children, 0, newChildren, 0, children.length);
                newChildren[newChildren.length - 1] = new VariableModel.ShowMoreMessage(v);
                children = newChildren;
            }
            return children;
        }
        throw new UnknownTypeException(parent);
    }

    @Override
    public int getChildrenCount(Object parent) throws UnknownTypeException {
        assert (!(parent instanceof Watch));
        if (parent == "Root") {
            if (this.debugger != null) {
                return WatchModel.watchBag().watchesFor(this.debugger).length;
            }
            return WatchModel.manager().getWatches().length;
        }
        if (parent instanceof Variable) {
            Variable v = (Variable)parent;
            return v.getNumChild();
        }
        throw new UnknownTypeException(parent);
    }

    @Override
    public boolean isLeaf(Object node) throws UnknownTypeException {
        assert (!(node instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        return super.isLeaf(node);
    }

    @Override
    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        assert (!(node instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        if (node instanceof EmptyWatch) {
            return "<_html><font color=\"#808080\">&lt;" + Catalog.get("CTL_WatchesModel_Empty_Watch_Hint") + "&gt;</font></html>";
        }
        if (node instanceof Watch) {
            return ((Watch)node).getExpression();
        }
        return super.getDisplayName(original, node);
    }

    @Override
    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof WatchVariable) {
            WatchVariable w = (WatchVariable)node;
            if (w.getVariableName().startsWith("`")) {
                if (w.isPtr()) {
                    return ICON_WATCH2_PTR;
                }
                return ICON_WATCH2;
            }
            if (w.isPtr()) {
                return ICON_WATCH1_PTR;
            }
            return ICON_WATCH1;
        }
        if (node instanceof Watch) {
            Watch w = (Watch)node;
            if (w.getExpression().startsWith("`")) {
                return ICON_WATCH2;
            }
            return ICON_WATCH1;
        }
        return super.getIconBase(original, node);
    }

    @Override
    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        NativeWatch w;
        assert (!(node instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        String sd = super.getShortDescription(original, node);
        if (Log.Variable.tipdebug && node instanceof NativeWatch && (w = (NativeWatch)node).watch() == null) {
            sd = sd + "<html><code><hr><b>expr</b>" + w.getExpression() + "<br>" + "<b>scope</b>" + w.getScope() + "<br>" + "<b>restricted</b>" + w.isRestricted() + "<br>" + "</code>" + "</html>";
        }
        return sd;
    }

    @Override
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        assert (!(node instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        return super.getValueAt(node, columnID);
    }

    @Override
    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        assert (!(node instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        return super.isReadOnly(node, columnID);
    }

    @Override
    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        assert (!(node instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        super.setValueAt(node, columnID, value);
    }

    @Override
    public synchronized boolean isExpanded(Object node) throws UnknownTypeException {
        assert (!(node instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        return super.isExpanded(node);
    }

    @Override
    public synchronized void nodeCollapsed(Object node) {
        assert (!(node instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        super.nodeCollapsed(node);
    }

    @Override
    public synchronized void nodeExpanded(Object node) {
        assert (!(node instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        super.nodeExpanded(node);
    }

    public void performDefaultAction(Object o) throws UnknownTypeException {
        assert (!(o instanceof Watch));
        if (o instanceof EmptyWatch) {
            NEW_WATCH_ACTION.actionPerformed(null);
        } else if (o instanceof VariableModel.ShowMoreMessage) {
            ((VariableModel.ShowMoreMessage)o).getMore();
        }
    }

    public Action[] getActions(Object o) throws UnknownTypeException {
        assert (!(o instanceof NativeWatch)) : "WatchModel.get*(): got a NativeWatch";
        EngineDescriptor desp = this.debugger.getNDI().getEngineDescriptor();
        boolean canDoMaxObject = desp.hasCapability(EngineCapability.MAX_OBJECT);
        boolean canDoDy = desp.hasCapability(EngineCapability.DYNAMIC_TYPE);
        boolean canDoIn = desp.hasCapability(EngineCapability.INHERITED_MEMBERS);
        boolean canDoSt = desp.hasCapability(EngineCapability.STATIC_MEMBERS);
        boolean canDoPP = desp.hasCapability(EngineCapability.PRETTY_PRINT);
        if (o == "Root") {
            return new Action[]{NEW_WATCH_ACTION, null, new DeleteAllAction(), null, canDoIn ? Action_INHERITED_MEMBERS : null, canDoDy ? Action_DYNAMIC_TYPE : null, canDoSt ? Action_STATIC_MEMBERS : null, canDoPP ? Action_PRETTY_PRINT : null, null, canDoMaxObject ? (MaxObjectAction)SystemAction.get(MaxObjectAction.class) : null, null};
        }
        if (o instanceof Watch) {
            return new Action[]{NEW_WATCH_ACTION, null, DELETE_ACTION, new DeleteAllAction(), null, canDoIn ? Action_INHERITED_MEMBERS : null, canDoDy ? Action_DYNAMIC_TYPE : null, canDoSt ? Action_STATIC_MEMBERS : null, canDoPP ? Action_PRETTY_PRINT : null, null, canDoMaxObject ? (MaxObjectAction)SystemAction.get(MaxObjectAction.class) : null, null};
        }
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            return v.getActions(true);
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        if (super.addModelListenerHelp(l) && this.debugger != null) {
            this.debugger.registerWatchModel(this);
        }
    }

    public void removeModelListener(ModelListener l) {
        if (super.removeModelListenerHelp(l) && this.debugger != null) {
            this.debugger.registerWatchModel(null);
        }
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        NEW_WATCH_ACTION = new AbstractAction(Catalog.get("ACT_WATCH_NewWatch")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                if (engine != null) {
                    engine.getActionsManager().doAction(ActionsManager.ACTION_NEW_WATCH);
                }
            }
        };
    }

    static class EmptyWatch {
        EmptyWatch() {
        }

        public void setExpression(String expr) {
            String infoStr = Catalog.get("CTL_WatchesModel_Empty_Watch_Hint");
            infoStr = "<" + infoStr + ">";
            if (expr == null || expr.trim().length() == 0 || infoStr.equals(expr)) {
                return;
            }
            NativeDebuggerManager.get().createWatch(expr.trim());
        }
    }

    public static class DeleteAllAction
    extends AbstractAction {
        public DeleteAllAction() {
            super(Catalog.get("ACT_WATCH_DeleteAll"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WatchModel.watchBag().postDeleteAllWatches();
        }

        @Override
        public boolean isEnabled() {
            NativeWatch[] watches = WatchModel.watchBag().getWatches();
            return watches.length > 0;
        }
    }
}

