/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.picklist.DefaultPicklistModel;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.debugger.common2.APIAccessor;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.AttachPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.ExecutableProjectPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineCapability;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHostList;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.HostListEditor;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListEvent;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListListener;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class DebugCorePanel
extends JPanel {
    private JButton actionButton = null;
    private String autoString = null;
    private boolean readonly;
    private boolean noproject;
    private static Project lastSelectedProject = null;
    private static EngineType lastSelectedEngine = null;
    private static String lastSelectedCorefile = null;
    private static final DefaultPicklistModel executablePickList = new DefaultPicklistModel(6);
    private static final DefaultPicklistModel corefilePickList = new DefaultPicklistModel(6);
    private final RequestProcessor RP = new RequestProcessor();
    private volatile ValidationWorkerCheckState currentState = new ValidationWorkerCheckState(Boolean.TRUE, new ValidationResult(Boolean.FALSE, "DebugCorePanel.Validating", false));
    private final ValidationWorker validationWorker = new ValidationWorker();
    static final int VALIDATION_DELAY = 300;
    private final AtomicBoolean coreFileBrowseDialogInvoked = new AtomicBoolean(false);
    private final AtomicBoolean execFileBrowseDialogInvoked = new AtomicBoolean(false);
    private JButton corefileBrowseButton;
    private JLabel corefileLabel;
    private JComboBox corefileComboBox;
    private JLabel errorLabel;
    private JButton executableBrowseButton;
    private JComboBox executableComboBox;
    private JLabel executableLabel;
    private JPanel fill;
    private JTextArea guidanceTextArea;
    private JComboBox projectComboBox;
    private JLabel projectLabel;
    private JComboBox engineComboBox;
    private JLabel engineLabel;
    private static String lastHostChoice;
    private JComboBox hostComboBox;
    private JLabel hostLabel;
    private JButton hostsButton;
    private ResourceBundle bundle;

    public DebugCorePanel(String corePath, JButton actionButton, boolean readonly, String host) {
        this.actionButton = actionButton;
        this.readonly = readonly;
        this.initialize(corePath, host);
    }

    private void initialize(String corePath, String host) {
        ServerRecord defaultHost;
        this.initComponents();
        if (this.readonly) {
            this.corefileComboBox.setEditable(false);
            this.corefileBrowseButton.setEnabled(false);
            this.guidanceTextArea.setText(Catalog.get("LOADCORE_GUIDANCETEXT2"));
            Catalog.setAccessibleDescription(this.guidanceTextArea, "LOADCORE_GUIDANCETEXT2");
        }
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        if (corePath == null) {
            corePath = lastSelectedCorefile;
        } else {
            corefilePickList.addElement(corePath);
        }
        this.corefileComboBox.getEditor().setItem(corePath);
        this.initGui();
        this.guidanceTextArea.setBackground(this.getBackground());
        this.setPreferredSize(new Dimension(700, (int)this.getPreferredSize().getHeight()));
        this.corefileComboBox.setModel(new DefaultComboBoxModel<String>(corefilePickList.getElementsDisplayName()));
        ((JTextField)this.corefileComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.validationWorker);
        this.executableComboBox.setModel(new DefaultComboBoxModel<String>(executablePickList.getElementsDisplayName()));
        ((JTextField)this.executableComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.validationWorker);
        if (lastHostChoice == null && (defaultHost = ServerList.getDefaultRecord()) != null) {
            lastHostChoice = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)defaultHost.getExecutionEnvironment());
        }
        this.initRemoteHost();
        this.initEngine();
        this.adjustAutoCore();
        this.projectComboBox.addItemListener(this.validationWorker);
        this.validationWorker.actionPerformed(null);
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                lastSelectedProject = DebugCorePanel.this.getSelectedProject();
                lastSelectedEngine = DebugCorePanel.this.getEngine();
                lastSelectedCorefile = DebugCorePanel.this.getCorefilePath();
                lastHostChoice = DebugCorePanel.this.getHostName();
                executablePickList.addElement(DebugCorePanel.this.getExecutablePath());
                corefilePickList.addElement(DebugCorePanel.this.getCorefilePath());
            }
        });
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.validationWorker.shutdownExecutor();
    }

    public EngineType getEngine() {
        Object selected = this.engineComboBox.getSelectedItem();
        Collection<EngineType> engineTypes = EngineTypeManager.getEngineTypes(false);
        for (EngineType engineType : engineTypes) {
            if (!engineType.getDisplayName().equals(selected)) continue;
            return engineType;
        }
        assert (false) : "selected object doesn't have associated engine type " + selected;
        return null;
    }

    private int lookupAutoEntry() {
        int count = this.executableComboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!((String)this.executableComboBox.getItemAt(i)).equals(Catalog.get("AutoCoreExe"))) continue;
            return i;
        }
        return -1;
    }

    private void adjustAutoCore() {
        String exec = this.getExecutablePath();
        EngineDescriptor descriptor = new EngineDescriptor(this.getEngine());
        if (!descriptor.hasCapability(EngineCapability.DERIVE_EXECUTABLE)) {
            this.autoString = null;
            int i = this.lookupAutoEntry();
            if (this.executableComboBox.getItemCount() > 0 && i != -1) {
                this.executableComboBox.removeItemAt(i);
            }
            if (exec.equals(Catalog.get("AutoCoreExe"))) {
                exec = "";
            }
        } else {
            this.autoString = Catalog.get("AutoCoreExe");
            int i = this.lookupAutoEntry();
            if (i == -1) {
                this.executableComboBox.addItem(Catalog.get("AutoCoreExe"));
            }
            if (exec.isEmpty()) {
                exec = this.autoString;
            }
        }
        this.setExecutable(exec);
    }

    private void setExecutable(String exec) {
        ((JTextField)this.executableComboBox.getEditor().getEditorComponent()).setText(exec);
    }

    private void initEngine() {
        ActionListener engineComboBoxActionListener = this.engineComboBox.getActionListeners()[0];
        this.engineComboBox.removeActionListener(engineComboBoxActionListener);
        this.engineComboBox.removeAllItems();
        Collection<EngineType> engineTypes = EngineTypeManager.getEngineTypes(false);
        for (EngineType engineType : engineTypes) {
            this.engineComboBox.addItem(engineType.getDisplayName());
            if (!engineType.equals(lastSelectedEngine)) continue;
            this.engineComboBox.setSelectedItem(engineType.getDisplayName());
        }
        this.engineComboBox.addActionListener(engineComboBoxActionListener);
    }

    private void initRemoteHost() {
        CustomizableHostList hostlist;
        this.updateRemoteHostList();
        if (NativeDebuggerManager.isStandalone() && (hostlist = NativeDebuggerManager.get().getHostList()) != null) {
            hostlist.addRecordListListener(new RecordListListener(){

                @Override
                public void contentsChanged(RecordListEvent e) {
                    if (e.getHostName() != null) {
                        lastHostChoice = e.getHostName();
                    }
                    DebugCorePanel.this.updateRemoteHostList();
                }
            });
        }
        this.hostComboBox.addActionListener(this.validationWorker);
    }

    private void updateRemoteHostList() {
        AttachPanel.fillHostsCombo(this.hostComboBox);
        AttachPanel.setHostChoice(lastHostChoice, this.hostComboBox);
    }

    public String getCorefilePath() {
        return ((JTextField)this.corefileComboBox.getEditor().getEditorComponent()).getText();
    }

    public String getHostName() {
        return this.hostComboBox.getSelectedItem().toString();
    }

    public String getExecutablePath() {
        return ((JTextField)this.executableComboBox.getEditor().getEditorComponent()).getText();
    }

    private void initComponents() {
        Catalog.setAccessibleDescription(this, "ACSD_DebugCoreFile");
        this.guidanceTextArea = new JTextArea();
        this.corefileLabel = new JLabel();
        this.corefileComboBox = new JComboBox();
        this.corefileBrowseButton = new JButton();
        this.executableLabel = new JLabel();
        this.executableComboBox = new JComboBox();
        this.executableBrowseButton = new JButton();
        this.projectLabel = new JLabel();
        this.projectComboBox = new JComboBox();
        this.engineLabel = new JLabel();
        this.engineComboBox = new JComboBox();
        this.hostComboBox = new JComboBox();
        this.hostLabel = new JLabel();
        this.hostsButton = new JButton();
        this.fill = new JPanel();
        this.errorLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        int gridy = 0;
        Catalog.setAccessibleName(this.guidanceTextArea, "ACSN_Guidance");
        this.guidanceTextArea.setEditable(false);
        this.guidanceTextArea.setLineWrap(true);
        this.guidanceTextArea.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("LOADCORE_GUIDANCETEXT1"));
        Catalog.setAccessibleDescription(this.guidanceTextArea, "LOADCORE_GUIDANCETEXT1");
        this.guidanceTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.guidanceTextArea, gridBagConstraints);
        this.hostLabel.setText(Catalog.get("HOST_LBL"));
        this.hostLabel.setLabelFor(this.hostComboBox);
        this.hostLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Host"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 13, 8, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.hostComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.add((Component)this.hostComboBox, gridBagConstraints);
        if (!NativeDebuggerManager.isStandalone()) {
            this.hostsButton.setEnabled(false);
        }
        this.hostsButton.setText(Catalog.get("TITLE_Hosts"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 12);
        this.add((Component)this.hostsButton, gridBagConstraints);
        this.hostsButton.setMnemonic(Catalog.getMnemonic("MNEM_Hosts"));
        Catalog.setAccessibleDescription(this.hostsButton, "ACSD_EditHosts");
        this.hostsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCorePanel.this.hostsButtonActionPerformed(evt);
            }
        });
        this.engineLabel.setLabelFor(this.engineComboBox);
        this.engineLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Engine"));
        Catalog.setAccessibleDescription(this.engineComboBox, "ACSD_Engine");
        this.engineLabel.setText(Catalog.get("ASSOCIATED_ENGINE_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 8, 0);
        this.add((Component)this.engineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 6, 12);
        this.add((Component)this.engineComboBox, gridBagConstraints);
        this.engineComboBox.addActionListener(this.validationWorker);
        this.corefileLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("LOADCORE_COREFILE_MN").charAt(0));
        this.corefileLabel.setLabelFor(this.corefileComboBox);
        this.corefileLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("LOADCORE_COREFILE_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 8, 0);
        this.add((Component)this.corefileLabel, gridBagConstraints);
        Catalog.setAccessibleDescription(this.corefileComboBox, "ACSD_Corefile");
        this.corefileComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.add((Component)this.corefileComboBox, gridBagConstraints);
        Catalog.setAccessibleDescription(this.corefileBrowseButton, "ACSD_CorefileBrowse");
        this.corefileBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("LOADCORE_COREFILEBROWSE_BUTTON_MN").charAt(0));
        this.corefileBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("BROWSE_BUTTON_TXT"));
        this.corefileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCorePanel.this.corefileBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 12);
        this.add((Component)this.corefileBrowseButton, gridBagConstraints);
        this.executableLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("EXECUTABLE_MN").charAt(0));
        this.executableLabel.setLabelFor(this.executableComboBox);
        this.executableLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("EXECUTABLE_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 13, 8, 0);
        this.add((Component)this.executableLabel, gridBagConstraints);
        this.executableComboBox.setEditable(true);
        this.executableComboBox.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("ProgramPathname"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.add((Component)this.executableComboBox, gridBagConstraints);
        Catalog.setAccessibleDescription(this.executableBrowseButton, "ACSD_ExecutableBrowse");
        this.executableBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("EXECUTABLEBROWSE_BUTTON_MN").charAt(0));
        this.executableBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("BROWSE_BUTTON_TXT"));
        this.executableBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCorePanel.this.executableBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 12);
        this.add((Component)this.executableBrowseButton, gridBagConstraints);
        this.projectLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("ASSOCIATED_PROJECT_MN").charAt(0));
        this.projectLabel.setLabelFor(this.projectComboBox);
        Catalog.setAccessibleDescription(this.projectComboBox, "ACSD_Project");
        this.projectLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("ASSOCIATED_PROJECT_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        if (!NativeDebuggerManager.isStandalone() && !NativeDebuggerManager.isPL()) {
            this.add((Component)this.projectLabel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 6, 12);
        if (!NativeDebuggerManager.isStandalone() && !NativeDebuggerManager.isPL()) {
            this.add((Component)this.projectComboBox, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fill, gridBagConstraints);
        this.errorLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.errorLabel, gridBagConstraints);
    }

    private void executableBrowseButtonActionPerformed(ActionEvent evt) {
        if (this.execFileBrowseDialogInvoked.getAndSet(true)) {
            return;
        }
        this.validationWorker.cancel();
        final String hostname = (String)this.hostComboBox.getSelectedItem();
        String startFolder = this.getExecutablePath();
        if (startFolder.isEmpty() && (startFolder = this.getCorefilePath()).isEmpty()) {
            startFolder = System.getProperty("user.home");
        }
        if (startFolder.equals(this.autoString)) {
            startFolder = this.getCorefilePath();
        }
        final String startF = startFolder;
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                Host host = Host.byName(hostname);
                ExecutionEnvironment exEnv = host.executionEnvironment();
                if (!ConnectionManager.getInstance().connect(exEnv)) {
                    return;
                }
                FileChooserBuilder fcb = new FileChooserBuilder(exEnv);
                FileChooserBuilder.JFileChooserEx fileChooser = fcb.createFileChooser(startF);
                fileChooser.setDialogTitle(DebugCorePanel.this.getString("SelectExecutable"));
                fileChooser.setApproveButtonText(DebugCorePanel.this.getString("CHOOSER_BUTTON"));
                fileChooser.setFileSelectionMode(0);
                fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getElfExecutableFileFilter());
                SwingUtilities.invokeLater(new Runnable((JFileChooser)fileChooser){
                    final /* synthetic */ JFileChooser val$fileChooser;
                    {
                        this.val$fileChooser = jFileChooser;
                    }

                    @Override
                    public void run() {
                        int ret = this.val$fileChooser.showOpenDialog(DebugCorePanel.this);
                        DebugCorePanel.this.execFileBrowseDialogInvoked.set(false);
                        if (ret == 1) {
                            return;
                        }
                        ((JTextField)DebugCorePanel.this.executableComboBox.getEditor().getEditorComponent()).setText(this.val$fileChooser.getSelectedFile().getPath());
                    }
                });
            }
        });
    }

    private void hostsButtonActionPerformed(ActionEvent evt) {
        HostListEditor editor = new HostListEditor();
        editor.showDialog(this);
    }

    private void corefileBrowseButtonActionPerformed(ActionEvent evt) {
        if (this.coreFileBrowseDialogInvoked.getAndSet(true)) {
            return;
        }
        this.validationWorker.cancel();
        final String hostname = (String)this.hostComboBox.getSelectedItem();
        String startFolder = this.getCorefilePath();
        if (startFolder.isEmpty()) {
            startFolder = System.getProperty("user.home");
        }
        final String startF = startFolder;
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                Host host = Host.byName(hostname);
                ExecutionEnvironment exEnv = host.executionEnvironment();
                if (!ConnectionManager.getInstance().connect(exEnv)) {
                    return;
                }
                FileChooserBuilder fcb = new FileChooserBuilder(exEnv);
                FileChooserBuilder.JFileChooserEx fileChooser = fcb.createFileChooser(startF);
                fileChooser.setDialogTitle(DebugCorePanel.this.getString("CorefileChooser"));
                fileChooser.setApproveButtonText(DebugCorePanel.this.getString("CHOOSER_BUTTON"));
                fileChooser.setFileSelectionMode(0);
                fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getCoreFileFilter());
                SwingUtilities.invokeLater(new Runnable((JFileChooser)fileChooser){
                    final /* synthetic */ JFileChooser val$fileChooser;
                    {
                        this.val$fileChooser = jFileChooser;
                    }

                    @Override
                    public void run() {
                        int ret = this.val$fileChooser.showOpenDialog(DebugCorePanel.this);
                        DebugCorePanel.this.coreFileBrowseDialogInvoked.set(false);
                        if (ret == 1) {
                            return;
                        }
                        DebugCorePanel.this.corefileComboBox.getEditor().setItem(this.val$fileChooser.getSelectedFile().getPath());
                    }
                });
            }
        });
    }

    private void initGui() {
        this.projectComboBox.removeAllItems();
        this.projectComboBox.addItem(this.getString("NO_PROJECT"));
        this.projectComboBox.addItem(this.getString("NEW_PROJECT"));
        ExecutableProjectPanel.fillProjectsCombo(this.projectComboBox, lastSelectedProject);
    }

    private ValidationResult validateCorefilePath(String corePath) {
        if ((corePath = corePath.trim()).length() == 0) {
            return new ValidationResult(Boolean.FALSE, "ERROR_CORE_NOT_SPECIFIED", true);
        }
        Host host = Host.byName(this.getHostName());
        ExecutionEnvironment exEnv = host.executionEnvironment();
        try {
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)exEnv, (String)corePath)) {
                return new ValidationResult(Boolean.FALSE, "ERROR_CORE_DONTEXIST", true);
            }
        }
        catch (Exception e) {
            return new ValidationResult(Boolean.FALSE, "ERROR_CORE_DONTEXIST", true);
        }
        if (exEnv.isLocal()) {
            File coreFile = new File(corePath);
            if (coreFile.isDirectory()) {
                return new ValidationResult(Boolean.FALSE, "ERROR_NOTACOREFILE", true);
            }
            FileObject fo = FileUtil.toFileObject((File)coreFile);
            if (fo == null) {
                return new ValidationResult(Boolean.FALSE, "ERROR_CORE_DONTEXIST", true);
            }
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (Exception e) {
                return new ValidationResult(Boolean.FALSE, "ERROR_CORE_DONTEXIST", true);
            }
            if (!"application/x-core+elf".equals(IpeUtils.getMime(dataObject))) {
                return new ValidationResult(Boolean.FALSE, "ERROR_NOTACOREFILE", true);
            }
        }
        return new ValidationResult(Boolean.TRUE, null, false);
    }

    private ValidationResult validateExecutablePath(String exePath) {
        if ((exePath = exePath.trim()).equals(this.autoString)) {
            return new ValidationResult(Boolean.TRUE, null, false);
        }
        Host host = Host.byName(this.getHostName());
        ExecutionEnvironment exEnv = host.executionEnvironment();
        try {
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)exEnv, (String)exePath)) {
                EngineDescriptor descriptor = new EngineDescriptor(this.getEngine());
                if (descriptor.hasCapability(EngineCapability.DERIVE_EXECUTABLE)) {
                    return new ValidationResult(Boolean.FALSE, "ERROR_DONTEXIST", true);
                }
                return new ValidationResult(Boolean.FALSE, "DBG_ERROR_DONTEXIST", false);
            }
        }
        catch (Exception e) {
            return new ValidationResult(Boolean.FALSE, null, false);
        }
        if (exEnv.isLocal()) {
            File exeFile = new File(exePath);
            if (exeFile.isDirectory()) {
                return new ValidationResult(Boolean.FALSE, "ERROR_NOTAEXEFILE", true);
            }
            FileObject fo = FileUtil.toFileObject((File)exeFile);
            if (fo == null) {
                return new ValidationResult(Boolean.FALSE, "ERROR_NOTAEXEFILE", true);
            }
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (Exception e) {
                return new ValidationResult(Boolean.FALSE, "ERROR_DONTEXIST", true);
            }
            if (!MIMENames.isBinary((String)IpeUtils.getMime(dataObject))) {
                return new ValidationResult(Boolean.FALSE, "ERROR_NOTAEXEFILE", true);
            }
        }
        return new ValidationResult(Boolean.TRUE, null, false);
    }

    private boolean matchProject(String executable) {
        if (executable.equals(this.autoString)) {
            this.projectComboBox.setSelectedIndex(0);
            return true;
        }
        this.projectComboBox.setEnabled(true);
        for (int i = 0; i < this.projectComboBox.getItemCount(); ++i) {
            if (!executable.equalsIgnoreCase(this.projectComboBox.getItemAt(i).toString())) continue;
            this.projectComboBox.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    private boolean matchExecutable(Project p) {
        if (p == null) {
            this.adjustAutoCore();
            return true;
        }
        ProjectInformation pi = ProjectUtils.getInformation((Project)p);
        String displayName = pi.getDisplayName();
        if (displayName != null && !displayName.trim().isEmpty()) {
            for (int i = 0; i < this.executableComboBox.getItemCount(); ++i) {
                if (!displayName.equalsIgnoreCase(CndPathUtilities.getBaseName((String)this.executableComboBox.getItemAt(i).toString()))) continue;
                this.executableComboBox.setSelectedIndex(i);
                return true;
            }
        }
        return false;
    }

    private void setError() {
        ValidationResult validationResult = this.currentState.validationResult;
        if (validationResult.isValid.booleanValue()) {
            this.clearError();
            return;
        }
        this.setError(validationResult.msgError, validationResult.disable);
    }

    private void setError(String errorMsg, boolean disable) {
        this.errorLabel.setText(this.getString(errorMsg));
        if (disable) {
            this.projectComboBox.setEnabled(false);
        }
        this.actionButton.setEnabled(false);
    }

    private void clearError() {
        this.errorLabel.setText(" ");
        this.projectComboBox.setEnabled(true);
        this.actionButton.setEnabled(true);
    }

    public Project getSelectedProject() {
        Object selectedItem = this.projectComboBox.getSelectedItem();
        if (selectedItem instanceof ExecutableProjectPanel.ProjectCBItem) {
            this.noproject = false;
            return ((ExecutableProjectPanel.ProjectCBItem)selectedItem).getProject();
        }
        this.noproject = this.projectComboBox.getSelectedIndex() == 0;
        return null;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(DebugCorePanel.class);
        }
        try {
            return this.bundle.getString(s);
        }
        catch (Exception e) {
            return s;
        }
    }

    public boolean asynchronous() {
        return false;
    }

    public boolean getNoProject() {
        return this.noproject;
    }

    private final class ValidationWorker
    extends AttachPanel.AnyChangeDocumentListener
    implements Runnable,
    ActionListener,
    ItemListener {
        private final Object validationExecutorLock = new Object();
        private final ScheduledExecutorService validationExecutor = Executors.newScheduledThreadPool(1);
        private ScheduledFuture<?> validationTask;
        private long lastEventID = 0L;
        private ValidationWorkerCheckState lastCheck = null;
        private ValidationParams validationParams;

        ValidationWorker() {
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                ValidationResult validationResult;
                ValidationWorkerCheckState curStatus = this.lastCheck;
                DebugCorePanel.this.currentState = curStatus;
                ValidationResult validationResult2 = validationResult = curStatus == null ? null : curStatus.validationResult;
                if (curStatus == null || curStatus.checking == null) {
                    validationResult = validationResult == null ? new ValidationResult(Boolean.TRUE, "DebugCorePanel.Validating", true) : new ValidationResult(Boolean.TRUE, validationResult.msgError, validationResult.disable);
                    DebugCorePanel.this.currentState = new ValidationWorkerCheckState(null, validationResult);
                }
                DebugCorePanel.this.setError();
            } else {
                this.recalculateValidationParams();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ValidationResult result = this.validate();
                if (Thread.interrupted()) {
                    return;
                }
                this.lastCheck = new ValidationWorkerCheckState(result.isValid != false ? null : Boolean.FALSE, result);
                SwingUtilities.invokeLater(this);
            }
        }

        private void recalculateValidationParams() {
        }

        public ValidationResult validate() {
            MakeConfiguration conf;
            if (this.validationParams.eventID < this.lastEventID) {
                return new ValidationResult(Boolean.FALSE, null, false);
            }
            String hostName = this.validationParams.hostName;
            String corePath = this.validationParams.corePath;
            String execPath = this.validationParams.execPath;
            Project project = this.validationParams.project;
            if (Thread.interrupted()) {
                return new ValidationResult(Boolean.FALSE, null, false);
            }
            if (!APIAccessor.get().syncValidate(hostName)) {
                return new ValidationResult(Boolean.FALSE, "DebugCorePanel.HOST_IS_NOT_VALID", true);
            }
            if (Thread.interrupted()) {
                return new ValidationResult(Boolean.FALSE, null, false);
            }
            ValidationResult coreFileValidationResult = DebugCorePanel.this.validateCorefilePath(corePath);
            if (!coreFileValidationResult.isValid.booleanValue()) {
                return coreFileValidationResult;
            }
            if (Thread.interrupted()) {
                return new ValidationResult(Boolean.FALSE, null, false);
            }
            ValidationResult execPathValidationResult = DebugCorePanel.this.validateExecutablePath(execPath);
            if (!execPathValidationResult.isValid.booleanValue()) {
                return execPathValidationResult;
            }
            if (Thread.interrupted()) {
                return new ValidationResult(Boolean.FALSE, null, false);
            }
            if (project != null && (conf = ConfigurationSupport.getProjectActiveConfiguration((Lookup.Provider)project)) != null) {
                EngineType projectDebuggerType = NativeDebuggerManager.debuggerType((Configuration)conf);
                if (DebugCorePanel.this.getEngine() != projectDebuggerType) {
                    return new ValidationResult(Boolean.FALSE, "ERROR_WRONG_FAMILY", false);
                }
            }
            return new ValidationResult(Boolean.TRUE, null, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleProjectParamsChanges() {
            if (this.validationParams != null) {
                this.validationParams.setRequestID(++this.lastEventID);
            }
            ValidationResult validationResult = new ValidationResult(Boolean.FALSE, "DebugCorePanel.Validating", false);
            DebugCorePanel.this.currentState = new ValidationWorkerCheckState(Boolean.TRUE, validationResult);
            DebugCorePanel.this.setError();
            Object object = this.validationExecutorLock;
            synchronized (object) {
                if (this.validationTask != null) {
                    this.validationTask.cancel(true);
                }
                this.validationTask = this.validationExecutor.schedule(this, 300L, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            Object object = this.validationExecutorLock;
            synchronized (object) {
                if (this.validationTask != null) {
                    this.validationTask.cancel(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdownExecutor() {
            Object object = this.validationExecutorLock;
            synchronized (object) {
                if (this.validationTask != null) {
                    this.validationTask.cancel(true);
                }
                this.validationExecutor.shutdown();
            }
        }

        private void updateValidationParams() {
            this.validationParams = new ValidationParams(DebugCorePanel.this.getHostName(), DebugCorePanel.this.getSelectedProject(), DebugCorePanel.this.getExecutablePath(), DebugCorePanel.this.getCorefilePath());
            this.handleProjectParamsChanges();
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                DebugCorePanel.this.matchExecutable(DebugCorePanel.this.getSelectedProject());
                this.updateValidationParams();
            }
        }

        @Override
        protected void documentChanged(DocumentEvent e) {
            String pName = CndPathUtilities.getBaseName((String)DebugCorePanel.this.getExecutablePath());
            DebugCorePanel.this.matchProject(pName);
            this.updateValidationParams();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e != null && e.getSource() == DebugCorePanel.this.engineComboBox) {
                DebugCorePanel.this.adjustAutoCore();
            }
            this.updateValidationParams();
        }
    }

    private static class ValidationResult {
        private Boolean isValid;
        private String msgError;
        private boolean disable;

        ValidationResult(Boolean isValid, String msgError, boolean disable) {
            this.isValid = isValid;
            this.msgError = msgError;
            this.disable = disable;
        }
    }

    private static final class ValidationWorkerCheckState {
        private final Boolean checking;
        private final ValidationResult validationResult;

        private ValidationWorkerCheckState(Boolean checking, ValidationResult validationResult) {
            this.checking = checking;
            this.validationResult = validationResult;
        }
    }

    private static final class ValidationParams {
        private String hostName;
        private final Project project;
        private final String corePath;
        private final String execPath;
        private long eventID;

        ValidationParams(String hostName, Project project, String execPath, String corePath) {
            this.hostName = hostName;
            this.project = project;
            this.execPath = execPath;
            this.corePath = corePath;
        }

        void setRequestID(long eventID) {
            this.eventID = eventID;
        }
    }
}

