/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.debugger.common2.utils.Catalog;
import org.netbeans.modules.cnd.debugger.common2.utils.Log;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class PhasedProgress
implements ActionListener {
    private final Dialog dialog;
    private final PhasedProgressPanel ppp;
    private CancelListener cancelListener;
    private final int cols;
    private String cancelMsg;
    private boolean cancelled = false;

    public PhasedProgress(String title, String[] levelLabels, CancelListener cancelListener, int cols) {
        this.cancelListener = cancelListener;
        this.cols = cols;
        this.ppp = new PhasedProgressPanel(levelLabels);
        boolean modal = false;
        DialogDescriptor dlg = new DialogDescriptor((Object)this.ppp, title, modal, new Object[]{DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.CANCEL_OPTION, 0, null, (ActionListener)this);
        dlg.setMessageType(1);
        dlg.setClosingOptions(new Object[0]);
        this.dialog = DialogDisplayer.getDefault().createDialog(dlg);
        Catalog.setAccessibleDescription(this.dialog, "ACSD_Progress");
        if (this.dialog instanceof JDialog) {
            ((JDialog)this.dialog).setDefaultCloseOperation(0);
        }
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PhasedProgress.this.cancel();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == DialogDescriptor.CANCEL_OPTION) {
            this.cancel();
        }
    }

    private void passCancelOn() {
        if (this.cancelListener != null) {
            if (Log.Progress.debug) {
                System.out.printf("PhasedProgress.passCancelOn(): doing it\n", new Object[0]);
            }
            this.cancelListener.cancelled();
        } else if (Log.Progress.debug) {
            System.out.printf("PhasedProgress.passCancelOn(): no listnr\n", new Object[0]);
        }
    }

    private void cancel() {
        if (Log.Progress.debug) {
            System.out.printf("PhasedProgress.cancel()\n", new Object[0]);
        }
        this.cancelled = true;
        this.ppp.setCancelMsg(this.cancelMsg);
        this.passCancelOn();
    }

    public void setCancelMsg(String cancelMsg) {
        this.cancelMsg = cancelMsg;
        if (this.cancelled) {
            this.ppp.setCancelMsg(cancelMsg);
        }
    }

    public void setMessageFor(int level, String message, int total) {
        this.ppp.setMessageFor(level, message, total);
        this.paintImmediately();
    }

    public void setProgressFor(int level, int count) {
        this.ppp.setProgressFor(level, count);
        this.paintImmediately();
    }

    public void setCancelListener(CancelListener newCancelListener) {
        if (Log.Progress.debug) {
            System.out.printf("PhasedProgress.setCancelListener(%s)\n", newCancelListener);
        }
        boolean setting = false;
        if (this.cancelListener == null) {
            setting = true;
        }
        this.cancelListener = newCancelListener;
        if (setting && this.isCancelled()) {
            this.passCancelOn();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void paintImmediately() {
        if (this.dialog instanceof JDialog) {
            JDialog jdialog = (JDialog)this.dialog;
            JRootPane rootPane = jdialog.getRootPane();
            Rectangle rect = new Rectangle();
            rootPane.getBounds(rect);
            rect.x = 0;
            rect.y = 0;
            rootPane.paintImmediately(rect);
        }
    }

    public void setVisible(boolean v) {
        this.dialog.setVisible(v);
        if (v) {
            this.paintImmediately();
        }
    }

    public void dispose() {
        this.dialog.dispose();
    }

    private class PhasedProgressPanel
    extends JPanel {
        final Color bgColor = (Color)UIManager.getDefaults().get("Label.background");
        private final int nLevels;
        private final String[] levelLabels;
        private JTextArea mainTextArea;
        private PhasePanel[] phasePanel;
        private JTextArea cancelTextArea;

        public PhasedProgressPanel(String[] levelLabels) {
            this.levelLabels = levelLabels;
            this.nLevels = levelLabels.length;
            this.phasePanel = new PhasePanel[this.nLevels];
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            boolean dialogMargin = false;
            int labelSpace = 11;
            int titleSpace = 12;
            int bottomMargin = 12;
            int gridy = 0;
            this.mainTextArea = new JTextArea(this.levelLabels[0], 1, PhasedProgress.this.cols);
            this.mainTextArea.setEditable(false);
            this.mainTextArea.setFocusable(true);
            this.mainTextArea.setLineWrap(true);
            this.mainTextArea.setWrapStyleWord(true);
            this.mainTextArea.setBackground(this.bgColor);
            Catalog.setAccessibleName(this.mainTextArea, "ACSN_ProgressMain");
            Catalog.setAccessibleDescription(this.mainTextArea, "ACSD_ProgressMain");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 12, 0);
            this.add((Component)this.mainTextArea, gbc);
            for (int lx = 1; lx < this.nLevels; ++lx) {
                this.phasePanel[lx] = new PhasePanel(this.levelLabels[lx]);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy++;
                gbc.weightx = 1.0;
                gbc.fill = 1;
                gbc.anchor = 10;
                gbc.insets = new Insets(0, 0, 12, 0);
                this.add((Component)this.phasePanel[lx], gbc);
            }
            this.cancelTextArea = new JTextArea("", 1, PhasedProgress.this.cols);
            this.cancelTextArea.setEditable(false);
            this.cancelTextArea.setFocusable(false);
            this.cancelTextArea.setLineWrap(true);
            this.cancelTextArea.setWrapStyleWord(true);
            this.cancelTextArea.setBackground(this.bgColor);
            this.cancelTextArea.setForeground(Color.RED);
            Catalog.setAccessibleName(this.cancelTextArea, "ACSN_ProgressCancel");
            Catalog.setAccessibleDescription(this.cancelTextArea, "ACSD_ProgressCancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.cancelTextArea, gbc);
        }

        public void setCancelMsg(String cancelMsg) {
            this.cancelTextArea.setText(cancelMsg);
        }

        public void setMessageFor(int level, String message, int total) {
            if (level >= this.nLevels) {
                return;
            }
            if (level == 0) {
                this.mainTextArea.setText(this.levelLabels[0] + message);
            } else {
                this.phasePanel[level].setMessage(message, total);
            }
        }

        public void setProgressFor(int level, int count) {
            if (level <= 0 || level >= this.nLevels) {
                return;
            }
            this.phasePanel[level].setProgress(count);
        }

        private class PhasePanel
        extends JPanel {
            private String label;
            private JTextArea msgTextArea;
            private JProgressBar progressBar;

            public PhasePanel(String label) {
                this.label = label;
                this.initComponents();
            }

            private void initComponents() {
                this.setLayout(new GridBagLayout());
                this.msgTextArea = new JTextArea(this.label, 1, PhasedProgress.this.cols);
                this.msgTextArea.setEditable(false);
                this.msgTextArea.setFocusable(true);
                this.msgTextArea.setLineWrap(false);
                this.msgTextArea.setBackground(PhasedProgressPanel.this.bgColor);
                Catalog.setAccessibleName(this.msgTextArea, "ACSN_ProgressMsg");
                Catalog.setAccessibleDescription(this.msgTextArea, "ACSD_ProgressMsg");
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.anchor = 17;
                this.add((Component)this.msgTextArea, gbc);
                this.progressBar = new JProgressBar();
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.weightx = 1.0;
                gbc.fill = 1;
                gbc.anchor = 10;
                this.add((Component)this.progressBar, gbc);
            }

            public void setMessage(String message, int total) {
                this.msgTextArea.setText(this.label + message);
                if (total == 0) {
                    this.progressBar.setIndeterminate(true);
                } else {
                    this.progressBar.setIndeterminate(false);
                    this.progressBar.setMinimum(0);
                    this.progressBar.setMaximum(total);
                }
            }

            public void setProgress(int count) {
                if (count == this.progressBar.getMaximum()) {
                    count = 0;
                }
                this.progressBar.setValue(count);
            }
        }
    }

    public static interface CancelListener {
        public void cancelled();
    }
}

