/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.reflect.Method;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntimeCPU
extends ProfilerRuntime {
    private static final boolean DEBUG = false;
    private static int nProfiledThreadsLimit;
    protected static int nProfiledThreadsAllowed;
    protected static int stackDepthLimit;
    protected static boolean enableFirstTimeMethodInvoke;
    protected static volatile boolean recursiveInstrumentationDisabled;
    protected static boolean absoluteTimerOn;
    protected static boolean threadCPUTimerOn;
    protected static boolean waitTrackingEnabled;
    protected static boolean sleepTrackingEnabled;
    protected static boolean[] instrMethodInvoked;
    private static boolean javaLangReflectMethodInvokeInterceptEnabled;
    private static Method getRequestedSessionIdMethod;
    private static Method getMethodMethod;
    private static Method getServletPathMethod;

    public static long getAbsTimeStampInCollectedFormat() {
        return Timers.getCurrentTimeInCounts() & 0xFFFFFFFFFFFFFFL;
    }

    public static void setInstrMethodsInvoked(boolean[] methodInvoked) {
        instrMethodInvoked = methodInvoked;
    }

    public static void setJavaLangReflectMethodInvokeInterceptEnabled(boolean v) {
        javaLangReflectMethodInvokeInterceptEnabled = v;
    }

    public static void setNProfiledThreadsLimit(int num) {
        nProfiledThreadsLimit = nProfiledThreadsAllowed = num;
    }

    public static void setStackDepthLimit(int num) {
        stackDepthLimit = num;
    }

    public static void setWaitAndSleepTracking(boolean waitTracking, boolean sleepTracking) {
        waitTrackingEnabled = waitTracking;
        sleepTrackingEnabled = sleepTracking;
    }

    public static void setTimerTypes(boolean absolute, boolean threadCPU) {
        if (threadCPU != threadCPUTimerOn && Platform.isSolaris()) {
            Timers.enableMicrostateAccounting((boolean)threadCPU);
        }
        absoluteTimerOn = absolute;
        threadCPUTimerOn = threadCPU;
    }

    public static void enableFirstTimeMethodInvoke(boolean enabled) {
        enableFirstTimeMethodInvoke = enabled;
    }

    public static void createThreadInfoForCurrentThread() {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        ti.initialize();
        ti.useEventBuffer();
        ti.inCallGraph = false;
    }

    public static void handleJavaLangReflectMethodInvoke(Method method) {
        if (!javaLangReflectMethodInvokeInterceptEnabled) {
            return;
        }
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        externalActionsHandler.handleReflectiveInvoke(method);
        --ti.inProfilingRuntimeMethod;
    }

    public static void handleServletDoMethod(Object request) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized()) {
            System.out.println("No thread for servlet request");
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilerRuntimeCPU.servletDoMethodHook(ti, request);
        --ti.inProfilingRuntimeMethod;
    }

    public static void resetProfilerCollectors() {
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    public static void resumeCurrentThreadTimer() {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        ProfilerRuntimeCPU.writeAdjustTimeEvent(ti, ti.absEntryTime, ti.threadEntryTime);
        --ti.inProfilingRuntimeMethod;
    }

    public static ThreadInfo suspendCurrentThreadTimer() {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return ti;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.absEntryTime = Timers.getCurrentTimeInCounts();
        if (threadCPUTimerOn) {
            ti.threadEntryTime = Timers.getThreadCPUTimeInNanos();
        }
        return ti;
    }

    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    protected static long currentTimeInCounts() {
        return Timers.getCurrentTimeInCounts();
    }

    protected static void enableProfiling(boolean v) {
        recursiveInstrumentationDisabled = !v;
    }

    protected static long monitorEntryCPU(ThreadInfo ti, Object monitor, ThreadInfo ownerTi) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)22, ti, monitor, ownerTi);
        }
        return -1L;
    }

    protected static long monitorExitCPU(ThreadInfo ti, Object monitor) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)23, ti, monitor);
        }
        return -1L;
    }

    protected static long sleepEntryCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !sleepTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)24, ti);
        }
        return -1L;
    }

    protected static long sleepExitCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !sleepTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)25, ti);
        }
        return -1L;
    }

    protected static long waitEntryCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)20, ti);
        }
        return -1L;
    }

    protected static long waitExitCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)21, ti);
        }
        return -1L;
    }

    protected static long parkEntryCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)26, ti);
        }
        return -1L;
    }

    protected static long parkExitCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)27, ti);
        }
        return -1L;
    }

    protected static void firstTimeMethodInvoke(ThreadInfo ti, char methodId) {
        if (enableFirstTimeMethodInvoke) {
            long absTimeStamp = Timers.getCurrentTimeInCounts();
            long threadTimeStamp = threadCPUTimerOn ? Timers.getThreadCPUTimeInNanos() : 0L;
            externalActionsHandler.handleFirstTimeMethodInvoke(methodId);
            ProfilerRuntimeCPU.writeAdjustTimeEvent(ti, absTimeStamp, threadTimeStamp);
        }
    }

    static void writeServletDoMethod(ThreadInfo ti, String method, String servletPath, String sessionId) {
        int curPos = ti.evBufPos;
        int fullInfoLen = 2 + servletPath.length() * 2 + 4;
        if (curPos + fullInfoLen > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(ti);
            curPos = ti.evBufPos;
        }
        byte[] evBuf = ti.evBuf;
        int methodId = -1;
        int sessionHash = -1;
        if ("GET".equals(method)) {
            methodId = 1;
        } else if ("POST".equals(method)) {
            methodId = 2;
        } else if ("PUT".equals(method)) {
            methodId = 3;
        } else if ("DELETE".equals(method)) {
            methodId = 4;
        }
        if (sessionId != null) {
            sessionHash = sessionId.hashCode();
        }
        evBuf[curPos++] = 30;
        evBuf[curPos++] = methodId;
        byte[] name = servletPath.getBytes();
        int len = name.length;
        evBuf[curPos++] = (byte)(len >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(len & 0xFF);
        System.arraycopy(name, 0, evBuf, curPos, len);
        curPos += len;
        evBuf[curPos++] = (byte)(sessionHash >> 24 & 0xFF);
        evBuf[curPos++] = (byte)(sessionHash >> 16 & 0xFF);
        evBuf[curPos++] = (byte)(sessionHash >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(sessionHash & 0xFF);
        ti.evBufPos = curPos;
    }

    static void writeTimeStampedEvent(byte eventType, ThreadInfo ti, char methodId) {
        int curPos = ti.evBufPos;
        if (curPos > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(ti);
            curPos = ti.evBufPos;
        }
        byte[] evBuf = ti.evBuf;
        if (!ti.isInitialized()) {
            return;
        }
        evBuf[curPos++] = eventType;
        evBuf[curPos++] = (byte)(methodId >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(methodId & 0xFF);
        if (absoluteTimerOn) {
            long absTimeStamp = Timers.getCurrentTimeInCounts();
            evBuf[curPos++] = (byte)(absTimeStamp >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp & 0xFFL);
        }
        if (threadCPUTimerOn) {
            long threadTimeStamp = Timers.getThreadCPUTimeInNanos();
            evBuf[curPos++] = (byte)(threadTimeStamp >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp & 0xFFL);
        }
        ti.evBufPos = curPos;
    }

    static long writeWaitTimeEvent(byte eventType, ThreadInfo ti) {
        return ProfilerRuntimeCPU.writeWaitTimeEvent(eventType, ti, null);
    }

    private static void servletDoMethodHook(ThreadInfo ti, Object request) {
        String servletPath = null;
        String method = null;
        String requestedSessionId = null;
        if (getRequestedSessionIdMethod == null) {
            try {
                Class<?> requestClass = request.getClass();
                getRequestedSessionIdMethod = requestClass.getMethod("getRequestedSessionId", null);
                getMethodMethod = requestClass.getMethod("getMethod", null);
                getServletPathMethod = requestClass.getMethod("getServletPath", null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        try {
            requestedSessionId = (String)getRequestedSessionIdMethod.invoke(request, null);
            method = (String)getMethodMethod.invoke(request, null);
            servletPath = (String)getServletPathMethod.invoke(request, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        ProfilerRuntimeCPU.writeServletDoMethod(ti, method, servletPath, requestedSessionId);
    }

    static {
        stackDepthLimit = Integer.MAX_VALUE;
        recursiveInstrumentationDisabled = false;
        javaLangReflectMethodInvokeInterceptEnabled = false;
    }
}

