/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import org.netbeans.lib.profiler.wireprotocol.Response;

public class ThreadDumpResponse
extends Response {
    private boolean jdk15;
    private Date time;
    Object[] cdThreads;

    public ThreadDumpResponse(boolean j15, Date d, Object[] td) {
        super(true, 14);
        this.jdk15 = j15;
        this.time = d;
        if (td == null) {
            td = new Object[]{};
        }
        this.cdThreads = td;
    }

    ThreadDumpResponse() {
        super(true, 14);
    }

    public boolean isJDK15() {
        return this.jdk15;
    }

    public Date getTime() {
        return this.time;
    }

    public Object[] getThreads() {
        return this.cdThreads;
    }

    void readObject(ObjectInputStream in) throws IOException {
        this.jdk15 = in.readBoolean();
        long t = in.readLong();
        this.time = new Date(t);
        int len = in.readInt();
        this.cdThreads = new Object[len];
        for (int i = 0; i < len; ++i) {
            try {
                this.cdThreads[i] = in.readObject();
                continue;
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        }
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.jdk15);
        out.writeLong(this.time.getTime());
        out.writeInt(this.cdThreads.length);
        for (int i = 0; i < this.cdThreads.length; ++i) {
            out.writeObject(this.cdThreads[i]);
        }
        this.time = null;
        this.cdThreads = null;
    }
}

