/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.debugger.registry.ContextAwareServicePath;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class ActionsProvider {
    private static final RequestProcessor debuggerActionsRP = new RequestProcessor("Debugger Actions", 5);

    public abstract Set getActions();

    public abstract void doAction(Object var1);

    public abstract boolean isEnabled(Object var1);

    public abstract void addActionsProviderListener(ActionsProviderListener var1);

    public abstract void removeActionsProviderListener(ActionsProviderListener var1);

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        debuggerActionsRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ActionsProvider.this.doAction(action);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    static class ContextAware
    extends ActionsProvider
    implements ContextAwareService<ActionsProvider>,
    ContextAwareServicePath {
        private static final String ERROR = "error in getting MIMEType";
        private String path;
        private String serviceName;
        private ContextProvider context;
        private ActionsProvider delegate;
        private Set actions;
        private Set<String> enabledOnMIMETypes;
        private List<ActionsProviderListener> listeners = new ArrayList<ActionsProviderListener>();
        private PropertyChangeListener contextDispatcherListener;

        private ContextAware(String serviceName, Set actions, Set<String> enabledOnMIMETypes) {
            this.serviceName = serviceName;
            this.actions = actions;
            this.enabledOnMIMETypes = enabledOnMIMETypes;
        }

        private ContextAware(String serviceName, Set actions, Set<String> enabledOnMIMETypes, ContextProvider context) {
            this.serviceName = serviceName;
            this.actions = actions;
            this.enabledOnMIMETypes = enabledOnMIMETypes;
            this.context = context;
        }

        private synchronized ActionsProvider getDelegate() {
            if (this.delegate == null) {
                this.delegate = (ActionsProvider)ContextAwareSupport.createInstance(this.serviceName, this.context);
                if (this.delegate == null) {
                    throw new IllegalStateException("No instance created for service " + this.serviceName + ", context = " + this.context + ", path = " + this.path);
                }
                for (ActionsProviderListener l : this.listeners) {
                    this.delegate.addActionsProviderListener(l);
                }
                this.listeners.clear();
                if (this.contextDispatcherListener != null) {
                    this.detachContextDispatcherListener();
                }
            }
            return this.delegate;
        }

        @Override
        public String getServicePath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set getActions() {
            ActionsProvider actionsDelegate;
            if (this.actions != null) {
                ContextAware contextAware = this;
                synchronized (contextAware) {
                    actionsDelegate = this.delegate;
                }
            } else {
                actionsDelegate = this.getDelegate();
            }
            if (actionsDelegate == null) {
                return this.actions;
            }
            return actionsDelegate.getActions();
        }

        @Override
        public void doAction(Object action) {
            this.getDelegate().doAction(action);
        }

        @Override
        public void postAction(Object action, Runnable actionPerformedNotifier) {
            this.getDelegate().postAction(action, actionPerformedNotifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEnabled(Object action) {
            Boolean isEnabledMIME;
            ActionsProvider actionsDelegate;
            if (this.enabledOnMIMETypes != null) {
                ContextAware contextAware = this;
                synchronized (contextAware) {
                    actionsDelegate = this.delegate;
                }
            } else {
                actionsDelegate = this.getDelegate();
            }
            if (actionsDelegate == null && !Boolean.TRUE.equals(isEnabledMIME = ContextAware.isCurrentMIMETypeIn(this.enabledOnMIMETypes))) {
                return false;
            }
            return this.getDelegate().isEnabled(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addActionsProviderListener(ActionsProviderListener l) {
            ActionsProvider actionsDelegate;
            ContextAware contextAware = this;
            synchronized (contextAware) {
                actionsDelegate = this.delegate;
                if (actionsDelegate == null) {
                    this.listeners.add(l);
                    if (this.contextDispatcherListener == null && this.enabledOnMIMETypes != null) {
                        this.contextDispatcherListener = this.attachContextDispatcherListener();
                    }
                    return;
                }
            }
            actionsDelegate.addActionsProviderListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeActionsProviderListener(ActionsProviderListener l) {
            ActionsProvider actionsDelegate;
            ContextAware contextAware = this;
            synchronized (contextAware) {
                actionsDelegate = this.delegate;
                if (actionsDelegate == null) {
                    this.listeners.remove(l);
                    if (this.listeners.isEmpty() && this.contextDispatcherListener != null) {
                        this.detachContextDispatcherListener();
                    }
                    return;
                }
            }
            actionsDelegate.removeActionsProviderListener(l);
        }

        @Override
        public ActionsProvider forContext(ContextProvider context) {
            if (context == this.context) {
                return this;
            }
            ContextAware ca = new ContextAware(this.serviceName, this.actions, this.enabledOnMIMETypes, context);
            ca.path = this.path;
            return ca;
        }

        static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
            String serviceName = (String)attrs.get("serviceName");
            String actionsStr = (String)attrs.get("debugger_actions");
            String enabledOnMIMETypesStr = (String)attrs.get("debugger_activateForMIMETypes");
            String[] actions = ContextAware.parseArray(actionsStr);
            String[] enabledOnMIMETypes = ContextAware.parseArray(enabledOnMIMETypesStr);
            String path = null;
            try {
                Field foField = attrs.getClass().getDeclaredField("fo");
                foField.setAccessible(true);
                FileObject fo = (FileObject)foField.get(attrs);
                path = fo.getPath();
            }
            catch (Exception ex) {
                // empty catch block
            }
            ContextAware ca = new ContextAware(serviceName, ContextAware.createSet(actions), ContextAware.createSet(enabledOnMIMETypes));
            ca.path = path;
            return ca;
        }

        private static String[] parseArray(String strArray) {
            if (strArray == null) {
                return null;
            }
            if (strArray.startsWith("[")) {
                strArray = strArray.substring(1);
            }
            if (strArray.endsWith("]")) {
                strArray = strArray.substring(0, strArray.length() - 1);
            }
            strArray = strArray.trim();
            int index = 0;
            ArrayList<String> strings = new ArrayList<String>();
            while (index < strArray.length()) {
                int index2 = strArray.indexOf(44, index);
                if (index2 < 0) {
                    index2 = strArray.length();
                }
                if (index2 > index) {
                    String s = strArray.substring(index, index2).trim();
                    if (s.length() > 0) {
                        strings.add(s);
                    }
                    index = index2 + 1;
                    continue;
                }
                ++index;
            }
            return strings.toArray(new String[0]);
        }

        private static <T> Set<T> createSet(T[] array) {
            if (array != null) {
                return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(array)));
            }
            return null;
        }

        private static Boolean isCurrentMIMETypeIn(Set<String> mimeTypes) {
            try {
                Class<?> editorContextDispatcherClass = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.netbeans.spi.debugger.ui.EditorContextDispatcher");
                try {
                    try {
                        Object editorContextDispatcher = editorContextDispatcherClass.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
                        Method getMIMETypesOnCurrentLineMethod = editorContextDispatcherClass.getDeclaredMethod("getMIMETypesOnCurrentLine", new Class[0]);
                        getMIMETypesOnCurrentLineMethod.setAccessible(true);
                        Set lineMIMETypes = (Set)getMIMETypesOnCurrentLineMethod.invoke(editorContextDispatcher, new Object[0]);
                        if (!lineMIMETypes.isEmpty()) {
                            return !Collections.disjoint(mimeTypes, lineMIMETypes);
                        }
                        FileObject file = (FileObject)editorContextDispatcherClass.getMethod("getMostRecentFile", new Class[0]).invoke(editorContextDispatcher, new Object[0]);
                        if (file != null) {
                            return mimeTypes.contains(file.getMIMEType());
                        }
                        return null;
                    }
                    catch (IllegalAccessException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                catch (NoSuchMethodException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (SecurityException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }

        private PropertyChangeListener attachContextDispatcherListener() {
            ContextDispatcherListener l = null;
            try {
                Class<?> editorContextDispatcherClass = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.netbeans.spi.debugger.ui.EditorContextDispatcher");
                try {
                    try {
                        Object editorContextDispatcher = editorContextDispatcherClass.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
                        Method m = editorContextDispatcherClass.getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                        l = new ContextDispatcherListener();
                        for (String mimeType : this.enabledOnMIMETypes) {
                            m.invoke(editorContextDispatcher, mimeType, l);
                        }
                    }
                    catch (IllegalAccessException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                catch (NoSuchMethodException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (SecurityException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return l;
        }

        private void detachContextDispatcherListener() {
            Object l = null;
            try {
                Class<?> editorContextDispatcherClass = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.netbeans.spi.debugger.ui.EditorContextDispatcher");
                try {
                    try {
                        Object editorContextDispatcher = editorContextDispatcherClass.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
                        Method m = editorContextDispatcherClass.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                        m.invoke(editorContextDispatcher, this.contextDispatcherListener);
                        this.contextDispatcherListener = null;
                    }
                    catch (IllegalAccessException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                catch (NoSuchMethodException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (SecurityException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        public synchronized String toString() {
            return "ActionsProvider.ContextAware for service " + this.serviceName + ", context = " + this.context + ", path = " + this.path + ", delegate = " + this.delegate;
        }

        private class ContextDispatcherListener
        implements PropertyChangeListener {
            private ContextDispatcherListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ArrayList ls;
                ContextAware contextAware = ContextAware.this;
                synchronized (contextAware) {
                    ls = new ArrayList(ContextAware.this.listeners);
                }
                for (ActionsProviderListener l : ls) {
                    for (Object action : ContextAware.this.actions) {
                        l.actionStateChange(action, ContextAware.this.isEnabled(action));
                    }
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registrations {
        public Registration[] value();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";

        public String[] actions() default {};

        public String[] activateForMIMETypes() default {};
    }
}

