/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.module.main.ExtCssEditorModule;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.lib.api.CssModule;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PagedMediaModule
extends ExtCssEditorModule
implements CssModule {
    private static final String PROPERTIES_DEFINITION_PATH = "org/netbeans/modules/css/editor/module/main/properties/paged_media";
    private static final Collection<String> PAGE_PSEUDO_CLASSES = Arrays.asList("first", "left", "right");
    private static final Collection<String> PAGE_MARGIN_SYMBOLS = Arrays.asList("top-left-corner", "top-left", "top-center", "top-right", "top-right-corner", "bottom-left-corner", "bottom-left", "bottom-center", "bottom-right", "bottom-right-corner", "left-top", "left-middle", "left-bottom", "right-top", "right-middle", "right-bottom");

    @Override
    public List<CompletionProposal> getCompletionProposals(CompletionContext context) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        Node activeNode = context.getActiveNode();
        block20: while (true) {
            switch (activeNode.type()) {
                case error: 
                case recovery: {
                    activeNode = activeNode.parent();
                    continue block20;
                }
            }
            break;
        }
        String prefix = context.getPrefix();
        Token token = context.getTokenSequence().token();
        if (token == null) {
            return Collections.emptyList();
        }
        CssTokenId tokenId = (CssTokenId)token.id();
        switch (activeNode.type()) {
            case page: {
                switch (tokenId) {
                    case IDENT: {
                        if (context.getActiveTokenDiff() != 0 || LexerUtils.followsToken(context.getTokenSequence(), (TokenId)CssTokenId.PAGE_SYM, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS}) == null) break;
                        prefix = "";
                        proposals.addAll(PagedMediaModule.getPagePseudoClassCompletionProposals(context, true));
                        break;
                    }
                    case WS: {
                        if (LexerUtils.followsToken(context.getTokenSequence(), (TokenId)CssTokenId.LBRACE, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS}) == null) break;
                        proposals.addAll(PagedMediaModule.getPageMarginSymbolsCompletionProposals(context, true));
                        proposals.addAll(PagedMediaModule.getPropertiesCompletionProposals(context));
                        break;
                    }
                    case PAGE_SYM: {
                        proposals.addAll(PagedMediaModule.getPagePseudoClassCompletionProposals(context, true));
                        break;
                    }
                    case AT_SIGN: {
                        if (token.text().charAt(0) != '@') break;
                        proposals.addAll(PagedMediaModule.getPageMarginSymbolsCompletionProposals(context, true));
                    }
                }
                break;
            }
            case pseudoPage: 
            case bodyItem: {
                switch (tokenId) {
                    case IDENT: 
                    case COLON: {
                        proposals.addAll(PagedMediaModule.getPagePseudoClassCompletionProposals(context, false));
                    }
                }
                break;
            }
            case margin: {
                switch (tokenId) {
                    case WS: {
                        proposals.addAll(PagedMediaModule.getPropertiesCompletionProposals(context));
                    }
                }
            }
        }
        return Utilities.filterCompletionProposals(proposals, prefix, true);
    }

    private static List<CompletionProposal> getPageMarginSymbolsCompletionProposals(CompletionContext context, boolean addAtPrefix) {
        String prefix = addAtPrefix ? "@" : null;
        return Utilities.createRAWCompletionProposals(PAGE_MARGIN_SYMBOLS, ElementKind.FIELD, context.getAnchorOffset(), prefix);
    }

    private static List<CompletionProposal> getPagePseudoClassCompletionProposals(CompletionContext context, boolean addColonPrefix) {
        String prefix = addColonPrefix ? ":" : null;
        return Utilities.createRAWCompletionProposals(PAGE_PSEUDO_CLASSES, ElementKind.FIELD, context.getAnchorOffset(), prefix);
    }

    private static List<CompletionProposal> getPropertiesCompletionProposals(CompletionContext context) {
        return Utilities.wrapProperties(Properties.getPropertyDefinitions((FileObject)context.getFileObject()), context.getAnchorOffset());
    }

    @Override
    public <T extends Map<OffsetRange, Set<ColoringAttributes>>> NodeVisitor<T> getSemanticHighlightingNodeVisitor(FeatureContext context, T result) {
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                switch (node.type()) {
                    case pseudoPage: {
                        ((Map)this.getResult()).put(Css3Utils.getOffsetRange(node), ColoringAttributes.CLASS_SET);
                    }
                }
                return false;
            }
        };
    }

    public String getName() {
        return "paged_media";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)("css-module-displayname-" + this.getName()));
    }

    public String getSpecificationURL() {
        return "http://www.w3.org/TR/css3-page";
    }

    @Override
    protected String getPropertyDefinitionsResourcePath() {
        return PROPERTIES_DEFINITION_PATH;
    }

    @Override
    protected CssModule getCssModule() {
        return this;
    }
}

