/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.actions;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.actions.DeletedListRenderer;
import org.netbeans.modules.localhistory.ui.actions.FileNode;
import org.netbeans.modules.localhistory.ui.actions.RevertPanel;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RevertDeletedAction
extends NodeAction {
    public RevertDeletedAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(final Node[] activatedNodes) {
        final RevertPanel p = new RevertPanel();
        p.tree.setCellRenderer(new DeletedListRenderer());
        FileNodeListener l = new FileNodeListener();
        p.tree.addMouseListener(l);
        p.tree.addKeyListener(l);
        LocalHistory.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                RevertDeletedAction.this.retrieveDeletedFiles(activatedNodes, p);
            }
        });
        if (!p.open()) {
            return;
        }
        LocalHistory.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                RevertDeletedAction.this.revert(p.getRootNode());
            }
        });
    }

    private void retrieveDeletedFiles(Node[] activatedNodes, RevertPanel p) {
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        if (rootSet == null || rootSet.size() < 1) {
            return;
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        for (VCSFileProxy root : rootSet) {
            FileNode.PlainFileNode rfn = new FileNode.PlainFileNode(root);
            this.populateNode(rfn, root, !VersioningSupport.isFlat((VCSFileProxy)root));
            if (rfn.getChildCount() <= 0) continue;
            rootNode.add(rfn);
        }
        if (rootNode.getChildCount() > 0) {
            p.setRootNode(rootNode);
        } else {
            p.setRootNode(null);
        }
    }

    private List<FileNode.StoreEntryNode> getDeletedEntries(VCSFileProxy file) {
        StoreEntry[] entries = LocalHistory.getInstance().getLocalHistoryStore().getDeletedFiles(file);
        if (entries.length == 0) {
            return new LinkedList<FileNode.StoreEntryNode>();
        }
        LinkedList<FileNode.StoreEntryNode> l = new LinkedList<FileNode.StoreEntryNode>();
        for (StoreEntry e : entries) {
            if (e.getFile().exists()) continue;
            l.add(new FileNode.StoreEntryNode(e));
        }
        return l;
    }

    private void revert(TreeNode rootNode) {
        List<FileNode.StoreEntryNode> nodes = this.getSelectedNodes(rootNode);
        for (FileNode.StoreEntryNode sen : nodes) {
            RevertDeletedAction.revert(sen.getStoreEntry());
        }
    }

    private List<FileNode.StoreEntryNode> getSelectedNodes(TreeNode node) {
        LinkedList<FileNode.StoreEntryNode> ret = new LinkedList<FileNode.StoreEntryNode>();
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            FileNode.StoreEntryNode sen;
            TreeNode child = node.getChildAt(i);
            if (child instanceof FileNode.StoreEntryNode && (sen = (FileNode.StoreEntryNode)child).isSelected()) {
                ret.add(sen);
            }
            ret.addAll(this.getSelectedNodes(child));
        }
        return ret;
    }

    protected boolean enable(Node[] activatedNodes) {
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        if (rootSet == null || rootSet.size() < 1) {
            return false;
        }
        for (VCSFileProxy p : rootSet) {
            if (p == null || p.isDirectory()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ShowRevertDeleted");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RevertDeletedAction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void revert(StoreEntry se) {
        VCSFileProxy file = se.getFile();
        if (file.exists()) {
            if (file.isFile()) {
                LocalHistory.LOG.log(Level.WARNING, "Skipping revert for file {0} which already exists.", FileUtils.getPath(file));
            }
            LocalHistory.getInstance().getLocalHistoryStore().fileCreate(file, file.lastModified());
        }
        File storeFile = se.getStoreFile();
        InputStream is = null;
        OutputStream os = null;
        try {
            FileObject parentFO = file.getParentFile().toFileObject();
            if (parentFO != null) {
                if (!storeFile.isFile()) {
                    FileUtil.createFolder((FileObject)parentFO, (String)file.getName());
                } else {
                    FileObject fo = FileUtil.createData((FileObject)parentFO, (String)file.getName());
                    os = RevertDeletedAction.getOutputStream(fo);
                    is = se.getStoreFileInputStream();
                    FileUtil.copy((InputStream)is, (OutputStream)os);
                }
            } else {
                VCSFileProxy parentFile = file.getParentFile();
                if (parentFile.toFile() != null) {
                    LocalHistory.LOG.log(Level.WARNING, "FileObject for local file {0} is null.", file.getParentFile().getPath());
                    if (!storeFile.isFile()) {
                        file.toFile().mkdirs();
                    } else {
                        is = se.getStoreFileInputStream();
                        FileUtils.copy(is, file.toFile());
                    }
                } else {
                    LocalHistory.LOG.log(Level.WARNING, "FileObject for remote file {0} is null. Can''t revert.", file.getParentFile().getPath());
                }
            }
        }
        catch (Exception e) {
            LocalHistory.LOG.log(Level.SEVERE, null, e);
            return;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static OutputStream getOutputStream(FileObject fo) throws FileAlreadyLockedException, IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return fo.getOutputStream();
            }
            catch (IOException ioe) {
                if (++retry > 7) {
                    throw ioe;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    private void populateNode(FileNode node, VCSFileProxy root, boolean recursively) {
        List<FileNode.StoreEntryNode> deletedEntries = this.getDeletedEntries(root);
        if (!recursively) {
            for (FileNode.StoreEntryNode sen : deletedEntries) {
                node.add(sen);
            }
            return;
        }
        for (FileNode.StoreEntryNode sen : deletedEntries.toArray(new FileNode.StoreEntryNode[deletedEntries.size()])) {
            node.add(sen);
            if (sen.getStoreEntry().representsFile()) continue;
            this.populateNode(sen, sen.getStoreEntry().getFile(), true);
        }
        VCSFileProxy[] files = root.listFiles();
        if (files != null) {
            for (VCSFileProxy f : files) {
                if (!f.isDirectory()) continue;
                FileNode.PlainFileNode pfn = new FileNode.PlainFileNode(f);
                this.populateNode(pfn, f, true);
                if (pfn.getChildCount() <= 0) continue;
                node.add(pfn);
            }
        } else {
            LocalHistory.LOG.log(Level.WARNING, "listFiles() for directory {0} returned null", root);
        }
    }

    private class FileNodeListener
    implements MouseListener,
    KeyListener {
        private FileNodeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            Point p = e.getPoint();
            int row = tree.getRowForLocation(e.getX(), e.getY());
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                FileNode node = (FileNode)path.getLastPathComponent();
                Rectangle chRect = DeletedListRenderer.getCheckBoxRectangle();
                Rectangle rowRect = tree.getPathBounds(path);
                chRect.setLocation(chRect.x + rowRect.x, chRect.y + rowRect.y);
                if (e.getClickCount() == 1 && chRect.contains(p)) {
                    boolean isSelected = !node.isSelected();
                    node.setSelected(isSelected);
                    ((DefaultTreeModel)tree.getModel()).nodeChanged(node);
                    if (row == 0) {
                        tree.revalidate();
                    }
                    tree.repaint();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JTree tree;
            TreePath path;
            int keyCode = e.getKeyCode();
            if (keyCode == 32 && (path = (tree = (JTree)e.getSource()).getSelectionPath()) != null) {
                FileNode node;
                node.setSelected(!(node = (FileNode)path.getLastPathComponent()).isSelected());
                tree.repaint();
                e.consume();
            }
        }
    }
}

