/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MissingPlatformError;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.lib.nbjavac.services.CancelAbort;
import org.netbeans.lib.nbjavac.services.CancelService;
import org.netbeans.modules.java.source.TreeLoader;
import org.netbeans.modules.java.source.indexing.APTUtils;
import org.netbeans.modules.java.source.indexing.CompileWorker;
import org.netbeans.modules.java.source.indexing.DiagnosticListenerImpl;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.parsing.PrefetchableJavaFileObject;
import org.netbeans.modules.java.source.usages.ClassNamesForFileOraculumImpl;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class MultiPassCompileWorker
extends CompileWorker {
    private static final int MEMORY_LOW = 1;
    private static final int ERR = 2;
    private boolean checkForMemLow = true;

    MultiPassCompileWorker() {
    }

    @Override
    CompileWorker.ParsingOutput compile(final CompileWorker.ParsingOutput previous, final org.netbeans.modules.parsing.spi.indexing.Context context, JavaParsingContext javaContext, Collection<? extends JavaCustomIndexer.CompileTuple> files) {
        LinkedList<JavaCustomIndexer.CompileTuple> toProcess = new LinkedList<JavaCustomIndexer.CompileTuple>();
        final HashMap<PrefetchableJavaFileObject, JavaCustomIndexer.CompileTuple> jfo2tuples = new HashMap<PrefetchableJavaFileObject, JavaCustomIndexer.CompileTuple>();
        for (JavaCustomIndexer.CompileTuple compileTuple : files) {
            if (previous.finishedFiles.contains(compileTuple.indexable)) continue;
            toProcess.add(compileTuple);
            jfo2tuples.put(compileTuple.jfo, compileTuple);
        }
        if (toProcess.isEmpty()) {
            return CompileWorker.ParsingOutput.success(previous.file2FQNs, previous.addedTypes, previous.createdFiles, previous.finishedFiles, previous.modifiedTypes, previous.aptGenerated);
        }
        ClassNamesForFileOraculumImpl cnffOraculum = new ClassNamesForFileOraculumImpl(previous.file2FQNs);
        DiagnosticListenerImpl diagnosticListenerImpl = new DiagnosticListenerImpl();
        LinkedList<JavaCustomIndexer.CompileTuple> bigFiles = new LinkedList<JavaCustomIndexer.CompileTuple>();
        JavacTaskImpl jt = null;
        JavaCustomIndexer.CompileTuple active = null;
        boolean aptEnabled = false;
        int state = 0;
        boolean isBigFile = false;
        boolean[] flm = null;
        while (!toProcess.isEmpty() || !bigFiles.isEmpty() || active != null) {
            String message;
            ClassPath sourcePath;
            ClassPath classPath;
            ClassPath bootPath;
            if (context.isCancelled()) {
                return null;
            }
            try {
                context.getSuspendStatus().parkWhileSuspended();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            try {
                try {
                    if (this.isLowMemory(flm)) {
                        this.dumpSymFiles(jt, previous.createdFiles, context);
                        jt = null;
                        diagnosticListenerImpl.cleanDiagnostics();
                        if ((state & 1) != 0) break;
                        state |= 1;
                        this.freeMemory(true);
                        continue;
                    }
                    if (active == null) {
                        if (!toProcess.isEmpty()) {
                            active = (JavaCustomIndexer.CompileTuple)toProcess.removeFirst();
                            if (active == null || previous.finishedFiles.contains(active.indexable)) continue;
                            isBigFile = false;
                        } else {
                            active = (JavaCustomIndexer.CompileTuple)bigFiles.removeFirst();
                            isBigFile = true;
                            if (flm == null) {
                                flm = new boolean[]{true};
                            }
                        }
                    }
                    if (jt == null) {
                        jt = JavacParser.createJavacTask(javaContext.getClasspathInfo(), diagnosticListenerImpl, javaContext.getSourceLevel(), javaContext.getProfile(), cnffOraculum, javaContext.getFQNs(), new CancelService(){

                            public boolean isCanceled() {
                                return context.isCancelled() || MultiPassCompileWorker.this.checkForMemLow && MultiPassCompileWorker.this.isLowMemory(null);
                            }
                        }, active.aptGenerated ? null : APTUtils.get(context.getRoot()));
                        Iterable processors = jt.getProcessors();
                        boolean bl = aptEnabled = processors != null && processors.iterator().hasNext();
                        if (JavaIndex.LOG.isLoggable(Level.FINER)) {
                            JavaIndex.LOG.finer("Created new JavacTask for: " + FileUtil.getFileDisplayName((FileObject)context.getRoot()) + " " + javaContext.getClasspathInfo().toString());
                        }
                    }
                    Iterable trees = jt.parse(new JavaFileObject[]{active.jfo});
                    if (this.isLowMemory(flm)) {
                        this.dumpSymFiles(jt, previous.createdFiles, context);
                        jt = null;
                        diagnosticListenerImpl.cleanDiagnostics();
                        trees = null;
                        if ((state & 1) != 0) {
                            if (isBigFile) break;
                            bigFiles.add(active);
                            active = null;
                            state &= 0xFFFFFFFE;
                        } else {
                            state |= 1;
                        }
                        this.freeMemory(true);
                        continue;
                    }
                    Iterable types = jt.enterTrees(trees);
                    if (jfo2tuples.remove(active.jfo) != null) {
                        final Types ts = Types.instance(jt.getContext());
                        final Indexable activeIndexable = active.indexable;
                        class ScanNested
                        extends TreeScanner {
                            Set<JavaCustomIndexer.CompileTuple> dependencies = new LinkedHashSet<JavaCustomIndexer.CompileTuple>();

                            ScanNested() {
                            }

                            @Override
                            public void visitClassDef(JCTree.JCClassDecl node) {
                                if (node.sym != null) {
                                    Type st = ts.supertype(node.sym.type);
                                    boolean envForSuperTypeFound = false;
                                    while (!envForSuperTypeFound && st != null && st.hasTag(TypeTag.CLASS)) {
                                        Symbol.ClassSymbol c = st.tsym.outermostClass();
                                        JavaCustomIndexer.CompileTuple u = (JavaCustomIndexer.CompileTuple)jfo2tuples.get(c.sourcefile);
                                        if (u != null && !previous.finishedFiles.contains(u.indexable) && !u.indexable.equals((Object)activeIndexable)) {
                                            this.dependencies.add(u);
                                            envForSuperTypeFound = true;
                                        }
                                        st = ts.supertype(st);
                                    }
                                }
                                super.visitClassDef(node);
                            }
                        }
                        ScanNested scanner = new ScanNested();
                        for (CompilationUnitTree cut : trees) {
                            scanner.scan((JCTree.JCCompilationUnit)cut);
                        }
                        if (!scanner.dependencies.isEmpty()) {
                            toProcess.addFirst(active);
                            for (JavaCustomIndexer.CompileTuple tuple : scanner.dependencies) {
                                toProcess.addFirst(tuple);
                            }
                            active = null;
                            continue;
                        }
                    }
                    if (this.isLowMemory(flm)) {
                        this.dumpSymFiles(jt, previous.createdFiles, context);
                        jt = null;
                        diagnosticListenerImpl.cleanDiagnostics();
                        trees = null;
                        types = null;
                        if ((state & 1) != 0) {
                            if (isBigFile) break;
                            bigFiles.add(active);
                            active = null;
                            state &= 0xFFFFFFFE;
                        } else {
                            state |= 1;
                        }
                        this.freeMemory(true);
                        continue;
                    }
                    jt.analyze(types);
                    if (aptEnabled) {
                        JavaCustomIndexer.addAptGenerated(context, javaContext, active, previous.aptGenerated);
                    }
                    if (this.isLowMemory(flm)) {
                        this.dumpSymFiles(jt, previous.createdFiles, context);
                        jt = null;
                        diagnosticListenerImpl.cleanDiagnostics();
                        trees = null;
                        types = null;
                        if ((state & 1) != 0) {
                            if (isBigFile) break;
                            bigFiles.add(active);
                            active = null;
                            state &= 0xFFFFFFFE;
                        } else {
                            state |= 1;
                        }
                        this.freeMemory(true);
                        continue;
                    }
                    javaContext.getFQNs().set(types, active.indexable.getURL());
                    boolean[] main = new boolean[1];
                    if (javaContext.getCheckSums().checkAndSet(active.indexable.getURL(), types, jt.getElements()) || context.isSupplementaryFilesIndexing()) {
                        javaContext.analyze(trees, jt, active, previous.addedTypes, main);
                    } else {
                        HashSet aTypes = new HashSet();
                        javaContext.analyze(trees, jt, active, aTypes, main);
                        previous.addedTypes.addAll(aTypes);
                        previous.modifiedTypes.addAll(aTypes);
                    }
                    ExecutableFilesIndex.DEFAULT.setMainClass(context.getRoot().getURL(), active.indexable.getURL(), main[0]);
                    JavaCustomIndexer.setErrors(context, active, diagnosticListenerImpl);
                    Iterable<? extends JavaFileObject> generatedFiles = jt.generate(types);
                    if (!active.virtual) {
                        for (JavaFileObject javaFileObject : generatedFiles) {
                            if (!(javaFileObject instanceof FileObjects.FileBase)) continue;
                            previous.createdFiles.add(((FileObjects.FileBase)javaFileObject).getFile());
                        }
                    }
                    Log.instance((Context)jt.getContext()).nerrors = 0;
                    previous.finishedFiles.add(active.indexable);
                    active = null;
                    state = 0;
                }
                catch (CancelAbort ca) {
                    if (this.isLowMemory(flm)) {
                        this.dumpSymFiles(jt, previous.createdFiles, context);
                        jt = null;
                        diagnosticListenerImpl.cleanDiagnostics();
                        if ((state & 1) != 0) {
                            if (isBigFile) break;
                            bigFiles.add(active);
                            active = null;
                            state &= 0xFFFFFFFE;
                        } else {
                            state |= 1;
                        }
                        this.freeMemory(true);
                        continue;
                    }
                    if (!JavaIndex.LOG.isLoggable(Level.FINEST)) continue;
                    JavaIndex.LOG.log(Level.FINEST, "OnePassCompileWorker was canceled in root: " + FileUtil.getFileDisplayName((FileObject)context.getRoot()), ca);
                }
            }
            catch (CouplingAbort ca) {
                TreeLoader.dumpCouplingAbort(ca, null);
                jt = null;
                diagnosticListenerImpl.cleanDiagnostics();
                if ((state & 2) != 0) {
                    if (active != null) {
                        previous.finishedFiles.add(active.indexable);
                    }
                    active = null;
                    state = 0;
                    continue;
                }
                state |= 2;
            }
            catch (OutputFileManager.InvalidSourcePath isp) {
                if (JavaIndex.LOG.isLoggable(Level.FINEST)) {
                    bootPath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    classPath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    sourcePath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    message = String.format("MultiPassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", active.jfo.toUri().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString());
                    JavaIndex.LOG.log(Level.FINEST, message, isp);
                }
                return CompileWorker.ParsingOutput.failure(previous.file2FQNs, previous.addedTypes, previous.createdFiles, previous.finishedFiles, previous.modifiedTypes, previous.aptGenerated);
            }
            catch (MissingPlatformError mpe) {
                if (JavaIndex.LOG.isLoggable(Level.FINEST)) {
                    bootPath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    classPath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    sourcePath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    message = String.format("MultiPassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", active.jfo.toUri().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString());
                    JavaIndex.LOG.log(Level.FINEST, message, mpe);
                }
                JavaCustomIndexer.brokenPlatform(context, files, mpe.getDiagnostic());
                return CompileWorker.ParsingOutput.failure(previous.file2FQNs, previous.addedTypes, previous.createdFiles, previous.finishedFiles, previous.modifiedTypes, previous.aptGenerated);
            }
            catch (Throwable t) {
                Level level;
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                Level level2 = level = t instanceof FatalError ? Level.FINEST : Level.WARNING;
                if (JavaIndex.LOG.isLoggable(level)) {
                    ClassPath bootPath2 = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath2 = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath sourcePath2 = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    String string = String.format("MultiPassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", active == null ? null : active.jfo.toUri().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath2 == null ? null : bootPath2.toString(), classPath2 == null ? null : classPath2.toString(), sourcePath2 == null ? null : sourcePath2.toString());
                    JavaIndex.LOG.log(level, string, t);
                }
                jt = null;
                diagnosticListenerImpl.cleanDiagnostics();
                if ((state & 2) != 0) {
                    if (active != null) {
                        previous.finishedFiles.add(active.indexable);
                    }
                    active = null;
                    state = 0;
                    continue;
                }
                state |= 2;
            }
        }
        return !(state & true) ? CompileWorker.ParsingOutput.success(previous.file2FQNs, previous.addedTypes, previous.createdFiles, previous.finishedFiles, previous.modifiedTypes, previous.aptGenerated) : CompileWorker.ParsingOutput.lowMemory(previous.file2FQNs, previous.addedTypes, previous.createdFiles, previous.finishedFiles, previous.modifiedTypes, previous.aptGenerated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSymFiles(JavacTaskImpl jti, Set<File> alreadyCreated, org.netbeans.modules.parsing.spi.indexing.Context ctx) throws IOException {
        if (jti != null) {
            JavaFileManager jfm = jti.getContext().get(JavaFileManager.class);
            this.checkForMemLow = false;
            try {
                final Types types = Types.instance(jti.getContext());
                final Enter enter = Enter.instance(jti.getContext());
                final Symtab syms = Symtab.instance(jti.getContext());
                final HashMap<Symbol.ClassSymbol, JCTree.JCClassDecl> syms2trees = new HashMap<Symbol.ClassSymbol, JCTree.JCClassDecl>();
                HashSet<Env> processedEnvs = new HashSet<Env>();
                File classes = JavaIndex.getClassFolder(ctx);
                for (Env env : jti.getTodo()) {
                    if (!processedEnvs.add(env)) continue;
                    class ScanNested
                    extends TreeScanner {
                        private Env<AttrContext> env;
                        private Set<Env<AttrContext>> checked = new HashSet<Env<AttrContext>>();
                        private List<Env<AttrContext>> dependencies = new LinkedList<Env<AttrContext>>();

                        public ScanNested(Env<AttrContext> env) {
                            this.env = env;
                        }

                        @Override
                        public void visitClassDef(JCTree.JCClassDecl node) {
                            if (node.sym != null) {
                                Type st = types.supertype(node.sym.type);
                                boolean envForSuperTypeFound = false;
                                while (!envForSuperTypeFound && st != null && st.hasTag(TypeTag.CLASS)) {
                                    Symbol.ClassSymbol c = st.tsym.outermostClass();
                                    Env<AttrContext> stEnv = enter.getEnv(c);
                                    if (stEnv != null && this.env != stEnv) {
                                        if (this.checked.add(stEnv)) {
                                            this.scan(stEnv.tree);
                                            if (TreeLoader.pruneTree(stEnv.tree, syms, syms2trees)) {
                                                this.dependencies.add(stEnv);
                                            }
                                        }
                                        envForSuperTypeFound = true;
                                    }
                                    st = types.supertype(st);
                                }
                            }
                            super.visitClassDef(node);
                        }
                    }
                    ScanNested scanner = new ScanNested(env);
                    scanner.scan(env.tree);
                    for (Env dep : scanner.dependencies) {
                        if (!processedEnvs.add(dep)) continue;
                        this.dumpSymFile(jfm, jti, dep.enclClass.sym, alreadyCreated, classes, syms2trees);
                    }
                    if (!TreeLoader.pruneTree(env.tree, syms, syms2trees)) continue;
                    this.dumpSymFile(jfm, jti, env.enclClass.sym, alreadyCreated, classes, syms2trees);
                }
            }
            finally {
                this.checkForMemLow = true;
            }
        }
    }

    private void dumpSymFile(@NonNull JavaFileManager jfm, @NonNull JavacTaskImpl jti, @NullAllowed Symbol.ClassSymbol cs, @NonNull Set<File> alreadyCreated, @NonNull File classes, @NonNull HashMap<Symbol.ClassSymbol, JCTree.JCClassDecl> syms2trees) throws IOException {
        if (cs == null) {
            return;
        }
        JavaFileObject file = jfm.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, cs.flatname.toString(), JavaFileObject.Kind.CLASS, cs.sourcefile);
        if (file instanceof FileObjects.FileBase && !alreadyCreated.contains(((FileObjects.FileBase)file).getFile())) {
            TreeLoader.dumpSymFile(jfm, jti, cs, classes, syms2trees);
        }
    }
}

