/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.tools.javac.api.ClientCodeWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.AbstractSourceFileObject;
import org.netbeans.modules.java.source.parsing.DocumentProvider;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

@ClientCodeWrapper.Trusted
public class BasicSourceFileObject
extends AbstractSourceFileObject
implements DocumentProvider {
    private static final Logger LOG = Logger.getLogger(BasicSourceFileObject.class.getName());
    private final boolean hasFilter;

    @CheckForNull
    public static BasicSourceFileObject create(@NonNull FileObject file, @NonNull FileObject root) {
        try {
            return new BasicSourceFileObject(new AbstractSourceFileObject.Handle(file, root), null, null, false);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, ioe.getMessage(), ioe);
            }
            return null;
        }
    }

    public BasicSourceFileObject(@NonNull AbstractSourceFileObject.Handle handle, @NullAllowed JavaFileFilterImplementation filter, @NullAllowed CharSequence content, boolean renderNow) throws IOException {
        super(handle, filter);
        boolean bl = this.hasFilter = filter != null;
        if (content != null || renderNow) {
            this.update(content);
        }
    }

    @Override
    protected final Long isDirty() {
        Document doc;
        FileObject file = this.getHandle().resolveFileObject(false);
        if (file == null) {
            return null;
        }
        Source source = Source.create((FileObject)file);
        if (source != null && (doc = source.getDocument(false)) != null) {
            return DocumentUtilities.getDocumentTimestamp((Document)doc);
        }
        return null;
    }

    @Override
    @CheckForNull
    protected final OutputStream createOutputStream() throws IOException {
        FileObject file = this.getHandle().resolveFileObject(true);
        if (file == null) {
            throw new IOException("Cannot create file: " + this.toString());
        }
        StyledDocument doc = this.getDocument();
        if (doc != null) {
            return new DocumentStream(doc);
        }
        return null;
    }

    @Override
    @NonNull
    protected final CharSequence createContent() throws IOException {
        FileObject file = this.getHandle().resolveFileObject(false);
        if (file == null) {
            throw new FileNotFoundException("Cannot open file: " + this.toString());
        }
        Source source = Source.create((FileObject)file);
        if (source == null) {
            throw new IOException("No source for: " + FileUtil.getFileDisplayName((FileObject)file));
        }
        CharSequence content = source.createSnapshot().getText();
        if (this.hasFilter && source.getDocument(false) == null) {
            content = this.filter(content);
        }
        return content;
    }

    @Override
    public StyledDocument getDocument() {
        FileObject file = this.getHandle().resolveFileObject(false);
        if (file == null) {
            return null;
        }
        Source src = Source.create((FileObject)file);
        if (src == null) {
            return null;
        }
        Document doc = src.getDocument(false);
        return doc instanceof StyledDocument ? (StyledDocument)doc : null;
    }

    @Override
    public void runAtomic(Runnable r) {
        assert (r != null);
        StyledDocument doc = this.getDocument();
        if (doc == null) {
            throw new IllegalStateException();
        }
        ((AtomicLockDocument)LineDocumentUtils.as((Document)doc, AtomicLockDocument.class)).runAtomic(r);
    }

    private class DocumentStream
    extends OutputStream {
        private static final int BUF_SIZ = 2048;
        private final StyledDocument doc;
        private byte[] data;
        private int pos;

        public DocumentStream(StyledDocument doc) {
            assert (doc != null);
            this.doc = doc;
            this.data = new byte[2048];
            this.pos = 0;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.ensureSize(len);
            System.arraycopy(b, off, this.data, this.pos, len);
            this.pos += len;
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            this.ensureSize(b.length);
            System.arraycopy(b, 0, this.data, this.pos, b.length);
            this.pos += b.length;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.ensureSize(1);
            this.data[this.pos++] = (byte)(b & 0xFF);
        }

        private void ensureSize(int delta) {
            int requiredLength = this.pos + delta;
            if (this.data.length < requiredLength) {
                int newSize;
                for (newSize = this.data.length + 2048; newSize < requiredLength; newSize += 2048) {
                }
                byte[] newData = new byte[newSize];
                System.arraycopy(this.data, 0, newData, 0, this.pos);
                this.data = newData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            try {
                ((AtomicLockDocument)LineDocumentUtils.as((Document)this.doc, AtomicLockDocument.class)).runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                DocumentStream.this.doc.remove(0, DocumentStream.this.doc.getLength());
                                DocumentStream.this.doc.insertString(0, new String(DocumentStream.this.data, 0, DocumentStream.this.pos, FileEncodingQuery.getEncoding((FileObject)BasicSourceFileObject.this.getHandle().resolveFileObject(false))), null);
                            }
                            catch (BadLocationException e) {
                                if (!LOG.isLoggable(Level.SEVERE)) break block2;
                                LOG.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                    }
                });
            }
            finally {
                BasicSourceFileObject.this.resetCaches();
            }
        }
    }
}

