/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.groovy.gsp.lexer.GspLexerLanguage;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public class HtmlEmbeddingProvider
extends EmbeddingProvider {
    public static final String GENERATED_CODE = "@@@";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenSequence<GspTokenId> sequence = this.getTokenSequence(snapshot);
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        boolean lastEmbeddingIsVirtual = false;
        block3: while (sequence.moveNext()) {
            Token token = sequence.token();
            switch ((GspTokenId)token.id()) {
                case HTML: {
                    embeddings.add(snapshot.create(sequence.offset(), token.length(), "text/html"));
                    lastEmbeddingIsVirtual = false;
                    continue block3;
                }
            }
            if (lastEmbeddingIsVirtual) continue;
            embeddings.add(snapshot.create((CharSequence)GENERATED_CODE, "text/html"));
            lastEmbeddingIsVirtual = true;
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    private TokenSequence<GspTokenId> getTokenSequence(Snapshot snapshot) {
        Language<GspTokenId> gspLanguage = GspLexerLanguage.getLanguage();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)snapshot.getText(), gspLanguage);
        TokenSequence sequence = tokenHierarchy.tokenSequence(gspLanguage);
        sequence.moveStart();
        return sequence;
    }

    public int getPriority() {
        return 200;
    }

    public void cancel() {
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new HtmlEmbeddingProvider());
        }
    }
}

