/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.jsr172.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.jsr172.multiview.FileContentComparator;
import org.netbeans.modules.mobility.jsr172.wizard.WsdlRetriever;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WsdlUpdater
implements WsdlRetriever.MessageReceiver,
Cancellable {
    static final String PROP_UPDATE_FINISHED = "updateFinished";
    private final WsdlRetriever retriever;
    private final ProgressHandle handle;
    private final RequestProcessor updater;
    private final E2EDataObject doj;
    private final String toPackage;
    private final String fileName;
    private transient ArrayList<PropertyChangeListener> propertyChangeListenerList;

    public WsdlUpdater(String url, String toPackage, String fileName, E2EDataObject doj) {
        this.doj = doj;
        this.toPackage = toPackage;
        this.fileName = fileName;
        this.retriever = new WsdlRetriever(this, url);
        this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(WsdlUpdater.class, (String)"MSG_RefreshingWsdl"), (Cancellable)this);
        this.handle.start();
        this.handle.switchToIndeterminate();
        this.handle.progress(NbBundle.getMessage(WsdlUpdater.class, (String)"MSG_Refreshing"));
        this.updater = new RequestProcessor("wsdl updater");
        this.updater.post((Runnable)this.retriever);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWsdlDownloadMessage(String message) {
        this.handle.progress(message);
        if (this.retriever.getState() >= 3) {
            block17: {
                this.handle.finish();
                this.updater.stop();
                if (this.retriever.getState() == 3) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(this.retriever.getWsdl());
                    try {
                        boolean equals;
                        String file = this.toPackage + '/' + this.fileName;
                        Sources sources = (Sources)this.doj.getClientProject().getLookup().lookup(Sources.class);
                        SourceGroup sg = sources.getSourceGroups("java")[0];
                        FileObject localFile = sg.getRootFolder().getFileObject(file);
                        if (localFile == null) {
                            equals = false;
                        } else {
                            InputStream is = localFile.getInputStream();
                            equals = FileContentComparator.equalFiles(bais, is);
                            is.close();
                        }
                        if (equals) {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WsdlUpdater.class, (String)"MSG_WSDL_Unchanged"));
                            break block17;
                        }
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WsdlUpdater.class, (String)"MSG_WSDL_Changed"), NbBundle.getMessage(WsdlUpdater.class, (String)"MSG_WSDL_ChangedTitle"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        if (nd.getValue() != NotifyDescriptor.YES_OPTION) break block17;
                        FileLock flck = null;
                        if (localFile == null) {
                            localFile = sg.getRootFolder().getFileObject(this.toPackage);
                            localFile = localFile.createData(this.fileName);
                            assert (localFile != null);
                        }
                        try {
                            flck = localFile.lock();
                            BufferedOutputStream bos = new BufferedOutputStream(localFile.getOutputStream(flck));
                            bos.write(this.retriever.getWsdl());
                            bos.close();
                            this.doj.generate();
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        finally {
                            if (flck != null) {
                                flck.releaseLock();
                            }
                        }
                    }
                    catch (IOException iOException) {}
                } else if (this.retriever.getState() > 3) {
                    StatusDisplayer.getDefault().setStatusText(message);
                }
            }
            this.firePropertyChangeListenerPropertyChange(new PropertyChangeEvent(this, PROP_UPDATE_FINISHED, Boolean.FALSE, Boolean.TRUE));
        }
    }

    public boolean cancel() {
        this.retriever.stopRetrieval();
        this.setWsdlDownloadMessage(NbBundle.getMessage(WsdlUpdater.class, (String)"MSG_Stopping"));
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListenerList == null) {
            this.propertyChangeListenerList = new ArrayList();
        }
        this.propertyChangeListenerList.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListenerList != null) {
            this.propertyChangeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangeListenerPropertyChange(PropertyChangeEvent event) {
        PropertyChangeListener[] list;
        WsdlUpdater wsdlUpdater = this;
        synchronized (wsdlUpdater) {
            if (this.propertyChangeListenerList == null) {
                return;
            }
            list = this.propertyChangeListenerList.toArray(new PropertyChangeListener[this.propertyChangeListenerList.size()]);
        }
        for (PropertyChangeListener pcl : list) {
            pcl.propertyChange(event);
        }
    }
}

