/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.fetch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRefUpdateResult;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.cli.GitTransportUpdate;
import org.netbeans.modules.git.remote.cli.RefUtils;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.client.ProgressDelegate;
import org.netbeans.modules.git.remote.ui.branch.BranchSynchronizer;
import org.netbeans.modules.git.remote.ui.fetch.Bundle;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.repository.Revision;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.git.remote.utils.LogUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class FetchUtils {
    private static final Set<GitRefUpdateResult> UPDATED_STATUSES = new HashSet<GitRefUpdateResult>(Arrays.asList(GitRefUpdateResult.FAST_FORWARD, GitRefUpdateResult.FORCED, GitRefUpdateResult.NEW, GitRefUpdateResult.OK, GitRefUpdateResult.RENAMED));
    private static final String TMP_REFS_PREFIX = "netbeans_tmp";

    static void log(VCSFileProxy repository, Map<String, GitTransportUpdate> updates, OutputLogger logger) {
        if (updates.isEmpty()) {
            logger.outputLine(Bundle.MSG_GetRemoteChangesAction_updates_noChange());
        } else {
            for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                GitTransportUpdate update = e.getValue();
                if (!UPDATED_STATUSES.contains(update.getResult())) continue;
                if (update.getType() == GitTransportUpdate.Type.BRANCH) {
                    logger.outputLine(Bundle.MSG_GetRemoteChangesAction_updates_updateBranch(update.getLocalName(), update.getOldObjectId(), update.getNewObjectId(), update.getResult()));
                    String oldId = update.getOldObjectId();
                    String newId = update.getNewObjectId();
                    String branchName = update.getLocalName();
                    LogUtils.logBranchUpdateReview(repository, branchName, oldId, newId, logger);
                    continue;
                }
                logger.outputLine(Bundle.MSG_GetRemoteChangesAction_updates_updateTag(update.getLocalName(), update.getResult()));
            }
        }
    }

    private static String parseRemote(String branchName) {
        int pos = branchName.indexOf(47);
        String remoteName = null;
        if (pos > 0) {
            remoteName = branchName.substring(0, pos);
        }
        return remoteName;
    }

    static GitRemoteConfig getRemoteConfigForActiveBranch(GitBranch trackedBranch, RepositoryInfo info, String errorLabel) {
        GitRemoteConfig cfg;
        Map<String, GitRemoteConfig> remotes = info.getRemotes();
        String remoteName = FetchUtils.parseRemote(trackedBranch.getName());
        GitRemoteConfig gitRemoteConfig = cfg = remoteName == null ? null : remotes.get(remoteName);
        if (cfg == null) {
            if (errorLabel != null) {
                GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noRemote(trackedBranch.getName()));
            }
            return null;
        }
        if (cfg.getUris().isEmpty()) {
            if (errorLabel != null) {
                GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noUri(cfg.getRemoteName()));
            }
            return null;
        }
        if (cfg.getFetchRefSpecs().isEmpty()) {
            if (errorLabel != null) {
                GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noSpecs(cfg.getRemoteName()));
            }
            return null;
        }
        return cfg;
    }

    public static Revision fetchToTemp(GitClient client, ProgressMonitor pm, GitBranch branch) throws GitException {
        GitRemoteConfig cfg;
        if (!branch.isRemote()) {
            GitBranch trackedBranch = branch.getTrackedBranch();
            if (trackedBranch == null || !trackedBranch.isRemote()) {
                throw new GitException(Bundle.MSG_FetchUtils_noTrackingBranch(branch.getName()));
            }
            branch = trackedBranch;
        }
        if ((cfg = FetchUtils.getRemoteConfigForActiveBranch(branch, RepositoryInfo.getInstance(client.getRepositoryRoot()), null)) == null) {
            throw new GitException(Bundle.MSG_FetchUtils_noRemoteConfig());
        }
        if (cfg.getUris().isEmpty()) {
            throw new GitException(Bundle.MSG_FetchUtils_noRemoteUrl(cfg.getRemoteName()));
        }
        String remotePeer = RefUtils.findRemotePeer((List)cfg.getFetchRefSpecs(), (GitBranch)branch);
        if (remotePeer == null) {
            remotePeer = branch.getName().split("/", 0)[1];
        }
        client.deleteBranch("netbeans_tmp/" + remotePeer, true, GitUtils.NULL_PROGRESS_MONITOR);
        Map<String, GitTransportUpdate> updates = client.fetch((String)cfg.getUris().get(0), Collections.singletonList("+refs/heads/" + remotePeer + ":refs/" + TMP_REFS_PREFIX + "/" + remotePeer), pm);
        GitTransportUpdate upd = updates.get("netbeans_tmp/" + remotePeer);
        if (upd != null) {
            client.deleteBranch(upd.getLocalName(), true, GitUtils.NULL_PROGRESS_MONITOR);
            VCSFileProxySupport.delete((VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)GitUtils.getGitFolderForRoot(client.getRepositoryRoot()), (String)"refs/netbeans_tmp"));
            return new Revision(upd.getNewObjectId(), upd.getLocalName().split("/", 0)[1]);
        }
        return null;
    }

    private FetchUtils() {
    }

    static void syncTrackingBranches(VCSFileProxy repository, Map<String, GitTransportUpdate> updates, GitProgressSupport supp, ProgressDelegate progress, boolean checkActiveBranch) {
        ArrayList<String> branchNames = new ArrayList<String>();
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        Map<String, GitBranch> branches = info.getBranches();
        GitBranch activeBranchToUpdate = null;
        for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
            GitTransportUpdate update = e.getValue();
            if (!UPDATED_STATUSES.contains(update.getResult()) || update.getType() != GitTransportUpdate.Type.BRANCH) continue;
            String remoteBranchName = e.getValue().getLocalName();
            for (GitBranch b : branches.values()) {
                if (b.isRemote() || b.getTrackedBranch() == null || !b.getTrackedBranch().getName().equals(remoteBranchName) || !GitModuleConfig.getDefault().getAutoSyncBranch(repository, b.getName())) continue;
                if (b.isActive()) {
                    activeBranchToUpdate = b;
                    continue;
                }
                branchNames.add(b.getName());
            }
        }
        try {
            new BranchSynchronizer().syncBranches(repository, branchNames.toArray(new String[branchNames.size()]), progress, supp.getLogger());
        }
        catch (GitException ex) {
            Logger.getLogger(FetchUtils.class.getName()).log(Level.INFO, null, ex);
        }
        if (checkActiveBranch && activeBranchToUpdate != null && NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_SyncBranches_activeBranch(activeBranchToUpdate.getName(), activeBranchToUpdate.getTrackedBranch().getName()), Bundle.LBL_SyncBranches_activeBranch(), 0, 3))) {
            new BranchSynchronizer().syncBranches(repository, new String[]{activeBranchToUpdate.getName()}, true);
        }
    }
}

