/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.validation;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.validation.ValidationContext;
import org.netbeans.modules.html.editor.lib.api.validation.ValidationException;
import org.netbeans.modules.html.editor.lib.api.validation.ValidationResult;
import org.netbeans.modules.html.editor.lib.api.validation.Validator;
import org.netbeans.modules.html.validation.ValidationTransaction;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.xml.sax.SAXException;

public class ValidatorImpl
implements Validator {
    private static final Pattern TEMPLATING_MARKS_PATTERN = Pattern.compile("@@@");
    private static final String TEMPLATING_MARKS_MASK = "   ";

    public ValidationResult validate(ValidationContext context) throws ValidationException {
        assert (this.canValidate(context.getVersion()));
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ValidationTransaction validatorTransaction = ValidationTransaction.create(context.getVersion());
            FileObject file = context.getFile();
            URL sourceFileURL = file != null ? URLMapper.findURL((FileObject)file, (int)1) : null;
            Set<Object> filteredNamespaces = Collections.emptySet();
            if (context.isFeatureEnabled("filter.foreign.namespaces")) {
                filteredNamespaces = context.getSyntaxAnalyzerResult().getAllDeclaredNamespaces().keySet();
                filteredNamespaces.remove("http://www.w3.org/1999/xhtml");
            }
            String encoding = file != null ? FileEncodingQuery.getEncoding((FileObject)file).name() : "UTF-8";
            validatorTransaction.validateCode(context.getSourceReader(), sourceFileURL != null ? sourceFileURL.toExternalForm() : null, filteredNamespaces, encoding);
            LinkedList<ProblemDescription> problems = new LinkedList<ProblemDescription>(validatorTransaction.getFoundProblems(1));
            if (context.getSyntaxAnalyzerResult().getDetectedHtmlVersion() == null) {
                this.filterCodeFragmentProblems(context, problems);
            }
            ValidationResult validationResult = new ValidationResult((Validator)this, context, problems, problems.isEmpty());
            return validationResult;
        }
        catch (SAXException ex) {
            throw new ValidationException((Throwable)ex);
        }
        finally {
            if (Thread.currentThread().getContextClassLoader() != contextClassLoader) {
                Logger.getAnonymousLogger().info("Thread's context ClassLoader has been changed during the validation.nu code execution! See issue 195626 for more info");
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public String getValidatorName() {
        return "validator.nu";
    }

    public boolean canValidate(HtmlVersion version) {
        switch (version) {
            case HTML32: 
            case HTML40_FRAMESET: 
            case HTML40_STRICT: 
            case HTML40_TRANSATIONAL: 
            case HTML41_FRAMESET: 
            case HTML41_STRICT: 
            case HTML41_TRANSATIONAL: 
            case XHTML10_FRAMESET: 
            case XHTML10_TRANSATIONAL: 
            case XHTML10_STICT: 
            case HTML5: 
            case XHTML5: {
                return true;
            }
        }
        return false;
    }

    private void filterCodeFragmentProblems(ValidationContext context, Collection<ProblemDescription> problems) {
        Iterator<ProblemDescription> itr = problems.iterator();
        while (itr.hasNext()) {
            ProblemDescription problem = itr.next();
            if (!problem.getText().startsWith("Error: Start tag seen without seeing a doctype first.") && (!problem.getText().startsWith("Error: Element \"head\" is missing a required instance of child element") || this.containsHeadElement(context))) continue;
            itr.remove();
        }
    }

    private boolean containsHeadElement(ValidationContext context) {
        Iterator head = context.getSyntaxAnalyzerResult().getElementsIterator();
        int limit = 20;
        while (head.hasNext()) {
            OpenTag ot;
            Element se = (Element)head.next();
            if (limit-- == 0) break;
            if (se.type() != ElementType.OPEN_TAG || !LexerUtils.equals((CharSequence)"head", (CharSequence)(ot = (OpenTag)se).unqualifiedName(), (boolean)true, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    static String maskTemplatingMarks(String code) {
        return TEMPLATING_MARKS_PATTERN.matcher(code).replaceAll(TEMPLATING_MARKS_MASK);
    }
}

