/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.netbeans.junit.ControlFlow;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.internal.NbModuleLogHandler;

public final class Log
extends Handler {
    private static NbTestCase current;
    private static final StringBuffer messages;
    private static int initialMessages;
    private Reference<PrintStream> log;
    private Logger logger;

    public Log() {
    }

    private Log(Logger l, PrintStream ps) {
        this.log = new WeakReference<PrintStream>(ps);
        this.logger = l;
    }

    static Runnable internalLog() {
        return new IL(true);
    }

    public static CharSequence enable(String loggerName, Level level) {
        IL il = new IL(false);
        Logger l = Logger.getLogger(loggerName);
        if (l.getLevel() == null || l.getLevel().intValue() > level.intValue()) {
            l.setLevel(level);
        }
        class MyPs
        extends PrintStream
        implements CharSequence {
            private ByteArrayOutputStream os;

            public MyPs() {
                this(new ByteArrayOutputStream());
            }

            private MyPs(ByteArrayOutputStream arr) {
                super(arr);
                this.os = arr;
            }

            @Override
            public int length() {
                return this.toString().length();
            }

            @Override
            public char charAt(int index) {
                return this.toString().charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return this.toString().subSequence(start, end);
            }

            @Override
            public String toString() {
                return this.os.toString();
            }
        }
        MyPs ps = new MyPs();
        Log log = new Log(l, ps);
        log.setLevel(level);
        l.addHandler(log);
        return ps;
    }

    public static void controlFlow(Logger listenTo, Logger reportTo, String order, int timeout) {
        ControlFlow.registerSwitches(listenTo, reportTo, order, timeout);
    }

    public static void enableInstances(Logger log, String msg, Level level) {
        if (log == null) {
            log = Logger.getLogger("TIMER");
        }
        log.addHandler(new InstancesHandler(msg, level));
        if (log.getLevel() == null || log.getLevel().intValue() > level.intValue()) {
            log.setLevel(level);
        }
    }

    public static void assertInstances(String msg) {
        InstancesHandler.assertGC(msg, new String[0]);
    }

    public static void assertInstances(String msg, String ... names) {
        InstancesHandler.assertGC(msg, names);
    }

    static void configure(Level lev, String root, NbTestCase current) {
        IL il = new IL(false);
        String c = "handlers=" + Log.class.getName() + "\n" + root + ".level=" + lev.intValue() + "\n";
        ByteArrayInputStream is = new ByteArrayInputStream(c.getBytes());
        try {
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Log.current = current;
        messages.setLength(0);
        messages.append("Starting test ");
        messages.append(current.getName());
        messages.append('\n');
        initialMessages = messages.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream getLog() {
        if (this.log != null) {
            PrintStream ps = this.log.get();
            if (ps == null) {
                this.setLevel(Level.OFF);
                this.logger.removeHandler(this);
            }
            return ps;
        }
        NbTestCase c = current;
        Runnable off = Log.internalLog();
        try {
            PrintStream printStream = c == null ? System.err : c.getLog();
            return printStream;
        }
        finally {
            off.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        if (IL.isInternalLog()) {
            return;
        }
        Runnable off = Log.internalLog();
        try {
            StringBuffer sb = NbModuleLogHandler.toString(record);
            PrintStream ps = this.getLog();
            if (ps != null) {
                try {
                    ps.println(sb.toString());
                }
                catch (LinkageError err) {
                    // empty catch block
                }
            }
            if (messages.length() + sb.length() > 20000) {
                if (sb.length() > 20000) {
                    messages.setLength(0);
                    sb.delete(0, sb.length() - 20000);
                } else {
                    messages.setLength(20000 - sb.length());
                }
            }
            messages.append(sb.toString());
        }
        finally {
            off.run();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        Logger l = this.logger;
        if (this.getLevel() != Level.OFF && l != null) {
            l.addHandler(this);
        }
    }

    static String normalizedMessages(String workDirPath) {
        if (messages.length() == initialMessages) {
            return null;
        }
        return NbModuleLogHandler.normalize(messages, workDirPath);
    }

    static Throwable wrapWithMessages(Throwable ex, String workDirPath) {
        String m = Log.normalizedMessages(workDirPath);
        if (m == null) {
            return ex;
        }
        return Log.wrapWithAddendum(ex, "Log:\n" + m, true);
    }

    static Throwable wrapWithAddendum(Throwable ex, String addendum, boolean after) {
        if (ex instanceof AssertionFailedError) {
            AssertionFailedError ne = new AssertionFailedError(Log.combineMessages(ex, addendum, after));
            if (ex.getCause() != null) {
                ne.initCause(ex.getCause());
            }
            ne.setStackTrace(ex.getStackTrace());
            return ne;
        }
        if (ex instanceof AssertionError) {
            AssertionError ne = new AssertionError((Object)Log.combineMessages(ex, addendum, after));
            if (ex.getCause() != null) {
                ((Throwable)((Object)ne)).initCause(ex.getCause());
            }
            ((Throwable)((Object)ne)).setStackTrace(ex.getStackTrace());
            return ne;
        }
        if (ex instanceof IOException) {
            IOException ne = new IOException(Log.combineMessages(ex, addendum, after));
            if (ex.getCause() != null) {
                ne.initCause(ex.getCause());
            }
            ne.setStackTrace(ex.getStackTrace());
            return ne;
        }
        if (ex instanceof Exception) {
            return new InvocationTargetException(ex, Log.combineMessages(ex, addendum, after));
        }
        return ex;
    }

    private static String combineMessages(Throwable ex, String addendum, boolean after) {
        String baseMessage = ex.getMessage();
        return baseMessage == null || baseMessage.equals("null") ? addendum : (after ? baseMessage + " " + addendum : addendum + " " + baseMessage);
    }

    static {
        messages = new StringBuffer();
    }

    private static class IL
    implements Runnable {
        private static ThreadLocal<Boolean> INTERNAL_LOG = new ThreadLocal();
        private final Boolean prev = INTERNAL_LOG.get();

        public IL(boolean on) {
            INTERNAL_LOG.set(on);
        }

        @Override
        public void run() {
            INTERNAL_LOG.set(this.prev);
        }

        public static boolean isInternalLog() {
            return Boolean.TRUE.equals(INTERNAL_LOG.get());
        }
    }

    private static class InstancesHandler
    extends Handler {
        static final Map<Object, String> instances = Collections.synchronizedMap(new WeakHashMap());
        static int cnt;
        private final String msg;

        public InstancesHandler(String msg, Level level) {
            this.setLevel(level);
            this.msg = msg;
        }

        @Override
        public void publish(LogRecord record) {
            Object[] param = record.getParameters();
            if (param == null) {
                return;
            }
            if (this.msg != null && !this.msg.equals(record.getMessage())) {
                return;
            }
            ++cnt;
            for (Object o : param) {
                instances.put(o, record.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void assertGC(String msg, String ... names) {
            AssertionFailedError t = null;
            ArrayList<WeakReference<Object>> refs = new ArrayList<WeakReference<Object>>();
            ArrayList<String> txts = new ArrayList<String>();
            int count = 0;
            HashSet<String> nameSet = names == null || names.length == 0 ? null : new HashSet<String>(Arrays.asList(names));
            Map<Object, String> map = instances;
            synchronized (map) {
                Iterator<Map.Entry<Object, String>> it = instances.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, String> entry = it.next();
                    if (nameSet != null && !nameSet.contains(entry.getValue())) continue;
                    refs.add(new WeakReference<Object>(entry.getKey()));
                    txts.add(entry.getValue());
                    it.remove();
                    ++count;
                }
            }
            if (count == 0) {
                Assert.fail((String)"No instance of this type reported");
            }
            for (int i = 0; i < count; ++i) {
                Reference r = (Reference)refs.get(i);
                try {
                    NbTestCase.assertGC(msg + " " + (String)txts.get(i), r);
                    continue;
                }
                catch (AssertionFailedError ex) {
                    if (t == null) {
                        t = ex;
                        continue;
                    }
                    Throwable last = t;
                    while (last.getCause() != null) {
                        last = last.getCause();
                    }
                    last.initCause(ex);
                }
            }
            if (t != null) {
                throw t;
            }
        }
    }
}

