/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.LangOptions;
import org.clang.basic.SrcMgr;
import org.clang.frontend.impl.InitHeaderSearchStatics;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.HeaderMap;
import org.clang.lex.HeaderSearch;
import org.clang.lex.HeaderSearchOptions;
import org.clang.lex.frontend;
import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class InitHeaderSearch
implements Destructors.ClassWithDestructor {
    public static final StringRef C_INCLUDE_DIRS = new StringRef((CharSequence)System.getProperty("C_INCLUDE_DIRS", ""));
    private std.vector<std.pair<frontend.IncludeDirGroup, DirectoryLookup>> IncludePath = new std.vector((Object)new std.pair((Object)frontend.IncludeDirGroup.Quoted, (Object)new DirectoryLookup()));
    private std.vector<std.pairTypeBool<std.string>> SystemHeaderPrefixes = new std.vector((Object)new std.pairTypeBool((Object)std.string.EMPTY, false));
    private HeaderSearch Headers;
    private boolean Verbose;
    private std.string IncludeSysroot;
    private boolean HasSysroot;

    public InitHeaderSearch(HeaderSearch HS, boolean verbose, StringRef sysroot) {
        this.Headers = HS;
        this.Verbose = verbose;
        this.IncludeSysroot = new std.string(sysroot.$basic_string());
        this.HasSysroot = !sysroot.empty() && !llvm.$eq_StringRef((StringRef)sysroot, (CharSequence)"/");
    }

    public void AddPath(Twine Path, frontend.IncludeDirGroup Group, boolean isFramework) {
        SmallString MappedPathStorage;
        StringRef MappedPathStr;
        if (this.HasSysroot && InitHeaderSearchStatics.CanPrefixSysroot(MappedPathStr = Path.toStringRef(MappedPathStorage = new SmallString(256)))) {
            this.AddUnmappedPath(llvm.$plus_Twine((Twine)new Twine(this.IncludeSysroot), (Twine)Path), Group, isFramework);
            return;
        }
        this.AddUnmappedPath(Path, Group, isFramework);
    }

    public void AddUnmappedPath(Twine Path, frontend.IncludeDirGroup Group, boolean isFramework) {
        HeaderMap HM;
        FileEntry FE;
        assert (!Path.isTriviallyEmpty()) : "can't handle empty path here";
        FileManager FM = this.Headers.getFileMgr();
        SmallString MappedPathStorage = new SmallString(256);
        StringRef MappedPathStr = Path.toStringRef(MappedPathStorage);
        SrcMgr.CharacteristicKind Type2 = Group == frontend.IncludeDirGroup.Quoted || Group == frontend.IncludeDirGroup.Angled || Group == frontend.IncludeDirGroup.IndexHeaderMap ? SrcMgr.CharacteristicKind.C_User : (Group == frontend.IncludeDirGroup.ExternCSystem ? SrcMgr.CharacteristicKind.C_ExternCSystem : SrcMgr.CharacteristicKind.C_System);
        DirectoryEntry DE = FM.getDirectory(MappedPathStr);
        if (DE != null) {
            this.IncludePath.push_back((Object)std.make_pair((Object)Group, (Object)new DirectoryLookup(DE, Type2, isFramework)));
            return;
        }
        if (!isFramework && (FE = FM.getFile(MappedPathStr)) != null && (HM = this.Headers.CreateHeaderMap(FE)) != null) {
            this.IncludePath.push_back((Object)std.make_pair((Object)Group, (Object)new DirectoryLookup(HM, Type2, Group == frontend.IncludeDirGroup.IndexHeaderMap)));
            return;
        }
        if (this.Verbose) {
            llvm.errs().$out((CharSequence)"ignoring nonexistent directory \"").$out(MappedPathStr).$out((CharSequence)"\"\n");
        }
    }

    public void AddSystemHeaderPrefix(StringRef Prefix, boolean IsSystemHeader) {
        this.SystemHeaderPrefixes.push_back((Object)std.make_pair((Object)Prefix.str(), (boolean)IsSystemHeader));
    }

    public void AddGnuCPlusPlusIncludePaths(StringRef Base, StringRef ArchDir, StringRef Dir32, StringRef Dir64, Triple triple) {
        boolean is64bit;
        this.AddPath(new Twine(Base), frontend.IncludeDirGroup.CXXSystem, false);
        Triple.ArchType arch = triple.getArch();
        boolean bl = is64bit = arch == Triple.ArchType.ppc64 || arch == Triple.ArchType.x86_64;
        if (is64bit) {
            this.AddPath(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/"), (Twine)new Twine(ArchDir)), (Twine)new Twine((CharSequence)"/")), (Twine)new Twine(Dir64)), frontend.IncludeDirGroup.CXXSystem, false);
        } else {
            this.AddPath(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/"), (Twine)new Twine(ArchDir)), (Twine)new Twine((CharSequence)"/")), (Twine)new Twine(Dir32)), frontend.IncludeDirGroup.CXXSystem, false);
        }
        this.AddPath(llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/backward"), frontend.IncludeDirGroup.CXXSystem, false);
    }

    public void AddMinGWCPlusPlusIncludePaths(StringRef Base, StringRef Arch, StringRef Version) {
        this.AddPath(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/"), (Twine)new Twine(Arch)), (Twine)new Twine((CharSequence)"/")), (Twine)new Twine(Version)), (Twine)new Twine((CharSequence)"/include/c++")), frontend.IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/"), (Twine)new Twine(Arch)), (Twine)new Twine((CharSequence)"/")), (Twine)new Twine(Version)), (Twine)new Twine((CharSequence)"/include/c++/")), (Twine)new Twine(Arch)), frontend.IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/"), (Twine)new Twine(Arch)), (Twine)new Twine((CharSequence)"/")), (Twine)new Twine(Version)), (Twine)new Twine((CharSequence)"/include/c++/backward")), frontend.IncludeDirGroup.CXXSystem, false);
    }

    public void AddMinGW64CXXPaths(StringRef Base, StringRef Version) {
        this.AddPath(llvm.$plus_Twine((Twine)llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/../../../include/c++/"), (Twine)new Twine(Version)), frontend.IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/../../../include/c++/"), (Twine)new Twine(Version)), (Twine)new Twine((CharSequence)"/x86_64-w64-mingw32")), frontend.IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/../../../include/c++/"), (Twine)new Twine(Version)), (Twine)new Twine((CharSequence)"/i686-w64-mingw32")), frontend.IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_T((StringRef)Base, (CharSequence)"/../../../include/c++/"), (Twine)new Twine(Version)), (Twine)new Twine((CharSequence)"/backward")), frontend.IncludeDirGroup.CXXSystem, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AddDefaultCIncludePaths(Triple triple, HeaderSearchOptions HSOpts) {
        Triple.OSType os = triple.getOS();
        if (HSOpts.UseStandardSystemIncludes) {
            switch (os) {
                case FreeBSD: 
                case NetBSD: 
                case OpenBSD: 
                case Bitrig: {
                    break;
                }
                default: {
                    this.AddPath(new Twine(NativePointer.$((String)"/usr/local/include")), frontend.IncludeDirGroup.System, false);
                }
            }
        }
        if (HSOpts.UseBuiltinIncludes) {
            SmallString P = null;
            try {
                P = new SmallString(new StringRef(HSOpts.ResourceDir), 128);
                path.append((SmallString)P, (char.ptr)NativePointer.$((String)"include"));
                this.AddUnmappedPath(new Twine(P.str()), frontend.IncludeDirGroup.ExternCSystem, false);
            }
            finally {
                if (P != null) {
                    P.$destroy();
                }
            }
        }
        if (!HSOpts.UseStandardSystemIncludes) {
            return;
        }
        StringRef CIncludeDirs = StringRef.EMPTY;
        if (llvm.$noteq_StringRef((StringRef)CIncludeDirs, (StringRef)StringRef.EMPTY)) {
            SmallVector dirs = null;
            try {
                dirs = new SmallVector(5, (Object)new StringRef());
                CIncludeDirs.split((SmallVectorImpl)dirs, new StringRef(NativePointer.$((String)":")));
                SmallVectorImpl.iterator i = dirs.begin();
                while (i.$noteq((Object)dirs.end())) {
                    this.AddPath(new Twine((StringRef)i.$star()), frontend.IncludeDirGroup.ExternCSystem, false);
                    i.$preInc();
                }
                return;
            }
            finally {
                if (dirs != null) {
                    dirs.$destroy();
                }
            }
        }
        block5 : switch (os) {
            case Linux: {
                throw new llvm_unreachable((CharSequence)"Include management is handled in the driver.");
            }
            case Haiku: {
                this.AddPath(new Twine(NativePointer.$((String)"/boot/common/include")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/app")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/arch")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/device")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/drivers")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/game")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/interface")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/kernel")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/locale")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/mail")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/media")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/midi")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/midi2")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/net")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/storage")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/support")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/translation")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/add-ons/graphics")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/add-ons/input_server")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/add-ons/screen_saver")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/add-ons/tracker")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/be_apps/Deskbar")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/be_apps/NetPositive")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/be_apps/Tracker")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/cpp")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/cpp/i586-pc-haiku")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/3rdparty")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/bsd")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/glibc")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/posix")), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers")), frontend.IncludeDirGroup.System, false);
                break;
            }
            case RTEMS: {
                break;
            }
            case Win32: {
                switch (triple.getEnvironment()) {
                    default: {
                        throw new llvm_unreachable((CharSequence)"Include management is handled in the driver.");
                    }
                    case Cygnus: {
                        this.AddPath(new Twine(NativePointer.$((String)"/usr/include/w32api")), frontend.IncludeDirGroup.System, false);
                        break block5;
                    }
                    case GNU: 
                }
                SmallString P = new SmallString(new StringRef(HSOpts.ResourceDir), 128);
                path.append((SmallString)P, (char.ptr)NativePointer.$((String)"../../../i686-w64-mingw32/include"));
                this.AddPath(new Twine(P.str()), frontend.IncludeDirGroup.System, false);
                P.resize(HSOpts.ResourceDir.size());
                path.append((SmallString)P, (char.ptr)NativePointer.$((String)"../../../x86_64-w64-mingw32/include"));
                this.AddPath(new Twine(P.str()), frontend.IncludeDirGroup.System, false);
                P.resize(HSOpts.ResourceDir.size());
                path.append((SmallString)P, (char.ptr)NativePointer.$((String)"../../../include"));
                this.AddPath(new Twine(P.str()), frontend.IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/mingw/include")), frontend.IncludeDirGroup.System, false);
                break;
            }
        }
        if (os != Triple.OSType.RTEMS) {
            this.AddPath(new Twine(NativePointer.$((String)"/usr/include")), frontend.IncludeDirGroup.ExternCSystem, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void AddDefaultCPlusPlusIncludePaths(Triple triple, HeaderSearchOptions HSOpts) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            Triple.OSType os = triple.getOS();
            if (triple.isOSDarwin()) {
                switch (triple.getArch()) {
                    default: {
                        return;
                    }
                    case ppc: 
                    case ppc64: {
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"powerpc-apple-darwin10")), StringRef.EMPTY, new StringRef(NativePointer.$((String)"ppc64")), triple);
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.0.0")), new StringRef(NativePointer.$((String)"powerpc-apple-darwin10")), StringRef.EMPTY, new StringRef(NativePointer.$((String)"ppc64")), triple);
                        return;
                    }
                    case x86: 
                    case x86_64: {
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"i686-apple-darwin10")), StringRef.EMPTY, new StringRef(NativePointer.$((String)"x86_64")), triple);
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.0.0")), new StringRef(NativePointer.$((String)"i686-apple-darwin8")), StringRef.EMPTY, StringRef.EMPTY, triple);
                        return;
                    }
                    case arm: 
                    case thumb: {
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"arm-apple-darwin10")), new StringRef(NativePointer.$((String)"v7")), StringRef.EMPTY, triple);
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"arm-apple-darwin10")), new StringRef(NativePointer.$((String)"v6")), StringRef.EMPTY, triple);
                        return;
                    }
                    case aarch64: 
                }
                this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"arm64-apple-darwin10")), StringRef.EMPTY, StringRef.EMPTY, triple);
                return;
            }
            switch (os) {
                case Linux: {
                    throw new llvm_unreachable((CharSequence)"Include management is handled in the driver.");
                }
                case Win32: {
                    switch (triple.getEnvironment()) {
                        default: {
                            throw new llvm_unreachable((CharSequence)"Include management is handled in the driver.");
                        }
                        case Cygnus: {
                            this.AddMinGWCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/lib/gcc")), new StringRef(NativePointer.$((String)"i686-pc-cygwin")), new StringRef(NativePointer.$((String)"4.7.3")));
                            this.AddMinGWCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/lib/gcc")), new StringRef(NativePointer.$((String)"i686-pc-cygwin")), new StringRef(NativePointer.$((String)"4.5.3")));
                            this.AddMinGWCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/lib/gcc")), new StringRef(NativePointer.$((String)"i686-pc-cygwin")), new StringRef(NativePointer.$((String)"4.3.4")));
                            this.AddMinGWCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/lib/gcc")), new StringRef(NativePointer.$((String)"i686-pc-cygwin")), new StringRef(NativePointer.$((String)"4.3.2")));
                            break;
                        }
                        case GNU: {
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.7.0")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.7.1")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.7.2")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.7.3")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.8.0")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.8.1")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.8.2")));
                        }
                    }
                }
                case DragonFly: {
                    if (fs.exists((Twine)new Twine(NativePointer.$((String)"/usr/lib/gcc47")))) {
                        this.AddPath(new Twine(NativePointer.$((String)"/usr/include/c++/4.7")), frontend.IncludeDirGroup.CXXSystem, false);
                        return;
                    }
                    this.AddPath(new Twine(NativePointer.$((String)"/usr/include/c++/4.4")), frontend.IncludeDirGroup.CXXSystem, false);
                    return;
                }
                case OpenBSD: {
                    std.string t = new std.string(triple.getTriple());
                    if ($c.clean(std.$eq_str_T((std.string)((std.string)$c.track((Object)t.substr(0, 6))), (char.iterator)NativePointer.$((String)"x86_64")))) {
                        t.replace(0, 6, NativePointer.$((String)"amd64"));
                    }
                    this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/g++")), new StringRef(t), StringRef.EMPTY, StringRef.EMPTY, triple);
                    return;
                }
                case Minix: {
                    this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/gnu/include/c++/4.4.3")), StringRef.EMPTY, StringRef.EMPTY, StringRef.EMPTY, triple);
                    return;
                }
                case Solaris: {
                    this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/gcc/4.5/include/c++/4.5.2/")), new StringRef(NativePointer.$((String)"i386-pc-solaris2.11")), StringRef.EMPTY, StringRef.EMPTY, triple);
                    return;
                }
            }
            return;
        }
        finally {
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AddDefaultIncludePaths(LangOptions Lang, Triple triple, HeaderSearchOptions HSOpts) {
        switch (triple.getOS()) {
            default: {
                break;
            }
            case Linux: {
                return;
            }
            case Win32: {
                if (triple.getEnvironment() != Triple.EnvironmentType.MSVC && triple.getEnvironment() != Triple.EnvironmentType.Itanium && !triple.isOSBinFormatMachO()) break;
                return;
            }
        }
        if (Lang.CPlusPlus && HSOpts.UseStandardCXXIncludes && HSOpts.UseStandardSystemIncludes) {
            if (HSOpts.UseLibcxx) {
                if (triple.isOSDarwin() && !HSOpts.ResourceDir.empty()) {
                    SmallString P = null;
                    try {
                        StringRef NoVer = path.parent_path((StringRef)new StringRef(HSOpts.ResourceDir));
                        StringRef Lib = path.parent_path((StringRef)new StringRef(NoVer));
                        P = new SmallString(path.parent_path((StringRef)new StringRef(Lib)), 128);
                        path.append((SmallString)P, (char.ptr)NativePointer.$((String)"include"), (char.ptr)NativePointer.$((String)"c++"), (char.ptr)NativePointer.$((String)"v1"));
                        this.AddUnmappedPath(new Twine(P.str()), frontend.IncludeDirGroup.CXXSystem, false);
                    }
                    finally {
                        if (P != null) {
                            P.$destroy();
                        }
                    }
                }
                if (triple.getOS() == Triple.OSType.Solaris) {
                    this.AddPath(new Twine(NativePointer.$((String)"/usr/include/c++/v1/support/solaris")), frontend.IncludeDirGroup.CXXSystem, false);
                }
                this.AddPath(new Twine(NativePointer.$((String)"/usr/include/c++/v1")), frontend.IncludeDirGroup.CXXSystem, false);
            } else {
                this.AddDefaultCPlusPlusIncludePaths(triple, HSOpts);
            }
        }
        this.AddDefaultCIncludePaths(triple, HSOpts);
        if (HSOpts.UseStandardSystemIncludes && triple.isOSDarwin()) {
            this.AddPath(new Twine(NativePointer.$((String)"/System/Library/Frameworks")), frontend.IncludeDirGroup.System, true);
            this.AddPath(new Twine(NativePointer.$((String)"/Library/Frameworks")), frontend.IncludeDirGroup.System, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Realize(LangOptions Lang) {
        std.vector SearchList = null;
        try {
            SearchList = new std.vector((Object)new DirectoryLookup());
            SearchList.reserve(this.IncludePath.size());
            StdVector.iterator it = (StdVector.iterator)Native.$tryClone((NativeCloneable)this.IncludePath.begin());
            StdVector.iterator ie = this.IncludePath.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)it, (StdVector.iterator)ie)) {
                if (((std.pair)it.$arrow()).first == frontend.IncludeDirGroup.Quoted) {
                    SearchList.push_back(((std.pair)it.$arrow()).second);
                }
                it.$preInc();
            }
            InitHeaderSearchStatics.RemoveDuplicates((std.vector<DirectoryLookup>)SearchList, 0L, this.Verbose);
            int NumQuoted = SearchList.size();
            StdVector.iterator it2 = (StdVector.iterator)Native.$tryClone((NativeCloneable)this.IncludePath.begin());
            StdVector.iterator ie2 = this.IncludePath.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)it2, (StdVector.iterator)ie2)) {
                if (((std.pair)it2.$arrow()).first == frontend.IncludeDirGroup.Angled || ((std.pair)it2.$arrow()).first == frontend.IncludeDirGroup.IndexHeaderMap) {
                    SearchList.push_back(((std.pair)it2.$arrow()).second);
                }
                it2.$preInc();
            }
            InitHeaderSearchStatics.RemoveDuplicates((std.vector<DirectoryLookup>)SearchList, NumQuoted, this.Verbose);
            int NumAngled = SearchList.size();
            StdVector.iterator it3 = (StdVector.iterator)Native.$tryClone((NativeCloneable)this.IncludePath.begin());
            StdVector.iterator ie3 = this.IncludePath.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)it3, (StdVector.iterator)ie3)) {
                if (((std.pair)it3.$arrow()).first == frontend.IncludeDirGroup.System || ((std.pair)it3.$arrow()).first == frontend.IncludeDirGroup.ExternCSystem || !Lang.ObjC1 && !Lang.CPlusPlus && ((std.pair)it3.$arrow()).first == frontend.IncludeDirGroup.CSystem || Lang.CPlusPlus && ((std.pair)it3.$arrow()).first == frontend.IncludeDirGroup.CXXSystem || Lang.ObjC1 && !Lang.CPlusPlus && ((std.pair)it3.$arrow()).first == frontend.IncludeDirGroup.ObjCSystem || Lang.ObjC1 && Lang.CPlusPlus && ((std.pair)it3.$arrow()).first == frontend.IncludeDirGroup.ObjCXXSystem) {
                    SearchList.push_back(((std.pair)it3.$arrow()).second);
                }
                it3.$preInc();
            }
            it3 = (StdVector.iterator)Native.$tryClone((NativeCloneable)this.IncludePath.begin());
            ie3 = this.IncludePath.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)it3, (StdVector.iterator)ie3)) {
                if (((std.pair)it3.$arrow()).first == frontend.IncludeDirGroup.After) {
                    SearchList.push_back(((std.pair)it3.$arrow()).second);
                }
                it3.$preInc();
            }
            long NonSystemRemoved = InitHeaderSearchStatics.RemoveDuplicates((std.vector<DirectoryLookup>)SearchList, NumQuoted, this.Verbose);
            NumAngled = (int)((long)NumAngled - NonSystemRemoved);
            boolean DontSearchCurDir = false;
            this.Headers.SetSearchPaths(SearchList, NumQuoted, NumAngled, DontSearchCurDir);
            this.Headers.SetSystemHeaderPrefixes(new ArrayRef(this.SystemHeaderPrefixes));
            if (this.Verbose) {
                llvm.errs().$out((CharSequence)"#include \"...\" search starts here:\n");
                long e = SearchList.size();
                for (long i = 0L; i != e; ++i) {
                    String Suffix;
                    if (i == (long)NumQuoted) {
                        llvm.errs().$out((CharSequence)"#include <...> search starts here:\n");
                    }
                    char.ptr Name = Native.$tryClone((char.ptr)((DirectoryLookup)SearchList.$at(i)).getName());
                    if (((DirectoryLookup)SearchList.$at(i)).isNormalDir()) {
                        Suffix = "";
                    } else if (((DirectoryLookup)SearchList.$at(i)).isFramework()) {
                        Suffix = " (framework directory)";
                    } else {
                        assert (((DirectoryLookup)SearchList.$at(i)).isHeaderMap()) : "Unknown DirectoryLookup";
                        Suffix = " (headermap)";
                    }
                    llvm.errs().$out((CharSequence)" ").$out(Name).$out((CharSequence)Suffix).$out((CharSequence)"\n");
                }
                llvm.errs().$out((CharSequence)"End of search list.\n");
            }
        }
        finally {
            if (SearchList != null) {
                SearchList.$destroy();
            }
        }
    }

    public void $destroy() {
    }
}

