/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.SrcMgr;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.HeaderMap;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoObject;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;

public final class InitHeaderSearchStatics {
    public static boolean CanPrefixSysroot(StringRef Path) {
        return path.is_absolute((StringRef)Path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long RemoveDuplicates(std.vector<DirectoryLookup> SearchList, long First, boolean Verbose) {
        SmallPtrSet SeenDirs = null;
        SmallPtrSet SeenFrameworkDirs = null;
        SmallPtrSet SeenHeaderMaps = null;
        try {
            SeenDirs = new SmallPtrSet((DenseMapInfo)new DenseMapInfoObject((Object)new DirectoryEntry(), (Object)new DirectoryEntry()), 8);
            SeenFrameworkDirs = new SmallPtrSet((DenseMapInfo)new DenseMapInfoObject((Object)new DirectoryEntry(), (Object)new DirectoryEntry()), 8);
            SeenHeaderMaps = new SmallPtrSet((DenseMapInfo)new DenseMapInfoObject((Object)new HeaderMap(), (Object)new HeaderMap()), 8);
            long NonSystemRemoved = 0L;
            for (long i = First; i != (long)SearchList.size(); ++i) {
                long DirToRemove = i;
                DirectoryLookup CurEntry = (DirectoryLookup)SearchList.$at(i);
                if (CurEntry.isNormalDir()) {
                    if (SeenDirs.insert((Object)CurEntry.getDir())) {
                        continue;
                    }
                } else if (CurEntry.isFramework()) {
                    if (SeenFrameworkDirs.insert((Object)CurEntry.getFrameworkDir())) {
                        continue;
                    }
                } else {
                    assert (CurEntry.isHeaderMap()) : "Not a headermap or normal dir?";
                    if (SeenHeaderMaps.insert((Object)CurEntry.getHeaderMap())) continue;
                }
                if (CurEntry.getDirCharacteristic() != SrcMgr.CharacteristicKind.C_User) {
                    long FirstDir = 0L;
                    while (true) {
                        assert (FirstDir != i) : "Didn't find dupe?";
                        DirectoryLookup SearchEntry = (DirectoryLookup)SearchList.$at(FirstDir);
                        if (SearchEntry.getLookupType() == CurEntry.getLookupType()) {
                            boolean isSame;
                            if (CurEntry.isNormalDir()) {
                                isSame = SearchEntry.getDir() == CurEntry.getDir();
                            } else if (CurEntry.isFramework()) {
                                isSame = SearchEntry.getFrameworkDir() == CurEntry.getFrameworkDir();
                            } else {
                                assert (CurEntry.isHeaderMap()) : "Not a headermap or normal dir?";
                                boolean bl = isSame = SearchEntry.getHeaderMap() == CurEntry.getHeaderMap();
                            }
                            if (isSame) break;
                        }
                        ++FirstDir;
                    }
                    if (((DirectoryLookup)SearchList.$at(FirstDir)).getDirCharacteristic() == SrcMgr.CharacteristicKind.C_User) {
                        DirToRemove = FirstDir;
                    }
                }
                if (Verbose) {
                    llvm.errs().$out(NativePointer.$((String)"ignoring duplicate directory \"")).$out(CurEntry.getName()).$out(NativePointer.$((String)"\"\n"));
                    if (DirToRemove != i) {
                        llvm.errs().$out(NativePointer.$((String)"  as it is a non-system directory that duplicates ")).$out(NativePointer.$((String)"a system directory\n"));
                    }
                }
                if (DirToRemove != i) {
                    ++NonSystemRemoved;
                }
                SearchList.erase(SearchList.begin().$add(DirToRemove));
                --i;
            }
            long l = NonSystemRemoved;
            return l;
        }
        finally {
            if (SeenHeaderMaps != null) {
                SeenHeaderMaps.$destroy();
            }
            if (SeenFrameworkDirs != null) {
                SeenFrameworkDirs.$destroy();
            }
            if (SeenDirs != null) {
                SeenDirs.$destroy();
            }
        }
    }
}

