/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.CharSourceRange;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.Module;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.basic.diag;
import org.clang.frontend.impl.PrintPPOutputHelper;
import org.clang.frontend.impl.PrintPreprocessedOutputStatics;
import org.clang.lex.MacroDirective;
import org.clang.lex.MacroInfo;
import org.clang.lex.PPCallbacks;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.TokenConcatenation;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRefInt;
import org.llvm.support.raw_ostream;

public final class PrintPPOutputPPCallbacks
extends PPCallbacks
implements Destructors.ClassWithDestructor {
    private final Preprocessor PP;
    private final SourceManager SM;
    private final TokenConcatenation ConcatInfo;
    public raw_ostream OS;
    private long CurLine;
    private boolean EmittedTokensOnThisLine;
    private boolean EmittedDirectiveOnThisLine;
    private SrcMgr.CharacteristicKind FileType;
    private final SmallString CurFilename;
    private boolean Initialized;
    private final boolean DisableLineMarkers;
    private final boolean DumpDefines;
    private final boolean UseLineDirective;
    private boolean IsFirstFileEntered;
    private final PrintPPOutputHelper $PrintPPOutputHelper = new PrintPPOutputHelper();
    private boolean PrintPPOutputHelperInUse = false;

    public PrintPPOutputPPCallbacks(Preprocessor pp, raw_ostream os, boolean lineMarkers, boolean defines) {
        this.PP = pp;
        this.SM = this.PP.getSourceManager();
        this.ConcatInfo = new TokenConcatenation(this.PP);
        this.OS = os;
        this.CurFilename = new SmallString(512);
        this.DisableLineMarkers = lineMarkers;
        this.DumpDefines = defines;
        this.CurLine = 0L;
        this.CurFilename.$addassign((CharSequence)"<uninit>");
        this.EmittedTokensOnThisLine = false;
        this.EmittedDirectiveOnThisLine = false;
        this.FileType = SrcMgr.CharacteristicKind.C_User;
        this.Initialized = false;
        this.IsFirstFileEntered = false;
        this.UseLineDirective = this.PP.getLangOpts().MicrosoftExt;
    }

    public void setEmittedTokensOnThisLine() {
        this.EmittedTokensOnThisLine = true;
    }

    public boolean hasEmittedTokensOnThisLine() {
        return this.EmittedTokensOnThisLine;
    }

    public void setEmittedDirectiveOnThisLine() {
        this.EmittedDirectiveOnThisLine = true;
    }

    public boolean hasEmittedDirectiveOnThisLine() {
        return this.EmittedDirectiveOnThisLine;
    }

    public boolean startNewLineIfNeeded() {
        return this.startNewLineIfNeeded(true);
    }

    public boolean startNewLineIfNeeded(boolean ShouldUpdateCurrentLine) {
        if (this.EmittedTokensOnThisLine || this.EmittedDirectiveOnThisLine) {
            this.OS.$out('\n');
            this.EmittedTokensOnThisLine = false;
            this.EmittedDirectiveOnThisLine = false;
            if (ShouldUpdateCurrentLine) {
                ++this.CurLine;
            }
            return true;
        }
        return false;
    }

    public void FileChanged(SourceLocation Loc, PPCallbacks.FileChangeReason Reason, SrcMgr.CharacteristicKind NewFileType, FileID PrevFID) {
        SourceManager SourceMgr = this.SM;
        PresumedLoc UserLoc = SourceMgr.getPresumedLoc(new SourceLocation(Loc));
        if (UserLoc.isInvalid()) {
            return;
        }
        long NewLine = UserLoc.getLine();
        if (Reason == PPCallbacks.FileChangeReason.EnterFile) {
            int IncludeLoc = UserLoc.getRawIncludeLoc();
            if (SourceLocation.isValid((int)IncludeLoc)) {
                this.MoveToLine(IncludeLoc);
            }
        } else if (Reason == PPCallbacks.FileChangeReason.SystemHeaderPragma) {
            ++NewLine;
        }
        this.CurLine = NewLine;
        this.CurFilename.clear();
        this.CurFilename.$addassign(UserLoc.getFilename());
        this.FileType = NewFileType;
        if (this.DisableLineMarkers) {
            this.startNewLineIfNeeded(false);
            return;
        }
        if (!this.Initialized) {
            this.WriteLineInfo(this.CurLine);
            this.Initialized = true;
        }
        if (Reason == PPCallbacks.FileChangeReason.EnterFile && !this.IsFirstFileEntered) {
            this.IsFirstFileEntered = true;
            return;
        }
        switch (Reason) {
            case EnterFile: {
                this.WriteLineInfo(this.CurLine, NativePointer.$((String)" 1"), 2L);
                break;
            }
            case ExitFile: {
                this.WriteLineInfo(this.CurLine, NativePointer.$((String)" 2"), 2L);
                break;
            }
            case SystemHeaderPragma: 
            case RenameFile: {
                this.WriteLineInfo(this.CurLine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void InclusionDirective(SourceLocation HashLoc, Token IncludeTok, StringRef FileName, boolean IsAngled, CharSourceRange FilenameRange, FileEntry File, StringRef SearchPath, StringRef RelativePath, Module Imported) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            if (Imported != null) {
                this.startNewLineIfNeeded();
                this.MoveToLine(new SourceLocation(HashLoc));
                $c.clean((Object)this.OS.$out(NativePointer.$((String)"@import ")).$out((std.string)$c.track((Object)Imported.getFullModuleName())).$out(NativePointer.$((String)";")).$out(NativePointer.$((String)" /* clang -E: implicit import for \"")).$out(File.getName()).$out(NativePointer.$((String)"\" */")));
                this.EmittedTokensOnThisLine = true;
                this.startNewLineIfNeeded();
            }
        }
        finally {
            $c.$destroy();
        }
    }

    public void Ident(SourceLocation Loc, std.string S) {
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.write(NativePointer.$((String)"#ident "), (long)std.strlen((char.ptr)NativePointer.$((String)"#ident ")));
        this.OS.write(S.data(), (long)S.size());
        this.EmittedTokensOnThisLine = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PragmaMessage(SourceLocation Loc, StringRef Namespace, PPCallbacks.PragmaMessageKind Kind2, StringRef Str) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            this.startNewLineIfNeeded();
            this.MoveToLine(new SourceLocation(Loc));
            this.OS.$out(NativePointer.$((String)"#pragma "));
            if (!Namespace.empty()) {
                this.OS.$out(new StringRef(Namespace)).$out_char(NativePointer.$((char)' '));
            }
            switch (Kind2) {
                case PMK_Message: {
                    this.OS.$out(NativePointer.$((String)"message(\""));
                    break;
                }
                case PMK_Warning: {
                    this.OS.$out(NativePointer.$((String)"warning \""));
                    break;
                }
                case PMK_Error: {
                    this.OS.$out(NativePointer.$((String)"error \""));
                }
            }
            PrintPreprocessedOutputStatics.outputPrintable(this.OS, (std.string)$c.track((Object)Str.$basic_string()));
            $c.clean();
            this.OS.$out_char(NativePointer.$((char)'\"'));
            if (Kind2 == PPCallbacks.PragmaMessageKind.PMK_Message) {
                this.OS.$out_char(NativePointer.$((char)')'));
            }
            this.setEmittedDirectiveOnThisLine();
        }
        finally {
            $c.$destroy();
        }
    }

    public void PragmaDebug(SourceLocation Loc, StringRef DebugType) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out(NativePointer.$((String)"#pragma clang __debug "));
        this.OS.$out(new StringRef(DebugType));
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaDiagnosticPush(SourceLocation Loc, StringRef Namespace) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out(NativePointer.$((String)"#pragma ")).$out(new StringRef(Namespace)).$out(NativePointer.$((String)" diagnostic push"));
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaDiagnosticPop(SourceLocation Loc, StringRef Namespace) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out(NativePointer.$((String)"#pragma ")).$out(new StringRef(Namespace)).$out(NativePointer.$((String)" diagnostic pop"));
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaDiagnostic(SourceLocation Loc, StringRef Namespace, diag.Severity Map2, StringRef Str) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out(NativePointer.$((String)"#pragma ")).$out(new StringRef(Namespace)).$out(NativePointer.$((String)" diagnostic "));
        switch (Map2) {
            case Remark: {
                this.OS.$out(NativePointer.$((String)"remark"));
                break;
            }
            case Warning: {
                this.OS.$out(NativePointer.$((String)"warning"));
                break;
            }
            case Error: {
                this.OS.$out(NativePointer.$((String)"error"));
                break;
            }
            case Ignored: {
                this.OS.$out(NativePointer.$((String)"ignored"));
                break;
            }
            case Fatal: {
                this.OS.$out(NativePointer.$((String)"fatal"));
            }
        }
        this.OS.$out(NativePointer.$((String)" \"")).$out(new StringRef(Str)).$out_char(NativePointer.$((char)'\"'));
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaWarning(SourceLocation Loc, StringRef WarningSpec, ArrayRefInt Ids) {
        this.startNewLineIfNeeded();
        this.MoveToLine(Loc);
        this.OS.$out((CharSequence)"#pragma warning(").$out(WarningSpec).$out(':');
        int.ptr I = (int.ptr)Native.$tryClone((NativeCloneable)Ids.begin());
        int.ptr E = (int.ptr)Native.$tryClone((NativeCloneable)Ids.end());
        while (I.$noteq((Object)E)) {
            this.OS.$out(' ').$out(I.$star());
            I.$preInc();
        }
        this.OS.$out(')');
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaWarningPush(SourceLocation Loc, int Level2) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out(NativePointer.$((String)"#pragma warning(push"));
        if (Level2 >= 0) {
            this.OS.$out(NativePointer.$((String)", ")).$out_int(Level2);
        }
        this.OS.$out_char(NativePointer.$((char)')'));
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaWarningPop(SourceLocation Loc) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out(NativePointer.$((String)"#pragma warning(pop)"));
        this.setEmittedDirectiveOnThisLine();
    }

    public boolean HandleFirstTokOnLine(Token Tok) {
        if (!this.MoveToLine(Tok.getLocation())) {
            return false;
        }
        long ColNo = this.SM.getExpansionColumnNumber(Tok.getLocation());
        if (ColNo <= 1L && Tok.is((short)65)) {
            this.OS.$out_char(NativePointer.$((char)' '));
        }
        while (ColNo > 1L) {
            this.OS.$out_char(NativePointer.$((char)' '));
            --ColNo;
        }
        return true;
    }

    public boolean MoveToLine(SourceLocation Loc) {
        return this.MoveToLine(Loc.getRawEncodingUInt());
    }

    public boolean MoveToLine(int Loc) {
        PresumedLoc PLoc = this.SM.getPresumedLoc(Loc);
        if (PLoc.isInvalid()) {
            return false;
        }
        return this.MoveToLineNo(PLoc.getLine()) || PLoc.getLine() == 1;
    }

    private boolean MoveToLineNo(long LineNo) {
        if (0L <= LineNo - this.CurLine && LineNo - this.CurLine <= 8L) {
            if (LineNo - this.CurLine == 1L) {
                this.OS.$out('\n');
            } else {
                if (LineNo == this.CurLine) {
                    return false;
                }
                String NewLines = "\n\n\n\n\n\n\n\n";
                this.OS.write((CharSequence)NewLines, LineNo - this.CurLine);
            }
        } else if (!this.DisableLineMarkers) {
            this.WriteLineInfo(LineNo, null, 0L);
        } else {
            this.startNewLineIfNeeded(false);
        }
        this.CurLine = LineNo;
        return true;
    }

    public boolean AvoidConcat(Token PrevPrevTok, Token PrevTok, Token Tok) {
        return this.ConcatInfo.AvoidConcat(PrevPrevTok, PrevTok, Tok);
    }

    public void WriteLineInfo(long LineNo) {
        this.WriteLineInfo(LineNo, null, 0L);
    }

    public void WriteLineInfo(long LineNo, char.ptr Extra) {
        this.WriteLineInfo(LineNo, Extra, 0L);
    }

    public void WriteLineInfo(long LineNo, char.ptr Extra, long ExtraLen) {
        this.startNewLineIfNeeded(false);
        if (this.UseLineDirective) {
            this.OS.$out(NativePointer.$((String)"#line")).$out_char(NativePointer.$((char)' ')).$out_uint(LineNo).$out_char(NativePointer.$((char)' ')).$out_char(NativePointer.$((char)'\"'));
            this.OS.write_escaped(this.CurFilename.$StringRef());
            this.OS.$out_char(NativePointer.$((char)'\"'));
        } else {
            this.OS.$out_char(NativePointer.$((char)'#')).$out_char(NativePointer.$((char)' ')).$out_uint(LineNo).$out_char(NativePointer.$((char)' ')).$out_char(NativePointer.$((char)'\"'));
            this.OS.write_escaped(this.CurFilename.$StringRef());
            this.OS.$out_char(NativePointer.$((char)'\"'));
            if (ExtraLen != 0L) {
                this.OS.write(Extra, ExtraLen);
            }
            if (this.FileType == SrcMgr.CharacteristicKind.C_System) {
                this.OS.write(NativePointer.$((String)" 3"), 2L);
            } else if (this.FileType == SrcMgr.CharacteristicKind.C_ExternCSystem) {
                this.OS.write(NativePointer.$((String)" 3 4"), 4L);
            }
        }
        this.OS.$out_char(NativePointer.$((char)'\n'));
    }

    public boolean LineMarkersAreDisabled() {
        return this.DisableLineMarkers;
    }

    public void HandleNewlinesInToken(char.ptr TokStr, long Len) {
        long NumNewlines = 0L;
        while (Len != 0L) {
            if (TokStr.$star() == 10 || TokStr.$star() == 13) {
                ++NumNewlines;
                if (Len != 1L && (TokStr.$at(1) == 10 || TokStr.$at(1) == 13) && TokStr.$at(0) != TokStr.$at(1)) {
                    TokStr.$preInc();
                    --Len;
                }
            }
            --Len;
            TokStr.$preInc();
        }
        if (NumNewlines == 0L) {
            return;
        }
        this.CurLine += NumNewlines;
    }

    public void MacroDefined(SourceLocation HashLoc, SourceLocation EodLoc, Token MacroNameTok, MacroDirective MD) {
        MacroInfo MI = MD.getMacroInfo();
        if (!this.DumpDefines || MI.isBuiltinMacro()) {
            return;
        }
        this.MoveToLine(MI.getRawDefinitionLoc());
        PrintPreprocessedOutputStatics.PrintMacroDefinition(MacroNameTok.getIdentifierInfo(), MI, this.PP, this.OS);
        this.setEmittedDirectiveOnThisLine();
    }

    public void MacroUndefined(SourceLocation HashLoc, SourceLocation EodLoc, Token MacroNameTok, MacroDirective MD) {
        if (!this.DumpDefines) {
            return;
        }
        this.MoveToLine(MacroNameTok.getLocation());
        this.OS.$out(NativePointer.$((String)"#undef ")).$out(MacroNameTok.getIdentifierInfo().getName());
        this.setEmittedDirectiveOnThisLine();
    }

    public void $destroy() {
        super.$destroy();
    }

    PrintPPOutputHelper $getPrintPPOutputHelper() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.PrintPPOutputHelperInUse) break block3;
                this.PrintPPOutputHelperInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$PrintPPOutputHelper;
    }

    void $releasePrintPPOutputHelper(PrintPPOutputHelper helper) {
        assert (helper == this.$PrintPPOutputHelper);
        assert (this.PrintPPOutputHelperInUse);
        if (!$assertionsDisabled) {
            this.PrintPPOutputHelperInUse = false;
            if (!false) {
                // empty if block
            }
        }
        this.$PrintPPOutputHelper.release();
    }
}

