/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.action;

import java.awt.event.ActionEvent;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.dlight.sendto.action.MessageAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class FutureAction {
    private static final int rpLimit = Integer.parseInt(System.getProperty("SendTo.maxParallelTasks", "5"));
    private static final AtomicInteger rpAvail = new AtomicInteger(rpLimit);
    private static final RequestProcessor rp = new RequestProcessor("FutureAction", rpLimit);
    private final String msg;
    private final Callable<Action> callable;
    private final AtomicReference<Action> actionRef = new AtomicReference();

    public FutureAction(String msg) {
        this.msg = msg;
        this.callable = null;
    }

    public FutureAction(Callable<Action> callable) {
        this.callable = callable;
        this.msg = null;
    }

    public Action getAction() {
        Action action = this.actionRef.get();
        if (action != null) {
            return action;
        }
        if (this.msg != null) {
            action = new MessageAction(this.msg);
            this.actionRef.set(action);
            return action;
        }
        try {
            final Action a = this.callable.call();
            if (a == null) {
                return null;
            }
            action = new AbstractAction((String)a.getValue("Name")){

                @Override
                public void actionPerformed(final ActionEvent e) {
                    if (rpAvail.getAndDecrement() <= 0) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(FutureAction.class, (String)"TaskWillBeQueued.message", (Object)((String)a.getValue("Name"))), 1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    rp.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                a.actionPerformed(e);
                            }
                            finally {
                                rpAvail.incrementAndGet();
                            }
                        }
                    });
                }
            };
            this.actionRef.set(action);
            return action;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

