/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.sites;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.web.clientproject.api.sites.SiteHelper;
import org.netbeans.modules.web.clientproject.sites.Bundle;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.openide.filesystems.FileObject;

public class SiteMobileBoilerplate
implements SiteTemplateImplementation {
    private static final Logger LOGGER = Logger.getLogger(SiteMobileBoilerplate.class.getName());
    private static final File LIB_FILE = new File(SiteHelper.getJsLibsDirectory(), "mobile-boilerplate-41.zip");

    public String getId() {
        return "MOBILE.BOILER";
    }

    public String getName() {
        return Bundle.SiteMobileBoilerplate_name();
    }

    public String getDescription() {
        return Bundle.SiteMobileBoilerplate_description();
    }

    public boolean isPrepared() {
        return LIB_FILE.isFile();
    }

    public void prepare() throws IOException {
        assert (!EventQueue.isDispatchThread());
        assert (!this.isPrepared());
        SiteHelper.download((String)"https://github.com/h5bp/mobile-boilerplate/archive/v4.1.0.zip", (File)LIB_FILE, null);
    }

    public void configure(SiteTemplateImplementation.ProjectProperties projectProperties) {
    }

    public void apply(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, ProgressHandle handle) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (!this.isPrepared()) {
            LOGGER.info("Template not correctly prepared, nothing to be applied");
            return;
        }
        String siteRootFolder = projectProperties.getSiteRootFolder();
        assert (siteRootFolder != null);
        SiteHelper.unzipProjectTemplate((FileObject)projectDir.getFileObject(siteRootFolder), (File)LIB_FILE, (ProgressHandle)handle, (String[])new String[0]);
    }

    public void cleanup() {
        if (LIB_FILE.isFile() && !LIB_FILE.delete()) {
            LIB_FILE.deleteOnExit();
        }
    }
}

