/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.gulp.exec;

import java.awt.EventQueue;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.gulp.GulpBuildTool;
import org.netbeans.modules.javascript.gulp.exec.Bundle;
import org.netbeans.modules.javascript.gulp.file.Gulpfile;
import org.netbeans.modules.javascript.gulp.options.GulpOptions;
import org.netbeans.modules.javascript.gulp.options.GulpOptionsValidator;
import org.netbeans.modules.javascript.gulp.util.FileUtils;
import org.netbeans.modules.javascript.gulp.util.GulpUtils;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.common.api.ExternalExecutable;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class GulpExecutable {
    static final Logger LOGGER = Logger.getLogger(GulpExecutable.class.getName());
    public static final String GULP_NAME = Utilities.isWindows() ? "gulp.cmd" : "gulp";
    private static final String NO_COLOR_PARAM = "--no-color";
    private static final String COLOR_PARAM = "--color";
    private static final String TASKS_PARAM = "--tasks-simple";
    private static final String SILENT_PARAM = "--silent";
    protected final Project project;
    protected final String gulpPath;

    GulpExecutable(String gulpPath, @NullAllowed Project project) {
        assert (gulpPath != null);
        this.gulpPath = gulpPath;
        this.project = project;
    }

    @CheckForNull
    public static GulpExecutable getDefault(@NullAllowed Project project, boolean showOptions) {
        ValidationResult result = new GulpOptionsValidator().validateGulp().getResult();
        if (GulpExecutable.validateResult(result) != null) {
            if (showOptions) {
                OptionsDisplayer.getDefault().open("Html5/Gulp");
            }
            return null;
        }
        return GulpExecutable.createExecutable(GulpOptions.getInstance().getGulp(), project);
    }

    private static GulpExecutable createExecutable(String gulp, Project project) {
        if (Utilities.isMac()) {
            return new MacGulpExecutable(gulp, project);
        }
        return new GulpExecutable(gulp, project);
    }

    String getCommand() {
        return this.gulpPath;
    }

    public Future<Integer> run(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = GulpUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.GulpExecutable_run(projectName)).additionalParameters(this.getRunParams(args)).run(this.getDescriptor());
        assert (task != null) : this.gulpPath;
        return task;
    }

    public Future<List<String>> listTasks() {
        final GulpTasksLineProcessor gulpTasksLineProcessor = new GulpTasksLineProcessor();
        Future task = this.getExecutable("list gulp tasks").noInfo(true).additionalParameters(Arrays.asList(NO_COLOR_PARAM, SILENT_PARAM, TASKS_PARAM)).redirectErrorStream(false).run(GulpExecutable.getSilentDescriptor(), new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.bridge((LineProcessor)gulpTasksLineProcessor);
            }
        });
        assert (task != null) : this.gulpPath;
        return new TaskList(task, gulpTasksLineProcessor);
    }

    private ExternalExecutable getExecutable(String title) {
        assert (title != null);
        return new ExternalExecutable(this.getCommand()).workDir(this.getWorkDir()).displayName(title).optionsPath("Html5/Gulp").noOutput(false);
    }

    private ExecutionDescriptor getDescriptor() {
        assert (this.project != null);
        return ExternalExecutable.DEFAULT_EXECUTION_DESCRIPTOR.showSuspended(true).optionsPath("Html5/Gulp").outLineBased(true).errLineBased(true).postExecution(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])new File[]{GulpExecutable.this.getWorkDir()});
            }
        });
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false).charset(StandardCharsets.UTF_8).outLineBased(true);
    }

    private File getWorkDir() {
        if (this.project == null) {
            return FileUtils.TMP_DIR;
        }
        Gulpfile gulpfile = GulpBuildTool.forProject(this.project).getGulpfile();
        if (gulpfile.exists()) {
            return gulpfile.getFile().getParentFile();
        }
        File workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (workDir != null) : this.project.getProjectDirectory();
        return workDir;
    }

    private List<String> getRunParams(String ... args) {
        ArrayList<String> params = new ArrayList<String>(args.length + 1);
        params.addAll(Arrays.asList(args));
        params.add(COLOR_PARAM);
        return this.getParams(params);
    }

    List<String> getParams(List<String> params) {
        assert (params != null);
        return params;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return result.getFirstErrorMessage();
        }
        return result.getFirstWarningMessage();
    }

    private static final class TaskList
    implements Future<List<String>> {
        private final Future<Integer> task;
        private final GulpTasksLineProcessor processor;
        private List<String> gulpTasks = null;

        TaskList(Future<Integer> task, GulpTasksLineProcessor processor) {
            assert (task != null);
            assert (processor != null);
            this.task = task;
            this.processor = processor;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                this.task.get();
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getGulpTasks();
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                this.task.get(timeout, unit);
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getGulpTasks();
        }

        private synchronized List<String> getGulpTasks() {
            if (this.gulpTasks != null) {
                return Collections.unmodifiableList(this.gulpTasks);
            }
            ArrayList<String> tasks = new ArrayList<String>(this.processor.getTasks());
            Collections.sort(tasks);
            this.gulpTasks = new CopyOnWriteArrayList<String>(tasks);
            return Collections.unmodifiableList(this.gulpTasks);
        }
    }

    private static final class GulpTasksLineProcessor
    implements LineProcessor {
        final List<String> tasks = new ArrayList<String>();

        private GulpTasksLineProcessor() {
        }

        public void processLine(String line) {
            if (StringUtilities.hasText((String)line)) {
                this.tasks.add(line);
            }
        }

        public void reset() {
        }

        public void close() {
        }

        public List<String> getTasks() {
            return Collections.unmodifiableList(this.tasks);
        }
    }

    private static final class MacGulpExecutable
    extends GulpExecutable {
        private static final String BASH_COMMAND = "/bin/bash -lc";

        MacGulpExecutable(String gulpPath, Project project) {
            super(gulpPath, project);
        }

        @Override
        String getCommand() {
            return BASH_COMMAND;
        }

        @Override
        List<String> getParams(List<String> params) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("\"");
            sb.append(this.gulpPath);
            sb.append("\" \"");
            sb.append(StringUtilities.implode(super.getParams(params), (String)"\" \""));
            sb.append("\"");
            return Collections.singletonList(sb.toString());
        }
    }
}

