/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;
import org.netbeans.modules.project.ui.Bundle;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.TemplateChooserPanelGUI;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.QuickSearch;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TemplatesPanelGUI
extends JPanel
implements PropertyChangeListener {
    public static final String TEMPLATES_FOLDER = "templatesFolder";
    public static final String TARGET_TEMPLATE = "targetTemplate";
    private static final String ATTR_INSTANTIATING_DESC = "instantiatingWizardURL";
    private static final String WAIT = "org/netbeans/modules/project/ui/resources/wait.gif";
    private static final Image PLEASE_WAIT_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/wait.gif");
    private static final RequestProcessor RP = new RequestProcessor(TemplatesPanelGUI.class);
    private Builder firer;
    private String presetTemplateName = null;
    private Node pleaseWait;
    private WizardDescriptor wiz;
    private String filterText;
    private JPanel categoriesPanel;
    private JEditorPane description;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JPanel panelFilter;
    private JPanel projectsPanel;

    public TemplatesPanelGUI(Builder firer) {
        assert (firer != null) : "Builder can not be null";
        this.firer = firer;
        this.initComponents();
        this.postInitComponents();
        this.setName(Bundle.TXT_SelectTemplate());
        QuickSearch quickSearch = QuickSearch.attach((JComponent)this.panelFilter, (Object)"Center", (QuickSearch.Callback)this.createQuickSearchCallback(), (boolean)true);
        this.adjustQuickSearch(quickSearch);
        Component qsComponent = this.panelFilter.getComponent(0);
        if (qsComponent instanceof JComponent) {
            for (Component c : ((JComponent)qsComponent).getComponents()) {
                if (!(c instanceof JLabel)) continue;
                JLabel jLabel = (JLabel)c;
                String text = NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"LBL_TemplateChooserPanelGUI_QuicksearchLabel");
                Mnemonics.setLocalizedText((JLabel)jLabel, (String)text);
            }
        }
    }

    public void setTemplatesFolder(FileObject folder) {
        DataFolder dobj = DataFolder.findFolder((FileObject)folder);
        dobj.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TemplatesPanelGUI.this.setSelectedCategoryByName(OpenProjectListSettings.getInstance().getLastSelectedProjectCategory());
                    }
                });
            }
        });
        ((ExplorerProviderPanel)this.categoriesPanel).setRootNode((Node)new FilterNode(dobj.getNodeDelegate(), this.firer.createCategoriesChildren(dobj, this.filterText)));
    }

    private FileObject getCurrentTemplatesFolder() {
        DataObject dob;
        FileObject res = null;
        Node rootNode = ((ExplorerProviderPanel)this.categoriesPanel).getExplorerManager().getRootContext();
        if (null != rootNode && null != (dob = (DataObject)rootNode.getLookup().lookup(DataObject.class))) {
            res = dob.getPrimaryFile();
        }
        return res;
    }

    public void setSelectedCategoryByName(String categoryName) {
        if (categoryName != null) {
            ((ExplorerProviderPanel)this.categoriesPanel).setSelectedNode(categoryName);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Node[] sel = ((ExplorerProviderPanel)TemplatesPanelGUI.this.categoriesPanel).getSelectedNodes();
                    if (sel.length == 1) {
                        ((CategoriesPanel)TemplatesPanelGUI.this.categoriesPanel).btv.expandNode(sel[0]);
                    }
                }
            });
        } else {
            ((CategoriesPanel)this.categoriesPanel).selectFirst();
        }
    }

    public String getSelectedCategoryName() {
        return ((ExplorerProviderPanel)this.categoriesPanel).getSelectionPath();
    }

    public void setSelectedTemplateByName(final String templateName) {
        this.presetTemplateName = templateName;
        final TemplatesPanel tempExplorer = (TemplatesPanel)this.projectsPanel;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (templateName != null) {
                    tempExplorer.setSelectedNode(templateName);
                    if (tempExplorer.getSelectionPath() == null) {
                        TemplatesPanelGUI.this.presetTemplateName = null;
                        tempExplorer.selectFirst();
                    }
                } else {
                    tempExplorer.selectFirst();
                }
            }
        });
    }

    public String getSelectedTemplateName() {
        return ((TemplatesPanel)this.projectsPanel).getSelectionPath();
    }

    public FileObject getSelectedTemplate() {
        DataObject dobj;
        Node[] nodes = ((ExplorerProviderPanel)this.projectsPanel).getSelectedNodes();
        if (nodes != null && nodes.length == 1 && (dobj = (DataObject)nodes[0].getLookup().lookup(DataObject.class)) != null) {
            while (dobj instanceof DataShadow) {
                dobj = ((DataShadow)dobj).getOriginal();
            }
            return dobj.getPrimaryFile();
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.jScrollPane1.setViewportView(this.description);
        this.jLabel3.setLabelFor(this.description);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.jScrollPane1.setViewportView(null);
        this.jLabel3.setLabelFor(null);
    }

    void setWizardDescriptor(WizardDescriptor wiz) {
        this.wiz = wiz;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.categoriesPanel) {
            Node[] selectedNodes;
            if ("selectedNodes".equals(event.getPropertyName()) && (selectedNodes = (Node[])event.getNewValue()) != null && selectedNodes.length == 1) {
                assert (this.pleaseWait == null || !this.pleaseWait.equals((Object)selectedNodes[0])) : "Cannot be fired a propertyChange with PleaseWaitNode, but was " + selectedNodes[0];
                try {
                    ((ExplorerProviderPanel)this.projectsPanel).setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
                DataObject template = (DataObject)selectedNodes[0].getLookup().lookup(DataFolder.class);
                if (template != null) {
                    FileObject fo = template.getPrimaryFile();
                    String templatePath = fo.getPath();
                    if (!template.isValid() && (fo = FileUtil.getConfigFile((String)templatePath)) != null) {
                        try {
                            template = DataObject.find((FileObject)fo);
                        }
                        catch (DataObjectNotFoundException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    ((ExplorerProviderPanel)this.projectsPanel).setRootNode((Node)new FilterNode(selectedNodes[0], this.firer.createTemplatesChildren((DataFolder)template, this.filterText)));
                    this.setSelectedTemplateByName(this.presetTemplateName);
                    if (this.wiz != null) {
                        if (templatePath.matches("Templates/Project/Samples($|/.+)")) {
                            this.wiz.putProperty("WizardPanel_infoMessage", (Object)Bundle.TemplatesPanelGUI_note_samples());
                        } else {
                            this.wiz.putProperty("WizardPanel_infoMessage", null);
                        }
                    }
                }
            }
        } else if (event.getSource() == this.projectsPanel && "selectedNodes".equals(event.getPropertyName())) {
            Node[] selectedNodes = (Node[])event.getNewValue();
            if (selectedNodes != null && selectedNodes.length == 1) {
                DataObject template = (DataObject)selectedNodes[0].getLookup().lookup(DataObject.class);
                if (template != null) {
                    URL descURL = this.getDescription(template);
                    if (descURL != null) {
                        try {
                            String charset = TemplatesPanelGUI.findEncodingFromURL(descURL.openStream());
                            ErrorManager.getDefault().log(1, "Url " + descURL + " has charset " + charset);
                            if (charset != null) {
                                this.description.putClientProperty("charset", charset);
                            }
                            this.description.read(descURL.openStream(), (Object)descURL);
                        }
                        catch (ChangedCharSetException x) {
                            Document doc = this.description.getEditorKit().createDefaultDocument();
                            doc.putProperty("IgnoreCharsetDirective", true);
                            try {
                                this.description.read(descURL.openStream(), (Object)doc);
                            }
                            catch (IOException ioe) {
                                ErrorManager.getDefault().notify(1, (Throwable)ioe);
                                this.description.setText(null);
                            }
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                            this.description.setText(null);
                        }
                        this.description.setCaretPosition(0);
                    } else {
                        this.description.setText(null);
                    }
                }
            } else {
                this.description.setText(null);
            }
            this.firer.fireChange();
        }
    }

    private void postInitComponents() {
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.firer.getCategoriesName());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)this.firer.getTemplatesName());
        this.description.setEditorKit(new HTMLEditorKit());
        this.description.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.pleaseWait = new AbstractNode(Children.LEAF){

            public Image getIcon(int ignore) {
                return PLEASE_WAIT_ICON;
            }
        };
        this.pleaseWait.setName(Bundle.LBL_TemplatesPanel_PleaseWait());
        Children.Array ch = new Children.Array();
        ch.add(new Node[]{this.pleaseWait});
        AbstractNode root = new AbstractNode((Children)ch);
        SwingUtilities.invokeLater(new Runnable((Node)root){
            final /* synthetic */ Node val$root;
            {
                this.val$root = node;
            }

            @Override
            public void run() {
                ((ExplorerProviderPanel)TemplatesPanelGUI.this.categoriesPanel).setRootNode(this.val$root);
            }
        });
        ((ExplorerProviderPanel)this.projectsPanel).addDefaultActionListener(this.firer);
        this.description.addHyperlinkListener(new ClickHyperlinks());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.categoriesPanel = new CategoriesPanel();
        this.projectsPanel = new TemplatesPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.description = new JEditorPane();
        this.panelFilter = new JPanel();
        this.setPreferredSize(new Dimension(500, 230));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.categoriesPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TemplatesPanelGUI.class, (String)"CTL_Categories"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.projectsPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TemplatesPanelGUI.class, (String)"CTL_Templates"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(2, 0, 6, 6);
        this.add((Component)this.categoriesPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(2, 6, 6, 0);
        this.add((Component)this.projectsPanel, gridBagConstraints);
        this.jLabel3.setLabelFor(this.description);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TemplatesPanelGUI.class, (String)"CTL_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.description.setEditable(false);
        this.description.setPreferredSize(new Dimension(100, 66));
        this.jScrollPane1.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.panelFilter.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.panelFilter, gridBagConstraints);
    }

    private URL getDescription(DataObject dobj) {
        FileObject fo = dobj.getPrimaryFile();
        URL desc = (URL)fo.getAttribute(ATTR_INSTANTIATING_DESC);
        if (desc != null) {
            return desc;
        }
        desc = TemplateWizard.getDescription((DataObject)dobj);
        return desc;
    }

    void warmUp(FileObject templatesFolder) {
        DataFolder df;
        if (templatesFolder != null && (df = DataFolder.findFolder((FileObject)templatesFolder)) != null) {
            df.getChildren();
        }
    }

    void doFinished(FileObject temlatesFolder, String category, String template) {
        assert (temlatesFolder != null);
        this.categoriesPanel.addPropertyChangeListener(this);
        this.projectsPanel.addPropertyChangeListener(this);
        this.setTemplatesFolder(temlatesFolder);
        this.setSelectedCategoryByName(category);
        this.setSelectedTemplateByName(template);
        this.categoriesPanel.requestFocus();
        if (this.description.getEditorKit() instanceof HTMLEditorKit) {
            HTMLEditorKit htmlkit = (HTMLEditorKit)this.description.getEditorKit();
            StyleSheet css = htmlkit.getStyleSheet();
            if (css.getStyleSheets() != null) {
                this.description.setFont(this.jLabel1.getFont());
                return;
            }
            StyleSheet css2 = new StyleSheet();
            Font f = this.jLabel1.getFont();
            css2.addRule(new StringBuffer("body { font-size: ").append(f.getSize()).append("; font-family: ").append(f.getName()).append("; }").toString());
            css2.addStyleSheet(css);
            htmlkit.setStyleSheet(css2);
        }
    }

    private static String findEncodingFromURL(InputStream stream) {
        try {
            byte[] arr = new byte[4096];
            int len = stream.read(arr, 0, arr.length);
            String txt = new String(arr, 0, len >= 0 ? len : 0, "ISO-8859-1").toUpperCase(Locale.ENGLISH);
            return TemplatesPanelGUI.findEncoding(txt);
        }
        catch (IOException x) {
            Logger.getLogger(TemplatesPanelGUI.class.getName()).log(Level.INFO, null, x);
            return null;
        }
    }

    private static String findEncoding(String txt) {
        int content;
        int headLen = txt.indexOf("</HEAD>");
        if (headLen == -1) {
            headLen = txt.length();
        }
        if ((content = txt.indexOf("CONTENT-TYPE")) == -1 || content > headLen) {
            return null;
        }
        int charset = txt.indexOf("CHARSET=", content);
        if (charset == -1) {
            return null;
        }
        int charend = txt.indexOf(34, charset);
        int charend2 = txt.indexOf(39, charset);
        if (charend == -1 && charend2 == -1) {
            return null;
        }
        if (charend2 != -1 && (charend == -1 || charend > charend2)) {
            charend = charend2;
        }
        return txt.substring(charset + "CHARSET=".length(), charend);
    }

    private QuickSearch.Callback createQuickSearchCallback() {
        return new QuickSearch.Callback(){

            public void quickSearchUpdate(String searchText) {
                if (null != searchText) {
                    searchText = searchText.toLowerCase();
                }
                TemplatesPanelGUI.this.filterText = searchText;
                TemplatesPanelGUI.this.refreshContent();
            }

            public void showNextSelection(boolean forward) {
            }

            public String findMaxPrefix(String prefix) {
                return prefix;
            }

            public void quickSearchConfirmed() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((CategoriesPanel)TemplatesPanelGUI.this.categoriesPanel).btv.requestFocus();
                    }
                });
            }

            public void quickSearchCanceled() {
                TemplatesPanelGUI.this.filterText = null;
                TemplatesPanelGUI.this.refreshContent();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TemplatesPanelGUI.this.clearQuickSearchField();
                        ((CategoriesPanel)TemplatesPanelGUI.this.categoriesPanel).btv.requestFocus();
                    }
                });
            }
        };
    }

    private void refreshContent() {
        FileObject folder = this.getCurrentTemplatesFolder();
        if (null != folder) {
            this.setTemplatesFolder(folder);
            this.setSelectedCategoryByName(null);
        }
    }

    private void adjustQuickSearch(QuickSearch qs) {
        JTextField textField;
        qs.setAlwaysShown(true);
        Component qsComponent = this.panelFilter.getComponent(0);
        if (qsComponent instanceof JComponent) {
            ((JComponent)qsComponent).setBorder(BorderFactory.createEmptyBorder());
        }
        if (null != (textField = this.getQuickSearchField())) {
            textField.setMaximumSize(null);
        }
    }

    private JTextField getQuickSearchField() {
        Component qsComponent = this.panelFilter.getComponent(0);
        if (qsComponent instanceof JComponent) {
            for (Component c : ((JComponent)qsComponent).getComponents()) {
                if (!(c instanceof JTextField)) continue;
                return (JTextField)c;
            }
        }
        return null;
    }

    private void clearQuickSearchField() {
        JTextField textField = this.getQuickSearchField();
        if (null != textField) {
            textField.setText(null);
        }
    }

    private static final class TemplatesPanel
    extends ExplorerProviderPanel {
        private ListView list;

        private TemplatesPanel() {
        }

        @Override
        protected synchronized JComponent createComponent() {
            if (this.list == null) {
                this.list = new TemplatesListView();
                this.list.setPopupAllowed(false);
                this.list.getAccessibleContext().setAccessibleName(Bundle.ACSN_TemplatesPanel());
                this.list.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_TemplatesPanel());
                Border b = (Border)UIManager.get("Nb.ScrollPane.border");
                if (b != null) {
                    this.list.setBorder(b);
                }
            }
            return this.list;
        }

        @Override
        void addDefaultActionListener(ActionListener al) {
            this.createComponent();
            ((TemplatesListView)this.list).setDefaultProcessor(al);
        }
    }

    private static class TemplatesListView
    extends ListView
    implements ActionListener {
        TemplatesListView() {
            this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
            this.setDefaultProcessor(this);
            ToolTipManager.sharedInstance().unregisterComponent(this.list);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static final class CategoriesPanel
    extends ExplorerProviderPanel {
        private CategoriesBeanTreeView btv;

        private CategoriesPanel() {
        }

        @Override
        protected synchronized JComponent createComponent() {
            if (this.btv == null) {
                this.btv = new CategoriesBeanTreeView();
                this.btv.setRootVisible(false);
                this.btv.setPopupAllowed(false);
                this.btv.setFocusable(false);
                this.btv.setDefaultActionAllowed(false);
                this.btv.getAccessibleContext().setAccessibleName(Bundle.ACSN_CategoriesPanel());
                this.btv.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_CategoriesPanel());
                this.btv.setDragSource(false);
                this.btv.setDropTarget(false);
                Border b = (Border)UIManager.get("Nb.ScrollPane.border");
                if (b != null) {
                    this.btv.setBorder(b);
                }
            }
            return this.btv;
        }
    }

    private static class CategoriesBeanTreeView
    extends BeanTreeView {
        CategoriesBeanTreeView() {
            this.tree.setEditable(false);
            this.tree.setLargeModel(false);
        }

        protected void showSelection(TreePath[] treePaths) {
            this.tree.getSelectionModel().setSelectionPaths(treePaths);
            if (treePaths.length == 1) {
                this.showPathWithoutExpansion(treePaths[0]);
            }
        }

        private void showPathWithoutExpansion(TreePath path) {
            Rectangle rect = this.tree.getPathBounds(path);
            if (rect != null) {
                TreeUI tmp = this.tree.getUI();
                int correction = 0;
                if (tmp instanceof BasicTreeUI) {
                    correction = ((BasicTreeUI)tmp).getLeftChildIndent();
                    correction += ((BasicTreeUI)tmp).getRightChildIndent();
                }
                rect.x = Math.max(0, rect.x - correction);
                rect.y += rect.height;
                if (rect.y >= 0) {
                    this.tree.scrollRectToVisible(rect);
                }
            }
        }
    }

    private static abstract class ExplorerProviderPanel
    extends JPanel
    implements ExplorerManager.Provider,
    PropertyChangeListener,
    VetoableChangeListener {
        private ExplorerManager manager = new ExplorerManager();

        protected ExplorerProviderPanel() {
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.manager.addVetoableChangeListener((VetoableChangeListener)this);
            this.initGUI();
        }

        public void setRootNode(Node node) {
            this.manager.setRootContext(node);
        }

        public Node getRootNode() {
            return this.manager.getRootContext();
        }

        public Node[] getSelectedNodes() {
            return this.manager.getSelectedNodes();
        }

        public void setSelectedNodes(Node[] nodes) throws PropertyVetoException {
            this.manager.setSelectedNodes(nodes);
        }

        public void setSelectedNode(String path) {
            if (path == null) {
                return;
            }
            StringTokenizer tk = new StringTokenizer(path, "/");
            final String[] names = new String[tk.countTokens()];
            int i = 0;
            while (tk.hasMoreTokens()) {
                names[i] = tk.nextToken();
                ++i;
            }
            RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Node node = NodeOp.findPath((Node)ExplorerProviderPanel.this.manager.getRootContext(), (String[])names);
                        if (node != null) {
                            ExplorerProviderPanel.this.setSelectedNodes(new Node[]{node});
                        }
                    }
                    catch (PropertyVetoException e) {
                    }
                    catch (NodeNotFoundException nodeNotFoundException) {
                        // empty catch block
                    }
                }
            });
        }

        public String getSelectionPath() {
            Node[] selectedNodes = this.manager.getSelectedNodes();
            if (selectedNodes == null || selectedNodes.length != 1) {
                return null;
            }
            Node rootNode = this.manager.getRootContext();
            String[] path = NodeOp.createPath((Node)selectedNodes[0], (Node)rootNode);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < path.length; ++i) {
                builder.append('/');
                builder.append(path[i]);
            }
            return builder.substring(1);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExplorerProviderPanel.this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
                }
            });
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Node[] newValue;
            if ("selectedNodes".equals(evt.getPropertyName()) && ((newValue = (Node[])evt.getNewValue()) == null || newValue.length != 1 && newValue.length != 0)) {
                throw new PropertyVetoException("Invalid length", evt);
            }
        }

        @Override
        public void requestFocus() {
            this.createComponent().requestFocus();
        }

        protected abstract JComponent createComponent();

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.gridheight = 0;
            c.fill = 1;
            c.anchor = 18;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JComponent component = this.createComponent();
            ((GridBagLayout)this.getLayout()).setConstraints(component, c);
            this.add(component);
        }

        void addDefaultActionListener(ActionListener al) {
        }

        public void selectFirst() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    final Children ch = ExplorerProviderPanel.this.getRootNode().getChildren();
                    if (ch.getNodesCount(true) > 0) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ExplorerProviderPanel.this.getSelectedNodes().length == 0) {
                                    try {
                                        ExplorerProviderPanel.this.getExplorerManager().setSelectedNodes(new Node[]{ch.getNodeAt(0)});
                                    }
                                    catch (PropertyVetoException x) {
                                        Logger.getLogger(TemplatesPanelGUI.class.getName()).log(Level.INFO, "race condition while selecting first of " + ExplorerProviderPanel.this.getRootNode(), x);
                                    }
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private static final class ClickHyperlinks
    implements HyperlinkListener {
        private ClickHyperlinks() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (HyperlinkEvent.EventType.ACTIVATED == evt.getEventType() && evt.getURL() != null) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(evt.getURL());
            }
        }
    }

    public static interface Builder
    extends ActionListener {
        public Children createCategoriesChildren(DataFolder var1, String var2);

        public Children createTemplatesChildren(DataFolder var1, String var2);

        public String getCategoriesName();

        public String getTemplatesName();

        public void fireChange();
    }
}

