/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Utilities;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class GeneratorUtils {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(GeneratorUtils.class.getName());
    public static final int GETTERS_ONLY = 1;
    public static final int SETTERS_ONLY = 2;

    private GeneratorUtils() {
    }

    public static void generateAllAbstractMethodImplementations(WorkingCopy wc, TreePath path) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
            ElementUtilities elemUtils = wc.getElementUtilities();
            clazz = gu.insertClassMembers(clazz, (Iterable)gu.createAbstractMethodImplementations(te, (Iterable)elemUtils.findUnimplementedMethods(te)));
            wc.rewrite(path.getLeaf(), (Tree)clazz);
        }
    }

    public static void generateAbstractMethodImplementations(WorkingCopy wc, TreePath path, List<? extends ExecutableElement> elements, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, GeneratorUtilities.get((WorkingCopy)wc).createAbstractMethodImplementations(te, elements), offset));
        }
    }

    public static void generateAbstractMethodImplementation(WorkingCopy wc, TreePath path, ExecutableElement element, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMember(wc, clazz, GeneratorUtilities.get((WorkingCopy)wc).createAbstractMethodImplementation(te, element), offset));
        }
    }

    public static void generateMethodOverrides(WorkingCopy wc, TreePath path, List<? extends ExecutableElement> elements, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, GeneratorUtilities.get((WorkingCopy)wc).createOverridingMethods(te, elements), offset));
        }
    }

    public static void generateMethodOverride(WorkingCopy wc, TreePath path, ExecutableElement element, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMember(wc, clazz, GeneratorUtilities.get((WorkingCopy)wc).createOverridingMethod(te, element), offset));
        }
    }

    public static void generateConstructor(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> initFields, ExecutableElement inheritedConstructor, int offset) {
        ClassTree clazz = (ClassTree)path.getLeaf();
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        Tree c2 = wc.resolveRewriteTarget((Tree)clazz);
        if (c2 instanceof ClassTree && clazz != c2) {
            clazz = (ClassTree)c2;
        }
        wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, Collections.singletonList(GeneratorUtilities.get((WorkingCopy)wc).createConstructor(te, initFields, inheritedConstructor)), offset));
    }

    public static void generateConstructors(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> initFields, List<? extends ExecutableElement> inheritedConstructors, int offset) {
        ClassTree clazz = (ClassTree)path.getLeaf();
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
        ArrayList<MethodTree> members = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : inheritedConstructors) {
            members.add(gu.createConstructor(te, initFields, executableElement));
        }
        wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, members, offset));
    }

    public static void generateGettersAndSetters(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> fields, int type, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
            ClassTree clazz = (ClassTree)path.getLeaf();
            ArrayList<MethodTree> members = new ArrayList<MethodTree>();
            for (VariableElement variableElement : fields) {
                if (type != 2) {
                    members.add(gu.createGetter(te, variableElement));
                }
                if (type == 1) continue;
                members.add(gu.createSetter(te, variableElement));
            }
            wc.rewrite((Tree)clazz, (Tree)GeneratorUtils.insertClassMembers(wc, clazz, members, offset));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ClassTree insertClassMembers(WorkingCopy wc, ClassTree clazz, List<? extends Tree> members, int offset) throws IllegalStateException {
        void var10_15;
        if (members.isEmpty()) {
            return clazz;
        }
        for (Tree tree : members) {
            Tree dup = GeneratorUtils.checkDuplicates(wc, clazz, tree);
            if (dup == null) continue;
            throw new DuplicateMemberException((int)wc.getTrees().getSourcePositions().getStartPosition(wc.getCompilationUnit(), dup));
        }
        if (offset < 0 || GeneratorUtils.getCodeStyle((CompilationInfo)wc).getClassMemberInsertionPoint() != CodeStyle.InsertionPoint.CARET_LOCATION) {
            return GeneratorUtilities.get((WorkingCopy)wc).insertClassMembers(clazz, members);
        }
        int index = 0;
        SourcePositions sourcePositions = wc.getTrees().getSourcePositions();
        GuardedDocument gdoc = null;
        try {
            Document doc = wc.getDocument();
            if (doc != null && doc instanceof GuardedDocument) {
                gdoc = (GuardedDocument)doc;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Tree lastMember = null;
        Tree nextMember = null;
        for (Tree tree : clazz.getMembers()) {
            if ((long)offset <= sourcePositions.getStartPosition(wc.getCompilationUnit(), tree)) {
                if (gdoc == null) {
                    nextMember = tree;
                    break;
                }
                int pos = (int)(lastMember != null ? sourcePositions.getEndPosition(wc.getCompilationUnit(), lastMember) : sourcePositions.getStartPosition(wc.getCompilationUnit(), clazz));
                pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                if ((long)pos <= sourcePositions.getStartPosition(wc.getCompilationUnit(), tree)) {
                    nextMember = tree;
                    break;
                }
            }
            ++index;
            lastMember = tree;
        }
        if (lastMember != null) {
            GeneratorUtils.moveCommentsAfterOffset(wc, lastMember, members.get(0), offset, gdoc);
        }
        if (nextMember != null) {
            GeneratorUtils.moveCommentsBeforeOffset(wc, nextMember, members.get(members.size() - 1), offset, gdoc);
        }
        TreeMaker tm = wc.getTreeMaker();
        int n = members.size() - 1;
        while (var10_15 >= 0) {
            clazz = tm.insertClassMember(clazz, index, members.get((int)var10_15));
            --var10_15;
        }
        return clazz;
    }

    public static ClassTree insertClassMember(WorkingCopy wc, ClassTree clazz, Tree member, int offset) throws IllegalStateException {
        return GeneratorUtils.insertClassMembers(wc, clazz, Collections.singletonList(member), offset);
    }

    private static void moveCommentsAfterOffset(WorkingCopy wc, Tree from, Tree to, int offset, GuardedDocument gdoc) {
        LinkedList<Comment> toMove = new LinkedList<Comment>();
        int idx = 0;
        int firstToRemove = -1;
        for (Comment comment : wc.getTreeUtilities().getComments(from, false)) {
            int epAfterBlock;
            if (comment.endPos() <= offset) {
                ++idx;
                continue;
            }
            if (gdoc != null && (epAfterBlock = gdoc.getGuardedBlockChain().adjustToBlockEnd(comment.endPos())) >= comment.endPos()) {
                ++idx;
                continue;
            }
            toMove.add(comment);
            if (firstToRemove == -1) {
                firstToRemove = idx;
            }
            ++idx;
        }
        if (toMove.isEmpty()) {
            return;
        }
        GeneratorUtils.doMoveComments(wc, from, to, offset, toMove, firstToRemove, idx);
    }

    private static void doMoveComments(WorkingCopy wc, Tree from, Tree to, int offset, List<Comment> comments, int fromIdx, int toIdx) {
        boolean before;
        if (comments.isEmpty()) {
            return;
        }
        TreeMaker tm = wc.getTreeMaker();
        Tree tree = from;
        switch (from.getKind()) {
            case METHOD: {
                tree = tm.setLabel(from, (CharSequence)((MethodTree)from).getName());
                break;
            }
            case VARIABLE: {
                tree = tm.setLabel(from, (CharSequence)((VariableTree)from).getName());
                break;
            }
            case BLOCK: {
                tree = tm.Block(((BlockTree)from).getStatements(), ((BlockTree)from).isStatic());
                GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
                gu.copyComments(from, tree, true);
                gu.copyComments(from, tree, false);
            }
        }
        boolean bl = before = (int)wc.getTrees().getSourcePositions().getStartPosition(wc.getCompilationUnit(), from) >= offset;
        if (fromIdx >= 0 && toIdx >= 0 && toIdx - fromIdx > 0) {
            for (int i = toIdx - 1; i >= fromIdx; --i) {
                tm.removeComment(tree, i, before);
            }
        }
        wc.rewrite(from, tree);
        for (Comment comment : comments) {
            tm.addComment(to, comment, comment.pos() <= offset);
        }
    }

    private static void moveCommentsBeforeOffset(WorkingCopy wc, Tree from, Tree to, int offset, GuardedDocument gdoc) {
        int epAfterBlock;
        Comment comment;
        LinkedList<Comment> toMove = new LinkedList<Comment>();
        int idx = 0;
        Iterator i$ = wc.getTreeUtilities().getComments(from, true).iterator();
        while (i$.hasNext() && (comment = (Comment)i$.next()).pos() < offset && comment.endPos() <= offset && (gdoc == null || (epAfterBlock = gdoc.getGuardedBlockChain().adjustToBlockEnd(comment.pos())) < comment.endPos())) {
            toMove.add(comment);
            ++idx;
        }
        if (toMove.size() > 0) {
            GeneratorUtils.doMoveComments(wc, from, to, offset, toMove, 0, idx);
        }
    }

    private static CodeStyle getCodeStyle(CompilationInfo info) {
        if (info != null) {
            try {
                Document doc = info.getDocument();
                if (doc != null) {
                    CodeStyle cs = (CodeStyle)doc.getProperty(CodeStyle.class);
                    return cs != null ? cs : CodeStyle.getDefault((Document)doc);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            FileObject file = info.getFileObject();
            if (file != null) {
                return CodeStyle.getDefault((FileObject)file);
            }
        }
        return CodeStyle.getDefault((Document)null);
    }

    public static boolean supportsOverride(@NonNull CompilationInfo info) {
        return SourceVersion.RELEASE_5.compareTo(info.getSourceVersion()) <= 0 && info.getElements().getTypeElement("java.lang.Override") != null;
    }

    private static List<TypeElement> getAllClasses(TypeElement of) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        TypeMirror sup = of.getSuperclass();
        TypeElement te = sup.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)sup).asElement() : null;
        result.add(of);
        if (te != null) {
            result.addAll(GeneratorUtils.getAllClasses(te));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + of);
        }
        return result;
    }

    static DialogDescriptor createDialogDescriptor(JComponent content, String label) {
        Object[] buttons = new JButton[2];
        buttons[0] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_button"));
        buttons[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorUtils.class, (String)"A11Y_Generate"));
        buttons[1] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_cancel_button"));
        DialogDescriptor dd = new DialogDescriptor((Object)content, label, true, buttons, (Object)buttons[0], 0, null, null);
        dd.addPropertyChangeListener(new PropertyChangeListener((JButton[])buttons, dd){
            final /* synthetic */ JButton[] val$buttons;
            final /* synthetic */ DialogDescriptor val$dd;
            {
                this.val$buttons = jButtonArray;
                this.val$dd = dialogDescriptor;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("valid".equals(evt.getPropertyName())) {
                    this.val$buttons[0].setEnabled(this.val$dd.isValid());
                }
            }
        });
        return dd;
    }

    public static void guardedCommit(JTextComponent component, ModificationResult mr) throws IOException {
        block2: {
            try {
                mr.commit();
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof GuardedException)) break block2;
                String message = NbBundle.getMessage(GeneratorUtils.class, (String)"ERR_CannotApplyGuarded");
                Utilities.setStatusBoldText((JTextComponent)component, (String)message);
                Logger.getLogger(GeneratorUtils.class.getName()).log(Level.FINE, null, e);
            }
        }
    }

    private static Tree checkDuplicates(WorkingCopy wc, ClassTree clazz, Tree member) {
        List<? extends VariableTree> memberParams = null;
        TreePath tp = null;
        for (Tree tree : clazz.getMembers()) {
            if (tp == null) {
                tp = new TreePath(wc.getCompilationUnit());
            }
            if (tree.getKind() == member.getKind() && !wc.getTreeUtilities().isSynthetic(new TreePath(tp, tree))) {
                block0 : switch (member.getKind()) {
                    case CLASS: {
                        if (!((ClassTree)member).getSimpleName().contentEquals(((ClassTree)tree).getSimpleName())) break;
                        return tree;
                    }
                    case VARIABLE: {
                        if (!((VariableTree)member).getName().contentEquals(((VariableTree)tree).getName())) break;
                        return tree;
                    }
                    case METHOD: {
                        if (!((MethodTree)member).getName().contentEquals(((MethodTree)tree).getName())) break;
                        if (memberParams == null) {
                            memberParams = ((MethodTree)member).getParameters();
                        }
                        List<? extends VariableTree> treeParams = ((MethodTree)tree).getParameters();
                        if (memberParams.size() != treeParams.size()) break;
                        Iterator<? extends VariableTree> memberIt = memberParams.iterator();
                        Iterator<? extends VariableTree> treeIt = treeParams.iterator();
                        while (memberIt.hasNext() && treeIt.hasNext()) {
                            TypeMirror mTM = wc.getTrees().getTypeMirror(new TreePath(tp, memberIt.next().getType()));
                            TypeMirror tTM = wc.getTrees().getTypeMirror(new TreePath(tp, treeIt.next().getType()));
                            if (wc.getTypes().isSameType(mTM, tTM)) continue;
                            break block0;
                        }
                        return tree;
                    }
                }
            }
        }
        return null;
    }

    public static class DuplicateMemberException
    extends IllegalStateException {
        private int pos;

        public DuplicateMemberException(int pos) {
            super("Class member already exists");
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

