/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementFilter;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.FeaturedNode;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.util.CharSequences;

public class XmlSTElements {

    public static class Root
    extends OT
    implements FeaturedNode {
        private String namespace;

        public Root(String namespace, CharSequence source) {
            super(Collections.emptyList(), "root", source, 0, source.length());
            this.namespace = namespace;
        }

        @Override
        public ElementType type() {
            return ElementType.ROOT;
        }

        @Override
        public Object getProperty(String propertyName) {
            if (propertyName.equalsIgnoreCase("namespace")) {
                return this.namespace;
            }
            return null;
        }
    }

    public static class Text
    extends ElementBase {
        public Text(CharSequence source, int from, int to) {
            super(source, from, to);
        }

        @Override
        public ElementType type() {
            return ElementType.TEXT;
        }

        @Override
        public String toString() {
            return super.toString() + " \"" + this.image() + "\"";
        }
    }

    static class ET
    extends NamedElement
    implements CloseTag {
        private OpenTag matchingOpenTag;

        public ET(CharSequence name, CharSequence source, int from, int to) {
            super(name, source, from, to);
        }

        @Override
        public ElementType type() {
            return ElementType.CLOSE_TAG;
        }

        @Override
        public OpenTag matchingOpenTag() {
            return this.matchingOpenTag;
        }

        void setMatchingOpenTag(OpenTag openTag) {
            this.matchingOpenTag = openTag;
        }
    }

    static class OT
    extends EmptyOT {
        private Collection<Element> children;
        private CloseTag matchingEndTag;
        private int logicalEndOffset;

        public OT(Collection<Attribute> attrs, CharSequence name, CharSequence source, int from, int to) {
            super(attrs, name, source, from, to);
            this.logicalEndOffset = to;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        void setMatchingEndTag(CloseTag endTag) {
            this.matchingEndTag = endTag;
        }

        @Override
        public CloseTag matchingCloseTag() {
            return this.matchingEndTag;
        }

        void addChild(Element child) {
            if (this.children == null) {
                this.children = new ArrayList<Element>(1);
            }
            this.children.add(child);
            ((ElementBase)child).setParent(this);
        }

        @Override
        public Collection<Element> children() {
            return this.children == null ? Collections.emptyList() : this.children;
        }

        @Override
        public Collection<Element> children(ElementType type) {
            ArrayList<Element> filtered = new ArrayList<Element>();
            for (Element e : this.children()) {
                if (e.type() != type) continue;
                filtered.add(e);
            }
            return filtered;
        }

        @Override
        public Collection<Element> children(ElementFilter filter) {
            ArrayList<Element> filtered = new ArrayList<Element>();
            for (Element e : this.children()) {
                if (!filter.accepts(e)) continue;
                filtered.add(e);
            }
            return filtered;
        }

        @Override
        public <T extends Element> Collection<T> children(Class<T> type) {
            ArrayList<T> filtered = new ArrayList<T>();
            for (Element child : this.children()) {
                if (!type.isAssignableFrom(child.getClass())) continue;
                filtered.add(type.cast(child));
            }
            return filtered;
        }

        void setLogicalEndOffset(int to) {
            this.logicalEndOffset = to;
        }

        @Override
        public int semanticEnd() {
            return this.logicalEndOffset;
        }
    }

    static class EmptyOT
    extends NamedElement
    implements OpenTag {
        private Collection<Attribute> attrs;

        public EmptyOT(Collection<Attribute> attrs, CharSequence name, CharSequence source, int from, int to) {
            super(name, source, from, to);
            this.attrs = attrs;
        }

        @Override
        public Collection<Attribute> attributes() {
            return this.attrs;
        }

        @Override
        public Collection<Attribute> attributes(AttributeFilter filter) {
            ArrayList<Attribute> filtered = new ArrayList<Attribute>(1);
            for (Attribute a : this.attributes()) {
                if (!filter.accepts(a)) continue;
                filtered.add(a);
            }
            return filtered;
        }

        @Override
        public Attribute getAttribute(String name) {
            for (Attribute a : this.attributes()) {
                if (!LexerUtils.equals((CharSequence)name, (CharSequence)a.name(), (boolean)true, (boolean)false)) continue;
                return a;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public CloseTag matchingCloseTag() {
            return null;
        }

        @Override
        public int semanticEnd() {
            return this.to();
        }

        @Override
        public Collection<Element> children() {
            return Collections.emptyList();
        }

        @Override
        public Collection<Element> children(ElementType type) {
            return Collections.emptyList();
        }

        @Override
        public ElementType type() {
            return ElementType.OPEN_TAG;
        }

        @Override
        public Collection<Element> children(ElementFilter filter) {
            return Collections.emptyList();
        }

        @Override
        public <T extends Element> Collection<T> children(Class<T> type) {
            return Collections.emptyList();
        }
    }

    static abstract class NamedElement
    extends ElementBase
    implements Named {
        private CharSequence name;

        public NamedElement(CharSequence name, CharSequence source, int from, int to) {
            super(source, from, to);
            this.name = name;
        }

        @Override
        public CharSequence name() {
            return this.name;
        }

        @Override
        public CharSequence namespacePrefix() {
            int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
            return colonIndex == -1 ? null : this.name().subSequence(0, colonIndex);
        }

        @Override
        public CharSequence unqualifiedName() {
            int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
            return colonIndex == -1 ? this.name() : this.name().subSequence(colonIndex + 1, this.name().length());
        }

        @Override
        public CharSequence id() {
            return this.name();
        }

        @Override
        public String toString() {
            return this.name() + "(" + this.type().name() + ")" + "; " + this.from() + "-" + this.to();
        }
    }

    static abstract class ElementBase
    implements Element {
        private CharSequence source;
        private int from;
        private int to;
        private Node parent;

        public ElementBase(CharSequence source, int from, int to) {
            this.source = source;
            this.from = from;
            this.to = to;
        }

        @Override
        public int from() {
            return this.from;
        }

        @Override
        public int to() {
            return this.to;
        }

        @Override
        public CharSequence image() {
            return this.source.subSequence(this.from, this.to);
        }

        @Override
        public CharSequence id() {
            return null;
        }

        @Override
        public Collection<ProblemDescription> problems() {
            return Collections.emptyList();
        }

        void setParent(Node parent) {
            this.parent = parent;
        }

        @Override
        public Node parent() {
            return this.parent;
        }

        public String toString() {
            return this.type().name() + "; " + this.from() + "-" + this.to();
        }
    }
}

