/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard.impl;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DTDWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    private int index;
    private final Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();
    protected transient WizardDescriptor.Panel[] panels;
    protected String encoding;

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard wizard) {
        SourceGroup[] folders;
        DataFolder df = null;
        Sources sources = project == null ? null : ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = folders = sources == null ? null : sources.getSourceGroups("java");
        if (folders == null || folders.length == 0) {
            folders = sources == null ? new SourceGroup[]{} : sources.getSourceGroups("generic");
        }
        try {
            df = wizard.getTargetFolder();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (df != null) {
            wizard.setTargetFolder(df);
            WizardDescriptor.Panel panel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])folders);
            return new WizardDescriptor.Panel[]{panel};
        }
        if (folders != null && folders.length != 0) {
            df = DataFolder.findFolder((FileObject)folders[0].getRootFolder());
            wizard.setTargetFolder(df);
        }
        WizardDescriptor.Panel panel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])folders);
        return new WizardDescriptor.Panel[]{panel};
    }

    public void initialize(TemplateWizard wizard) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        this.panels = this.createPanels(project, wizard);
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public Set instantiate(TemplateWizard wizard) throws IOException {
        EditCookie edit;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wizard);
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)wizard));
        if (dobj == null) {
            return Collections.emptySet();
        }
        this.encoding = EncodingUtil.getProjectEncoding((FileObject)df.getPrimaryFile());
        if (!EncodingUtil.isValidEncoding((String)this.encoding)) {
            this.encoding = "UTF-8";
        }
        if ((edit = (EditCookie)dobj.getCookie(EditCookie.class)) != null) {
            EditorCookie editorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
            StyledDocument doc = editorCookie.openDocument();
            this.fixEncoding(doc, this.encoding);
            SaveCookie save = (SaveCookie)dobj.getCookie(SaveCookie.class);
            if (save != null) {
                save.save();
            }
        }
        return Collections.singleton(dobj.getPrimaryFile());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator<ChangeListener> i = this.changeListeners.iterator();
        while (i.hasNext()) {
            try {
                i.next().stateChanged(event);
            }
            catch (Exception exception) {}
        }
    }

    public String name() {
        return NbBundle.getMessage(DTDWizardIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    void replaceInDocument(Document document, String replaceFrom, String replaceTo) {
        AbstractDocument doc = (AbstractDocument)document;
        int len = replaceFrom.length();
        try {
            String content = doc.getText(0, doc.getLength());
            int index = content.lastIndexOf(replaceFrom);
            while (index >= 0) {
                doc.replace(index, len, replaceTo, null);
                content = content.substring(0, index);
                index = content.lastIndexOf(replaceFrom);
            }
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
    }

    void fixEncoding(Document document, String encoding) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            document.insertString(19, " encoding=\"" + encoding + "\"", null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

