/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.action;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.action.EntityManagerGenerator;
import org.netbeans.modules.j2ee.persistence.action.GenerationOptions;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class UseEntityManagerCodeGenerator
implements CodeGenerator {
    private FileObject srcFile;

    static UseEntityManagerCodeGenerator createUseEntityManagerCodeGenerator(JTextComponent component, CompilationController cc, Element el) throws IOException {
        if (el.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement typeElement = (TypeElement)el;
        if (!UseEntityManagerCodeGenerator.isEnable(cc.getFileObject(), typeElement)) {
            return null;
        }
        return new UseEntityManagerCodeGenerator(cc.getFileObject());
    }

    public UseEntityManagerCodeGenerator(FileObject srcFile) {
        this.srcFile = srcFile;
    }

    public void invoke() {
        EntityManagerGenerator emGenerator = new EntityManagerGenerator(this.srcFile, this.srcFile.getName());
        GenerationOptions options = new GenerationOptions();
        options.setParameterName("object");
        options.setParameterType("Object");
        options.setMethodName("persist");
        options.setOperation(GenerationOptions.Operation.PERSIST);
        options.setReturnType("void");
        try {
            emGenerator.generate(options);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UseEntityManagerCodeGenerator.class, (String)"CTL_UseEntityManagerAction");
    }

    private static boolean isEnable(FileObject fileObject, TypeElement typeElement) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        if (ElementKind.INTERFACE == typeElement.getKind()) {
            return false;
        }
        DataObject dObj = null;
        try {
            dObj = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (dObj == null) {
            return false;
        }
        FileObject target = ((DataObject)dObj.getCookie(DataObject.class)).getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)target, (String)"classpath/compile");
        if (cp == null) {
            return false;
        }
        if (PersistenceScope.getPersistenceScope((FileObject)target) == null) {
            return false;
        }
        FileObject entityMgrRes = cp.findResource("javax/persistence/EntityManager.class");
        return entityMgrRes != null;
    }

    public static TreePath getPathElementOfKind(Tree.Kind kind, TreePath path) {
        return UseEntityManagerCodeGenerator.getPathElementOfKind(EnumSet.of(kind), path);
    }

    public static TreePath getPathElementOfKind(Set<Tree.Kind> kinds, TreePath path) {
        while (path != null) {
            if (kinds.contains((Object)path.getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<UseEntityManagerCodeGenerator> ret = new ArrayList<UseEntityManagerCodeGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            TreePath path = (TreePath)context.lookup(TreePath.class);
            TreePath treePath = path = path != null ? UseEntityManagerCodeGenerator.getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path) : null;
            if (component == null || controller == null || path == null) {
                return ret;
            }
            try {
                UseEntityManagerCodeGenerator gen;
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element elem = controller.getTrees().getElement(path);
                if (elem != null && (gen = UseEntityManagerCodeGenerator.createUseEntityManagerCodeGenerator(component, controller, elem)) != null) {
                    ret.add(gen);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return ret;
        }
    }
}

